/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import java.util.Collection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicateCollection;

public class SqmWhereClause
implements SqmPredicateCollection {
    private final NodeBuilder nodeBuilder;
    private SqmPredicate predicate;

    public SqmWhereClause(NodeBuilder nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
    }

    public SqmWhereClause(SqmPredicate predicate, NodeBuilder nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
        this.predicate = predicate;
    }

    public SqmWhereClause copy(SqmCopyContext context) {
        return new SqmWhereClause(this.predicate == null ? null : this.predicate.copy(context), this.nodeBuilder);
    }

    @Override
    public SqmPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void setPredicate(SqmPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public void applyPredicate(SqmPredicate predicate) {
        this.predicate = this.predicate == null ? predicate : this.nodeBuilder.and(this.predicate, predicate);
    }

    @Override
    public void applyPredicates(SqmPredicate ... predicates) {
        for (SqmPredicate sqmPredicate : predicates) {
            this.applyPredicate(sqmPredicate);
        }
    }

    @Override
    public void applyPredicates(Collection<SqmPredicate> predicates) {
        for (SqmPredicate sqmPredicate : predicates) {
            this.applyPredicate(sqmPredicate);
        }
    }

    public String toString() {
        return "where " + String.valueOf(this.predicate);
    }
}

