/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaFunctionRoot;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.JpaSetReturningFunction;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmCteRoot;
import org.hibernate.query.sqm.tree.domain.SqmDerivedRoot;
import org.hibernate.query.sqm.tree.domain.SqmFunctionRoot;
import org.hibernate.query.sqm.tree.expression.SqmSetReturningFunction;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public abstract class AbstractSqmSelectQuery<T>
extends AbstractSqmNode
implements SqmSelectQuery<T> {
    private final Map<String, SqmCteStatement<?>> cteStatements;
    private SqmQueryPart<T> sqmQueryPart;
    private final Class<T> resultType;

    public AbstractSqmSelectQuery(Class<T> resultType, NodeBuilder builder) {
        this(new SqmQuerySpec(builder), resultType, builder);
    }

    public AbstractSqmSelectQuery(SqmQueryPart<T> queryPart, Class<T> resultType, NodeBuilder builder) {
        super(builder);
        this.cteStatements = new LinkedHashMap();
        this.resultType = resultType;
        this.sqmQueryPart = queryPart;
    }

    protected AbstractSqmSelectQuery(NodeBuilder builder, Map<String, SqmCteStatement<?>> cteStatements, Class<T> resultType) {
        super(builder);
        this.cteStatements = cteStatements;
        this.resultType = resultType;
    }

    public AbstractSqmSelectQuery(SqmQueryPart<T> queryPart, Map<String, SqmCteStatement<?>> cteStatements, Class<T> resultType, NodeBuilder builder) {
        super(builder);
        this.cteStatements = cteStatements;
        this.resultType = resultType;
        this.sqmQueryPart = queryPart;
    }

    protected Map<String, SqmCteStatement<?>> copyCteStatements(SqmCopyContext context) {
        LinkedHashMap copies = new LinkedHashMap(this.cteStatements.size());
        for (Map.Entry<String, SqmCteStatement<?>> entry : this.cteStatements.entrySet()) {
            copies.put(entry.getKey(), (SqmCteStatement<?>)entry.getValue().copy(context));
        }
        return copies;
    }

    @Override
    public Collection<SqmCteStatement<?>> getCteStatements() {
        return this.cteStatements.values();
    }

    Map<String, SqmCteStatement<?>> getCteStatementMap() {
        return new LinkedHashMap(this.cteStatements);
    }

    @Override
    public SqmCteStatement<?> getCteStatement(String cteLabel) {
        return this.cteStatements.get(cteLabel);
    }

    @Override
    public Collection<? extends JpaCteCriteria<?>> getCteCriterias() {
        return this.cteStatements.values();
    }

    public <X> JpaCteCriteria<X> getCteCriteria(String cteName) {
        return this.cteStatements.get(cteName);
    }

    public <X> JpaCteCriteria<X> with(AbstractQuery<X> criteria) {
        return this.withInternal(SqmCreationHelper.acquireUniqueAlias(), criteria);
    }

    public <X> JpaCteCriteria<X> withRecursiveUnionAll(AbstractQuery<X> baseCriteria, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        return this.withInternal(SqmCreationHelper.acquireUniqueAlias(), baseCriteria, false, recursiveCriteriaProducer);
    }

    public <X> JpaCteCriteria<X> withRecursiveUnionDistinct(AbstractQuery<X> baseCriteria, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        return this.withInternal(SqmCreationHelper.acquireUniqueAlias(), baseCriteria, true, recursiveCriteriaProducer);
    }

    public <X> JpaCteCriteria<X> with(String name, AbstractQuery<X> criteria) {
        return this.withInternal(this.validateCteName(name), criteria);
    }

    public <X> JpaCteCriteria<X> withRecursiveUnionAll(String name, AbstractQuery<X> baseCriteria, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        return this.withInternal(this.validateCteName(name), baseCriteria, false, recursiveCriteriaProducer);
    }

    public <X> JpaCteCriteria<X> withRecursiveUnionDistinct(String name, AbstractQuery<X> baseCriteria, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        return this.withInternal(this.validateCteName(name), baseCriteria, true, recursiveCriteriaProducer);
    }

    private String validateCteName(String name) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Illegal empty CTE name");
        }
        if (!Character.isAlphabetic(name.charAt(0))) {
            throw new IllegalArgumentException(String.format("Illegal CTE name [%s]. Names must start with an alphabetic character!", name));
        }
        return name;
    }

    protected <X> JpaCteCriteria<X> withInternal(String name, AbstractQuery<X> criteria) {
        SqmCteStatement cteStatement = new SqmCteStatement(name, (SqmSelectQuery)criteria, this, this.nodeBuilder());
        if (this.cteStatements.putIfAbsent(name, cteStatement) != null) {
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getCteName() + " already exists");
        }
        return cteStatement;
    }

    protected <X> JpaCteCriteria<X> withInternal(String name, AbstractQuery<X> baseCriteria, boolean unionDistinct, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        SqmCteStatement cteStatement = new SqmCteStatement(name, (SqmSelectQuery)baseCriteria, unionDistinct, recursiveCriteriaProducer, this, this.nodeBuilder());
        if (this.cteStatements.putIfAbsent(name, cteStatement) != null) {
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getCteName() + " already exists");
        }
        return cteStatement;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    @Override
    public SqmQuerySpec<T> getQuerySpec() {
        return this.sqmQueryPart.getFirstQuerySpec();
    }

    @Override
    public SqmQueryPart<T> getQueryPart() {
        return this.sqmQueryPart;
    }

    public void setQueryPart(SqmQueryPart<T> sqmQueryPart) {
        this.sqmQueryPart = sqmQueryPart;
    }

    public Set<Root<?>> getRoots() {
        return Collections.unmodifiableSet(((SqmQuerySpec)this.getQuerySpec()).getRoots());
    }

    public List<? extends JpaRoot<?>> getRootList() {
        return ((SqmQuerySpec)this.getQuerySpec()).getRootList();
    }

    public <E> JpaRoot<? extends E> getRoot(int position, Class<E> type) {
        List<SqmRoot<?>> rootList = ((SqmQuerySpec)this.getQuerySpec()).getRootList();
        if (rootList.size() <= position) {
            throw new IllegalArgumentException("Not enough root entities");
        }
        return AbstractSqmSelectQuery.castRoot((JpaRoot)rootList.get(position), type);
    }

    public <E> JpaRoot<? extends E> getRoot(String alias, Class<E> type) {
        List<SqmRoot<?>> rootList = ((SqmQuerySpec)this.getQuerySpec()).getRootList();
        for (SqmRoot<?> root : rootList) {
            String rootAlias = root.getAlias();
            if (rootAlias == null || !rootAlias.equals(alias)) continue;
            return AbstractSqmSelectQuery.castRoot(root, type);
        }
        throw new IllegalArgumentException("No root entity with alias " + alias);
    }

    private static <E> JpaRoot<? extends E> castRoot(JpaRoot<?> root, Class<E> type) {
        Class rootEntityType = root.getJavaType();
        if (rootEntityType == null) {
            throw new AssertionFailure("Java type of root entity was null");
        }
        if (!type.isAssignableFrom(rootEntityType)) {
            throw new IllegalArgumentException("Root entity of type '" + rootEntityType.getTypeName() + "' did not have the given type '" + type.getTypeName() + "'");
        }
        JpaRoot<?> result = root;
        return result;
    }

    @Override
    public <X> SqmRoot<X> from(Class<X> entityClass) {
        return this.addRoot(new SqmRoot(this.nodeBuilder().getDomainModel().entity((Class)entityClass), null, true, this.nodeBuilder()));
    }

    @Override
    public <X> SqmDerivedRoot<X> from(Subquery<X> subquery) {
        this.validateComplianceFromSubQuery();
        SqmDerivedRoot root = new SqmDerivedRoot((SqmSubQuery)subquery, null);
        this.addRoot(root);
        return root;
    }

    @Override
    public <X> JpaRoot<X> from(JpaCteCriteria<X> cte) {
        SqmCteRoot root = new SqmCteRoot((SqmCteStatement)cte, null);
        this.addRoot(root);
        return root;
    }

    @Override
    public <X> JpaFunctionRoot<X> from(JpaSetReturningFunction<X> function) {
        SqmFunctionRoot root = new SqmFunctionRoot((SqmSetReturningFunction)function, null);
        this.addRoot(root);
        return root;
    }

    private <X> SqmRoot<X> addRoot(SqmRoot<X> root) {
        ((SqmQuerySpec)this.getQuerySpec()).addRoot(root);
        return root;
    }

    @Override
    public <X> SqmRoot<X> from(EntityType<X> entityType) {
        return this.addRoot(new SqmRoot((EntityDomainType)entityType, null, true, this.nodeBuilder()));
    }

    private void validateComplianceFromSubQuery() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support subqueries in the from clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    public boolean isDistinct() {
        return ((SqmQuerySpec)this.getQuerySpec()).isDistinct();
    }

    @Override
    public SqmSelectQuery<T> distinct(boolean distinct) {
        ((SqmQuerySpec)this.getQuerySpec()).setDistinct(distinct);
        return this;
    }

    @Override
    public JpaSelection<T> getSelection() {
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection();
    }

    @Override
    public SqmPredicate getRestriction() {
        return ((SqmQuerySpec)this.getQuerySpec()).getRestriction();
    }

    @Override
    public SqmSelectQuery<T> where(Expression<Boolean> restriction) {
        ((SqmQuerySpec)this.getQuerySpec()).setRestriction((Expression)restriction);
        return this;
    }

    @Override
    public SqmSelectQuery<T> where(Predicate ... restrictions) {
        ((SqmQuerySpec)this.getQuerySpec()).setRestriction(restrictions);
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return Collections.unmodifiableList(((SqmQuerySpec)this.getQuerySpec()).getGroupingExpressions());
    }

    @Override
    public SqmSelectQuery<T> groupBy(Expression<?> ... expressions) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupingExpressions(List.of(expressions));
        return this;
    }

    @Override
    public SqmSelectQuery<T> groupBy(List<Expression<?>> grouping) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupingExpressions(grouping);
        return this;
    }

    @Override
    public SqmPredicate getGroupRestriction() {
        return ((SqmQuerySpec)this.getQuerySpec()).getGroupRestriction();
    }

    @Override
    public SqmSelectQuery<T> having(Expression<Boolean> booleanExpression) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupRestriction(this.nodeBuilder().wrap((Expression)booleanExpression));
        return this;
    }

    @Override
    public SqmSelectQuery<T> having(Predicate ... predicates) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupRestriction(this.nodeBuilder().wrap((Expression[])predicates));
        return this;
    }

    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        if (!this.cteStatements.isEmpty()) {
            hql.append("with ");
            for (SqmCteStatement<?> value : this.cteStatements.values()) {
                value.appendHqlString(hql, context);
                hql.append(", ");
            }
            hql.setLength(hql.length() - 2);
        }
        this.sqmQueryPart.appendHqlString(hql, context);
    }

    protected Selection<? extends T> getResultSelection(Selection<?>[] selections) {
        Class<T> resultType = this.getResultType();
        if (resultType == null || resultType == Object.class) {
            switch (selections.length) {
                case 0: {
                    throw new IllegalArgumentException("Empty selections passed to criteria query typed as Object");
                }
                case 1: {
                    return selections[0];
                }
            }
            return this.nodeBuilder().array((Selection[])selections);
        }
        if (Tuple.class.isAssignableFrom(resultType)) {
            return this.nodeBuilder().tuple((Selection[])selections);
        }
        if (resultType.isArray()) {
            return this.nodeBuilder().array(resultType, selections);
        }
        return this.nodeBuilder().construct(resultType, (Selection[])selections);
    }
}

