/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmJpaCompoundSelection<T>
extends AbstractSqmExpression<T>
implements JpaCompoundSelection<T>,
SqmExpressible<T> {
    private final List<? extends SqmSelectableNode<?>> selectableNodes;
    private final JavaType<T> javaType;

    public SqmJpaCompoundSelection(List<? extends SqmSelectableNode<?>> selectableNodes, JavaType<T> javaType, NodeBuilder criteriaBuilder) {
        super(null, criteriaBuilder);
        this.selectableNodes = selectableNodes;
        this.javaType = javaType;
    }

    @Override
    public SqmJpaCompoundSelection<T> copy(SqmCopyContext context) {
        SqmJpaCompoundSelection existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmTypedNode> selectableNodes = new ArrayList<SqmTypedNode>(this.selectableNodes.size());
        for (SqmSelectableNode<?> selectableNode : this.selectableNodes) {
            selectableNodes.add(selectableNode.copy(context));
        }
        return context.registerCopy(this, new SqmJpaCompoundSelection<T>(selectableNodes, this.javaType, this.nodeBuilder()));
    }

    @Override
    public JavaType<T> getJavaTypeDescriptor() {
        return this.javaType;
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Override
    public Class<T> getJavaType() {
        return this.getJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public List<? extends SqmSelectableNode<?>> getSelectionItems() {
        return this.selectableNodes;
    }

    @Override
    public JpaSelection<T> alias(String name) {
        return this;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public boolean isCompoundSelection() {
        return true;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitJpaCompoundSelection(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.selectableNodes.get(0).appendHqlString(hql, context);
        for (int i = 1; i < this.selectableNodes.size(); ++i) {
            hql.append(", ");
            this.selectableNodes.get(i).appendHqlString(hql, context);
        }
    }

    @Override
    public void visitSubSelectableNodes(Consumer<SqmSelectableNode<?>> jpaSelectionConsumer) {
        this.selectableNodes.forEach(jpaSelectionConsumer);
    }

    @Override
    public SqmDomainType<T> getSqmType() {
        return null;
    }
}

