/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmAliasedExpressionContainer;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmSelectClause
extends AbstractSqmNode
implements SqmAliasedExpressionContainer<SqmSelection<?>>,
JpaSelection<Object> {
    private boolean distinct;
    private List<SqmSelection<?>> selections;

    public SqmSelectClause(boolean distinct, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.distinct = distinct;
    }

    public SqmSelectClause(boolean distinct, int expectedNumberOfSelections, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.distinct = distinct;
        this.selections = CollectionHelper.arrayList(expectedNumberOfSelections);
    }

    @Override
    public SqmSelectClause copy(SqmCopyContext context) {
        SqmSelectClause selectClause = new SqmSelectClause(this.distinct, this.nodeBuilder());
        if (this.selections != null) {
            selectClause.selections = new ArrayList(this.selections.size());
            for (SqmSelection<?> selection : this.selections) {
                selectClause.selections.add((SqmSelection<?>)selection.copy(context));
            }
        }
        return selectClause;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void makeDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<SqmSelection<?>> getSelections() {
        if (this.selections == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.selections);
    }

    public void addSelection(SqmSelection<?> selection) {
        if (this.selections == null) {
            this.selections = new ArrayList();
        }
        this.selections.add(selection);
    }

    @Override
    public SqmSelection<?> add(SqmExpression<?> expression, String alias) {
        SqmSelection selection = new SqmSelection(expression, alias, this.nodeBuilder());
        this.addSelection(selection);
        return selection;
    }

    @Override
    public void add(SqmSelection<?> aliasExpression) {
        this.addSelection(aliasExpression);
    }

    public void setSelection(SqmSelection<?> sqmSelection) {
        if (this.selections != null) {
            this.selections.clear();
        }
        this.addSelection(sqmSelection);
    }

    public void setSelection(SqmSelectableNode<?> selectableNode) {
        this.setSelection(new SqmSelection(selectableNode, selectableNode.getAlias(), this.nodeBuilder()));
    }

    public JpaSelection<?> resolveJpaSelection() {
        return this.selections != null && this.selections.size() == 1 ? this.selections.get(0).getSelectableNode() : this;
    }

    @Override
    public List<SqmSelectableNode<?>> getSelectionItems() {
        ArrayList subSelections = new ArrayList();
        if (this.selections != null) {
            if (this.selections.size() == 1) {
                this.selections.get(0).getSelectableNode().visitSubSelectableNodes(subSelections::add);
            } else {
                for (SqmSelection<?> selection : this.selections) {
                    selection.getSelectableNode().visitSubSelectableNodes(subSelections::add);
                }
            }
        }
        return subSelections;
    }

    @Override
    public JpaSelection<Object> alias(String name) {
        return null;
    }

    public boolean isCompoundSelection() {
        return true;
    }

    @Override
    public JavaType<Object> getJavaTypeDescriptor() {
        return null;
    }

    public String getAlias() {
        return null;
    }
}

