/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import jakarta.persistence.criteria.Nulls;
import java.util.Objects;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortDirection;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmSortSpecification
implements JpaOrder {
    private final SqmExpression sortExpression;
    private final SortDirection sortOrder;
    private final boolean ignoreCase;
    private Nulls nullPrecedence;

    public SqmSortSpecification(SqmExpression sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        this(sortExpression, sortOrder, nullPrecedence, false);
    }

    public SqmSortSpecification(SqmExpression<?> sortExpression, SortDirection sortOrder, Nulls nullPrecedence, boolean ignoreCase) {
        assert (sortExpression != null);
        assert (sortOrder != null);
        assert (nullPrecedence != null);
        this.sortExpression = sortExpression;
        this.sortOrder = sortOrder;
        this.nullPrecedence = nullPrecedence;
        this.ignoreCase = ignoreCase;
    }

    @Deprecated(since="7", forRemoval=true)
    public SqmSortSpecification(SqmExpression sortExpression, SortDirection sortOrder, NullPrecedence nullPrecedence) {
        this(sortExpression, sortOrder, nullPrecedence.getJpaValue());
    }

    public SqmSortSpecification(SqmExpression sortExpression) {
        this(sortExpression, SortDirection.ASCENDING, Nulls.NONE);
    }

    public SqmSortSpecification(SqmExpression sortExpression, SortDirection sortOrder) {
        this(sortExpression, sortOrder, Nulls.NONE);
    }

    public SqmSortSpecification copy(SqmCopyContext context) {
        return new SqmSortSpecification((SqmExpression<?>)this.sortExpression.copy(context), this.sortOrder, this.nullPrecedence, this.ignoreCase);
    }

    public SqmExpression<?> getSortExpression() {
        return this.sortExpression;
    }

    @Override
    public SortDirection getSortDirection() {
        return this.sortOrder;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public JpaOrder nullPrecedence(Nulls nullPrecedence) {
        this.nullPrecedence = nullPrecedence;
        return this;
    }

    @Override
    public Nulls getNullPrecedence() {
        return this.nullPrecedence;
    }

    @Override
    public JpaOrder reverse() {
        SortDirection newSortOrder = this.sortOrder == null ? SortDirection.DESCENDING : this.sortOrder.reverse();
        return new SqmSortSpecification(this.sortExpression, newSortOrder, this.nullPrecedence, this.ignoreCase);
    }

    @Override
    public JpaExpression<?> getExpression() {
        return this.getSortExpression();
    }

    public boolean isAscending() {
        return this.sortOrder == SortDirection.ASCENDING;
    }

    public void appendHqlString(StringBuilder sb, SqmRenderContext context) {
        this.sortExpression.appendHqlString(sb, context);
        if (this.sortOrder == SortDirection.DESCENDING) {
            sb.append(" desc");
            if (this.nullPrecedence != null) {
                if (this.nullPrecedence == Nulls.FIRST) {
                    sb.append(" nulls first");
                } else {
                    sb.append(" nulls last");
                }
            }
        } else if (this.nullPrecedence != null) {
            sb.append(" asc");
            if (this.nullPrecedence == Nulls.FIRST) {
                sb.append(" nulls first");
            } else {
                sb.append(" nulls last");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqmSortSpecification)) {
            return false;
        }
        SqmSortSpecification that = (SqmSortSpecification)o;
        return Objects.equals(this.sortExpression, that.sortExpression) && this.sortOrder == that.sortOrder && this.nullPrecedence == that.nullPrecedence;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sortExpression, this.sortOrder, this.nullPrecedence});
    }
}

