/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tuple.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.Incubating;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralPersistentAttribute;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tuple.TupleType;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleSimpleSqmPathSource;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleSqmAssociationPathSourceNew;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ObjectArrayJavaType;

@Incubating
public class AnonymousTupleType<T>
implements TupleType<T>,
SqmDomainType<T>,
SqmPathSource<T> {
    private final JavaType<T> javaTypeDescriptor;
    private final @Nullable NavigablePath[] componentSourcePaths;
    private final SqmBindableType<?>[] expressibles;
    private final String[] componentNames;
    private final Map<String, Integer> componentIndexMap;

    public AnonymousTupleType(SqmSubQuery<T> subQuery) {
        this(AnonymousTupleType.extractSqmExpressibles(subQuery));
    }

    public AnonymousTupleType(SqmSelectableNode<?>[] components) {
        int i;
        this.expressibles = new SqmBindableType[components.length];
        this.componentSourcePaths = new NavigablePath[components.length];
        for (i = 0; i < components.length; ++i) {
            this.expressibles[i] = components[i].getNodeType();
            SqmSelectableNode<?> sqmSelectableNode = components[i];
            if (!(sqmSelectableNode instanceof SqmPath)) continue;
            SqmPath path = (SqmPath)sqmSelectableNode;
            this.componentSourcePaths[i] = path.getNavigablePath();
        }
        this.componentNames = new String[components.length];
        this.javaTypeDescriptor = new ObjectArrayJavaType(AnonymousTupleType.getTypeDescriptors(components));
        this.componentIndexMap = CollectionHelper.linkedMapOfSize(components.length);
        for (i = 0; i < components.length; ++i) {
            SqmSelectableNode<?> component = components[i];
            String alias = component.getAlias();
            if (alias == null) {
                throw new SemanticException("Select item at position " + (i + 1) + " in select list has no alias (aliases are required in CTEs and in subqueries occurring in from clause)");
            }
            this.componentIndexMap.put(alias, i);
            this.componentNames[i] = alias;
        }
    }

    public AnonymousTupleType(SqmBindableType<?>[] expressibles, String[] componentNames) {
        this.expressibles = expressibles;
        this.componentNames = componentNames;
        this.componentSourcePaths = new NavigablePath[componentNames.length];
        this.componentIndexMap = CollectionHelper.linkedMapOfSize(expressibles.length);
        int elementIndex = -1;
        for (int i = 0; i < componentNames.length; ++i) {
            if (CollectionPart.Nature.ELEMENT.getName().equals(componentNames[i])) {
                elementIndex = i;
            }
            this.componentIndexMap.put(componentNames[i], i);
        }
        this.javaTypeDescriptor = elementIndex == -1 ? new ObjectArrayJavaType(AnonymousTupleType.getTypeDescriptors(expressibles)) : expressibles[elementIndex].getExpressibleJavaType();
    }

    @Override
    public String getTypeName() {
        return SqmDomainType.super.getTypeName();
    }

    private static SqmSelectableNode<?>[] extractSqmExpressibles(SqmSubQuery<?> subQuery) {
        SqmSelectClause selectClause = ((SqmQuerySpec)subQuery.getQuerySpec()).getSelectClause();
        if (selectClause == null || selectClause.getSelectionItems().isEmpty()) {
            throw new IllegalArgumentException("subquery has no selection items");
        }
        return (SqmSelectableNode[])selectClause.getSelectionItems().toArray(SqmSelectableNode[]::new);
    }

    private static JavaType<?>[] getTypeDescriptors(SqmSelectableNode<?>[] components) {
        JavaType[] typeDescriptors = new JavaType[components.length];
        for (int i = 0; i < components.length; ++i) {
            typeDescriptors[i] = components[i].getExpressible().getExpressibleJavaType();
        }
        return typeDescriptors;
    }

    private static JavaType<?>[] getTypeDescriptors(SqmExpressible<?>[] components) {
        JavaType[] typeDescriptors = new JavaType[components.length];
        for (int i = 0; i < components.length; ++i) {
            typeDescriptors[i] = components[i].getExpressibleJavaType();
        }
        return typeDescriptors;
    }

    public static SqlTypedMapping[] toSqlTypedMappings(List<SqlSelection> sqlSelections) {
        SqlTypedMapping[] jdbcMappings = new SqlTypedMapping[sqlSelections.size()];
        for (int i = 0; i < sqlSelections.size(); ++i) {
            SqlTypedMapping sqlTypedMapping;
            JdbcMappingContainer expressionType = sqlSelections.get(i).getExpressionType();
            if (expressionType instanceof SqlTypedMapping) {
                SqlTypedMapping sqlTypedMapping2 = (SqlTypedMapping)((Object)expressionType);
                sqlTypedMapping = sqlTypedMapping2;
            } else {
                sqlTypedMapping = new SqlTypedMappingImpl(expressionType.getSingleJdbcMapping());
            }
            jdbcMappings[i] = sqlTypedMapping;
        }
        return jdbcMappings;
    }

    public AnonymousTupleTableGroupProducer resolveTableGroupProducer(String aliasStem, List<SqlSelection> sqlSelections, FromClauseAccess fromClauseAccess) {
        return this.resolveTableGroupProducer(aliasStem, AnonymousTupleType.toSqlTypedMappings(sqlSelections), fromClauseAccess);
    }

    public AnonymousTupleTableGroupProducer resolveTableGroupProducer(String aliasStem, SqlTypedMapping[] jdbcMappings, FromClauseAccess fromClauseAccess) {
        return new AnonymousTupleTableGroupProducer(this, aliasStem, jdbcMappings, fromClauseAccess);
    }

    @Override
    public int componentCount() {
        return this.expressibles.length;
    }

    @Override
    public String getComponentName(int index) {
        return this.componentNames[index];
    }

    @Override
    public List<String> getComponentNames() {
        return new ArrayList<String>(this.componentIndexMap.keySet());
    }

    @Override
    public SqmBindableType<?> get(int index) {
        return this.expressibles[index];
    }

    @Override
    public SqmBindableType<?> get(String componentName) {
        Integer index = this.componentIndexMap.get(componentName);
        return index == null ? null : this.expressibles[index];
    }

    protected Integer getIndex(String componentName) {
        return this.componentIndexMap.get(componentName);
    }

    public @Nullable NavigablePath getComponentSourcePath(int index) {
        return this.componentSourcePaths[index];
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        Integer index = this.componentIndexMap.get(name);
        return index == null ? null : AnonymousTupleType.subpathSource(name, this.expressibles[index]);
    }

    private static <T> SqmPathSource<T> subpathSource(String name, SqmExpressible<T> expressible) {
        SqmDomainType<T> sqmType = expressible.getSqmType();
        if (expressible instanceof SqmPluralPersistentAttribute) {
            SqmPluralPersistentAttribute pluralAttribute = (SqmPluralPersistentAttribute)expressible;
            return new AnonymousTupleSqmAssociationPathSourceNew(name, pluralAttribute, sqmType, pluralAttribute.getElementType());
        }
        if (sqmType instanceof BasicDomainType) {
            return new AnonymousTupleSimpleSqmPathSource<T>(name, sqmType, Bindable.BindableType.SINGULAR_ATTRIBUTE);
        }
        if (sqmType instanceof SimpleDomainType) {
            return new AnonymousTupleSqmAssociationPathSourceNew(name, (SqmPathSource)expressible, sqmType, (SimpleDomainType)((Object)sqmType));
        }
        throw new AssertionFailure("Unsupported domain type " + String.valueOf(sqmType));
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.javaTypeDescriptor;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    @Override
    public String getPathName() {
        return "tuple" + System.identityHashCode(this);
    }

    @Override
    public SqmDomainType<T> getPathType() {
        return this;
    }

    @Override
    public SqmDomainType<T> getSqmType() {
        return this;
    }

    @Override
    public SqmPath<T> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        throw new UnsupportedMappingException("AnonymousTupleType cannot be used to create an SqmPath - that would be an SqmFrom which are created directly");
    }

    public Class<T> getBindableJavaType() {
        return this.javaTypeDescriptor.getJavaTypeClass();
    }

    @Override
    public Class<T> getJavaType() {
        return this.javaTypeDescriptor.getJavaTypeClass();
    }

    public String toString() {
        return "AnonymousTupleType" + Arrays.toString(this.expressibles);
    }
}

