/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.relational.internal;

import jakarta.persistence.SchemaValidationException;
import java.util.HashMap;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.relational.SchemaManager;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public class SchemaManagerImpl
implements SchemaManager {
    private final SessionFactoryImplementor sessionFactory;
    private final MetadataImplementor metadata;

    public SchemaManagerImpl(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata) {
        this.sessionFactory = sessionFactory;
        this.metadata = metadata;
    }

    @Override
    public void exportMappedObjects(boolean createSchemas) {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.CREATE_ONLY);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        properties.put("jakarta.persistence.create-database-schemas", createSchemas);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    @Override
    public void dropMappedObjects(boolean dropSchemas) {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.DROP);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        properties.put("jakarta.persistence.create-database-schemas", dropSchemas);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    @Override
    public void validateMappedObjects() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.VALIDATE);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        properties.put("jakarta.persistence.create-database-schemas", false);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    @Override
    public void truncateMappedObjects() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.TRUNCATE);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    @Override
    public void populate() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.sessionFactory.getProperties());
        properties.put("jakarta.persistence.schema-generation.database.action", (Object)Action.POPULATE);
        properties.put("jakarta.persistence.schema-generation.scripts.action", (Object)Action.NONE);
        SchemaManagementToolCoordinator.process(this.metadata, this.sessionFactory.getServiceRegistry(), properties, action -> {});
    }

    public void create(boolean createSchemas) {
        this.exportMappedObjects(createSchemas);
    }

    public void drop(boolean dropSchemas) {
        this.dropMappedObjects(dropSchemas);
    }

    public void validate() throws SchemaValidationException {
        try {
            this.validateMappedObjects();
        }
        catch (SchemaManagementException sme) {
            throw new SchemaValidationException(sme.getMessage(), new Exception[]{sme});
        }
    }

    public void truncate() {
        this.truncateMappedObjects();
    }
}

