/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.internal.util.StringHelper;

public class ForUpdateFragment {
    private final StringBuilder aliases = new StringBuilder();
    private final Dialect dialect;
    private final LockOptions lockOptions;

    public ForUpdateFragment(Dialect dialect, LockOptions lockOptions, Map<String, String[]> keyColumnNames) {
        this.dialect = dialect;
        LockMode upgradeType = null;
        this.lockOptions = lockOptions;
        if (!lockOptions.getAliasSpecificLocks().iterator().hasNext()) {
            LockMode lockMode = lockOptions.getLockMode();
            if (LockMode.READ.lessThan(lockMode)) {
                upgradeType = lockMode;
            }
        } else {
            for (Map.Entry<String, LockMode> me : lockOptions.getAliasSpecificLocks()) {
                LockMode lockMode = me.getValue();
                if (!LockMode.READ.lessThan(lockMode)) continue;
                String tableAlias = me.getKey();
                if (dialect.getWriteRowLockStrategy() == RowLockStrategy.COLUMN) {
                    String[] keyColumns = keyColumnNames.get(tableAlias);
                    if (keyColumns == null) {
                        throw new IllegalArgumentException("alias not found: " + tableAlias);
                    }
                    for (String keyColumn : keyColumns = StringHelper.qualify(tableAlias, keyColumns)) {
                        this.addTableAlias(keyColumn);
                    }
                } else {
                    this.addTableAlias(tableAlias);
                }
                if (upgradeType != null && lockMode != upgradeType) {
                    throw new QueryException("Mixed LockModes");
                }
                upgradeType = lockMode;
            }
        }
    }

    public ForUpdateFragment addTableAlias(String alias) {
        if (!this.aliases.isEmpty()) {
            this.aliases.append(", ");
        }
        this.aliases.append(alias);
        return this;
    }

    public String toFragmentString() {
        if (this.aliases.isEmpty()) {
            return this.dialect.getForUpdateString(this.lockOptions);
        }
        return this.dialect.getForUpdateString(this.aliases.toString(), this.lockOptions);
    }
}

