/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.cte;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.query.sqm.tuple.internal.CteTupleTableGroupProducer;
import org.hibernate.sql.ast.tree.cte.CteColumn;

public class CteTable {
    private final String cteName;
    private final AnonymousTupleTableGroupProducer tableGroupProducer;
    private final List<CteColumn> cteColumns;

    public CteTable(String cteName, List<CteColumn> cteColumns) {
        this(cteName, null, cteColumns);
    }

    public CteTable(String cteName, CteTupleTableGroupProducer tableGroupProducer) {
        this(cteName, tableGroupProducer, tableGroupProducer.determineCteColumns());
    }

    private CteTable(String cteName, AnonymousTupleTableGroupProducer tableGroupProducer, List<CteColumn> cteColumns) {
        assert (cteName != null);
        this.cteName = cteName;
        this.tableGroupProducer = tableGroupProducer;
        this.cteColumns = List.copyOf(cteColumns);
    }

    public String getTableExpression() {
        return this.cteName;
    }

    public AnonymousTupleTableGroupProducer getTableGroupProducer() {
        return this.tableGroupProducer;
    }

    public List<CteColumn> getCteColumns() {
        return this.cteColumns;
    }

    public CteTable withName(String name) {
        return new CteTable(name, this.tableGroupProducer, this.cteColumns);
    }

    public static CteTable createIdTable(String cteName, EntityMappingType entityDescriptor) {
        int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(numberOfColumns);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        String idName = identifierMapping instanceof SingleAttributeIdentifierMapping ? identifierMapping.getAttributeName() : "id";
        CteTable.forEachCteColumn(idName, identifierMapping, columns::add);
        return new CteTable(cteName, columns);
    }

    public static CteTable createEntityTable(String cteName, EntityMappingType entityDescriptor) {
        int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(numberOfColumns);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        String idName = identifierMapping instanceof SingleAttributeIdentifierMapping ? identifierMapping.getAttributeName() : "id";
        CteTable.forEachCteColumn(idName, identifierMapping, columns::add);
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        if (discriminatorMapping != null && discriminatorMapping.hasPhysicalColumn() && !discriminatorMapping.isFormula()) {
            CteTable.forEachCteColumn("class", discriminatorMapping, columns::add);
        }
        entityDescriptor.visitSubTypeAttributeMappings(attribute -> {
            if (!(attribute instanceof PluralAttributeMapping)) {
                CteTable.forEachCteColumn(attribute.getAttributeName(), attribute, columns::add);
            }
        });
        columns.add(new CteColumn("rn_", entityDescriptor.getEntityPersister().getFactory().getTypeConfiguration().getBasicTypeForJavaType(Integer.class)));
        return new CteTable(cteName, columns);
    }

    public static void forEachCteColumn(String prefix, ModelPart modelPart, Consumer<CteColumn> consumer) {
        if (modelPart instanceof BasicValuedMapping) {
            BasicValuedMapping basicValuedMapping = (BasicValuedMapping)((Object)modelPart);
            consumer.accept(new CteColumn(prefix, basicValuedMapping.getJdbcMapping()));
        } else if (modelPart instanceof EntityValuedModelPart) {
            ValuedModelPart targetPart;
            EntityValuedModelPart entityPart = (EntityValuedModelPart)modelPart;
            if (modelPart instanceof Association) {
                Association association = (Association)modelPart;
                if (association.getForeignKeyDescriptor() == null) {
                    throw new IllegalStateException("ForeignKeyDescriptor not ready for [" + association.getPartName() + "] on entity: " + modelPart.findContainingEntityMapping().getEntityName());
                }
                if (association.getSideNature() != ForeignKeyDescriptor.Nature.KEY) {
                    return;
                }
                targetPart = association.getForeignKeyDescriptor().getTargetPart();
            } else {
                targetPart = entityPart.getEntityMappingType().getIdentifierMapping();
            }
            CteTable.forEachCteColumn(prefix + "_" + entityPart.getPartName(), targetPart, consumer);
        } else if (modelPart instanceof DiscriminatedAssociationModelPart) {
            DiscriminatedAssociationModelPart discriminatedPart = (DiscriminatedAssociationModelPart)modelPart;
            String newPrefix = prefix + "_" + discriminatedPart.getPartName() + "_";
            CteTable.forEachCteColumn(newPrefix + "discriminator", discriminatedPart.getDiscriminatorPart(), consumer);
            CteTable.forEachCteColumn(newPrefix + "key", discriminatedPart.getKeyPart(), consumer);
        } else {
            EmbeddableValuedModelPart embeddablePart = (EmbeddableValuedModelPart)modelPart;
            AttributeMappingsList attributeMappings = embeddablePart.getEmbeddableTypeDescriptor().getAttributeMappings();
            for (int i = 0; i < attributeMappings.size(); ++i) {
                AttributeMapping mapping = attributeMappings.get(i);
                if (mapping instanceof PluralAttributeMapping) continue;
                CteTable.forEachCteColumn(prefix + "_" + mapping.getAttributeName(), mapping, consumer);
            }
        }
    }

    public static int determineModelPartStartIndex(EntityPersister entityDescriptor, ModelPart modelPart) {
        int offset = 0;
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        if (modelPart == identifierMapping) {
            return offset;
        }
        offset += identifierMapping.getJdbcTypeCount();
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        if (discriminatorMapping != null) {
            if (modelPart == discriminatorMapping) {
                return offset;
            }
            offset += discriminatorMapping.getJdbcTypeCount();
        }
        AttributeMappingsList attributeMappings = entityDescriptor.getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attribute = attributeMappings.get(i);
            if (attribute instanceof PluralAttributeMapping) continue;
            int result = CteTable.determineModelPartStartIndex(offset, attribute, modelPart);
            if (result < 0) {
                return -result;
            }
            offset = result;
        }
        return -1;
    }

    private static int determineModelPartStartIndex(int offset, ModelPart modelPart, ModelPart modelPartToFind) {
        if (modelPart == modelPartToFind) {
            return -offset;
        }
        if (modelPart instanceof EntityValuedModelPart) {
            ValuedModelPart valuedModelPart;
            EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)modelPart;
            if (modelPart instanceof Association) {
                Association association = (Association)modelPart;
                valuedModelPart = association.getForeignKeyDescriptor();
            } else {
                valuedModelPart = entityValuedModelPart.getEntityMappingType().getIdentifierMapping();
            }
            EntityIdentifierMapping keyPart = valuedModelPart;
            return CteTable.determineModelPartStartIndex(offset, keyPart, modelPartToFind);
        }
        if (modelPart instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddablePart = (EmbeddableValuedModelPart)modelPart;
            AttributeMappingsList attributeMappings = embeddablePart.getEmbeddableTypeDescriptor().getAttributeMappings();
            for (int i = 0; i < attributeMappings.size(); ++i) {
                AttributeMapping mapping = attributeMappings.get(i);
                int result = CteTable.determineModelPartStartIndex(offset, mapping, modelPartToFind);
                if (result < 0) {
                    return result;
                }
                offset = result;
            }
            return offset;
        }
        return offset + modelPart.getJdbcTypeCount();
    }
}

