/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResult;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableInitializerImpl;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddableExpressionResultImpl<T>
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
DomainResult<T>,
EmbeddableResult<T>,
InitializerProducer<EmbeddableExpressionResultImpl<T>> {
    private final String resultVariable;
    private final boolean containsAnyNonScalars;
    private final EmbeddableMappingType fetchContainer;

    public EmbeddableExpressionResultImpl(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart, SqlTuple sqlExpression, String resultVariable, DomainResultCreationState creationState) {
        super(navigablePath);
        this.fetchContainer = modelPart.getEmbeddableTypeDescriptor();
        this.resultVariable = resultVariable;
        ImmutableFetchList.Builder fetches = new ImmutableFetchList.Builder(modelPart);
        EmbeddableMappingType mappingType = modelPart.getEmbeddableTypeDescriptor();
        int numberOfAttributeMappings = mappingType.getNumberOfAttributeMappings();
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TypeConfiguration typeConfiguration = sqlAstCreationState.getCreationContext().getTypeConfiguration();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            BasicAttributeMapping attribute = (BasicAttributeMapping)mappingType.getAttributeMapping(i);
            SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpression.getExpressions().get(i), attribute.getJavaType(), this, typeConfiguration);
            fetches.add(new BasicFetch(sqlSelection.getValuesArrayPosition(), this, this.resolveNavigablePath(attribute), attribute, FetchTiming.IMMEDIATE, creationState, !sqlSelection.isVirtual()));
        }
        this.resetFetches(fetches.build());
        this.containsAnyNonScalars = EmbeddableExpressionResultImpl.determineIfContainedAnyScalars(this.getFetches());
    }

    private static boolean determineIfContainedAnyScalars(ImmutableFetchList fetches) {
        for (Fetch fetch : fetches) {
            if (!fetch.containsAnyNonScalarResults()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return this.containsAnyNonScalars;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getReferencedMappingType().getJavaType();
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EmbeddableAssembler(creationState.resolveInitializer(this, parent, this).asEmbeddableInitializer());
    }

    @Override
    public Initializer<?> createInitializer(EmbeddableExpressionResultImpl<T> resultGraphNode, InitializerParent<?> parent, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer(parent, creationState);
    }

    @Override
    public Initializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EmbeddableInitializerImpl(this, null, parent, creationState, true);
    }
}

