/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.internal.RowTransformerArrayImpl;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingResolution;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.type.descriptor.java.JavaType;

public class StandardRowReader<T>
implements RowReader<T> {
    private final DomainResultAssembler<?>[] resultAssemblers;
    private final Initializer<InitializerData>[] resultInitializers;
    private final InitializerData[] resultInitializersData;
    private final Initializer<InitializerData>[] initializers;
    private final InitializerData[] initializersData;
    private final Initializer<InitializerData>[] sortedForResolveInstance;
    private final InitializerData[] sortedForResolveInstanceData;
    private final boolean hasCollectionInitializers;
    private final @Nullable RowTransformer<T> rowTransformer;
    private final Class<T> domainResultJavaType;
    private final ComponentType componentType;
    private final Class<?> resultElementClass;

    public StandardRowReader(JdbcValuesMappingResolution jdbcValuesMappingResolution, RowTransformer<T> rowTransformer, Class<T> domainResultJavaType) {
        this(jdbcValuesMappingResolution.getDomainResultAssemblers(), jdbcValuesMappingResolution.getResultInitializers(), jdbcValuesMappingResolution.getInitializers(), jdbcValuesMappingResolution.getSortedForResolveInstance(), jdbcValuesMappingResolution.hasCollectionInitializers(), rowTransformer, domainResultJavaType);
    }

    public StandardRowReader(DomainResultAssembler<?>[] resultAssemblers, Initializer<?>[] resultInitializers, Initializer<?>[] initializers, Initializer<?>[] sortedForResolveInitializers, boolean hasCollectionInitializers, RowTransformer<T> rowTransformer, Class<T> domainResultJavaType) {
        this.resultAssemblers = resultAssemblers;
        this.resultInitializers = resultInitializers;
        this.resultInitializersData = new InitializerData[resultInitializers.length];
        this.initializers = initializers;
        this.initializersData = new InitializerData[initializers.length];
        this.sortedForResolveInstance = sortedForResolveInitializers;
        this.sortedForResolveInstanceData = new InitializerData[this.sortedForResolveInstance.length];
        this.hasCollectionInitializers = hasCollectionInitializers;
        this.rowTransformer = rowTransformer == RowTransformerArrayImpl.instance() && resultAssemblers.length != 1 || rowTransformer == RowTransformerStandardImpl.instance() || rowTransformer == RowTransformerSingularReturnImpl.instance() && resultAssemblers.length == 1 ? null : rowTransformer;
        this.domainResultJavaType = domainResultJavaType;
        if (domainResultJavaType == null || domainResultJavaType == Object[].class || domainResultJavaType == Object.class || !domainResultJavaType.isArray() || resultAssemblers.length == 1 && domainResultJavaType == resultAssemblers[0].getAssembledJavaType().getJavaTypeClass()) {
            this.resultElementClass = Object.class;
            this.componentType = ComponentType.OBJECT;
        } else {
            this.resultElementClass = domainResultJavaType.getComponentType();
            this.componentType = ComponentType.determineComponentType(domainResultJavaType);
        }
    }

    @Override
    public Class<T> getDomainResultResultJavaType() {
        return this.domainResultJavaType;
    }

    @Override
    public List<@Nullable JavaType<?>> getResultJavaTypes() {
        ArrayList javaTypes = new ArrayList(this.resultAssemblers.length);
        for (DomainResultAssembler<?> resultAssembler : this.resultAssemblers) {
            javaTypes.add(resultAssembler.getAssembledJavaType());
        }
        return javaTypes;
    }

    @Override
    public int getInitializerCount() {
        return this.initializers.length;
    }

    @Override
    public @Nullable EntityKey resolveSingleResultEntityKey(RowProcessingState rowProcessingState) {
        EntityInitializer<?> entityInitializer;
        EntityInitializer<?> entityInitializer2 = entityInitializer = this.resultInitializers.length == 0 ? null : this.resultInitializers[0].asEntityInitializer();
        if (entityInitializer == null) {
            return null;
        }
        EntityKey entityKey = entityInitializer.resolveEntityKeyOnly(rowProcessingState);
        this.finishUpRow();
        return entityKey;
    }

    @Override
    public boolean hasCollectionInitializers() {
        return this.hasCollectionInitializers;
    }

    @Override
    @AllowReflection
    public T readRow(RowProcessingState rowProcessingState) {
        Object result;
        this.coordinateInitializers(rowProcessingState);
        if (this.componentType != ComponentType.OBJECT) {
            result = this.readPrimitiveRow(rowProcessingState);
        } else if (this.resultAssemblers.length == 1 && this.rowTransformer == null) {
            result = this.resultAssemblers[0].assemble(rowProcessingState);
        } else {
            Object[] resultRow = (Object[])Array.newInstance(this.resultElementClass, this.resultAssemblers.length);
            for (int i = 0; i < this.resultAssemblers.length; ++i) {
                resultRow[i] = this.resultAssemblers[i].assemble(rowProcessingState);
            }
            result = this.rowTransformer == null ? resultRow : this.rowTransformer.transformRow(resultRow);
        }
        this.finishUpRow();
        return result;
    }

    private T readPrimitiveRow(RowProcessingState rowProcessingState) {
        switch (this.componentType) {
            case BOOLEAN: {
                boolean[] resultBooleanRow = new boolean[this.resultAssemblers.length];
                for (int i = 0; i < this.resultAssemblers.length; ++i) {
                    resultBooleanRow[i] = (Boolean)this.resultAssemblers[i].assemble(rowProcessingState);
                }
                return (T)resultBooleanRow;
            }
            case BYTE: {
                byte[] resultByteRow = new byte[this.resultAssemblers.length];
                for (int i = 0; i < this.resultAssemblers.length; ++i) {
                    resultByteRow[i] = (Byte)this.resultAssemblers[i].assemble(rowProcessingState);
                }
                return (T)resultByteRow;
            }
            case CHAR: {
                char[] resultCharRow = new char[this.resultAssemblers.length];
                for (int i = 0; i < this.resultAssemblers.length; ++i) {
                    resultCharRow[i] = ((Character)this.resultAssemblers[i].assemble(rowProcessingState)).charValue();
                }
                return (T)resultCharRow;
            }
            case SHORT: {
                short[] resultShortRow = new short[this.resultAssemblers.length];
                for (int i = 0; i < this.resultAssemblers.length; ++i) {
                    resultShortRow[i] = (Short)this.resultAssemblers[i].assemble(rowProcessingState);
                }
                return (T)resultShortRow;
            }
            case INT: {
                int[] resultIntRow = new int[this.resultAssemblers.length];
                for (int i = 0; i < this.resultAssemblers.length; ++i) {
                    resultIntRow[i] = (Integer)this.resultAssemblers[i].assemble(rowProcessingState);
                }
                return (T)resultIntRow;
            }
            case LONG: {
                long[] resultLongRow = new long[this.resultAssemblers.length];
                for (int i = 0; i < this.resultAssemblers.length; ++i) {
                    resultLongRow[i] = (Long)this.resultAssemblers[i].assemble(rowProcessingState);
                }
                return (T)resultLongRow;
            }
            case FLOAT: {
                float[] resultFloatRow = new float[this.resultAssemblers.length];
                for (int i = 0; i < this.resultAssemblers.length; ++i) {
                    resultFloatRow[i] = ((Float)this.resultAssemblers[i].assemble(rowProcessingState)).floatValue();
                }
                return (T)resultFloatRow;
            }
            case DOUBLE: {
                double[] resultDoubleRow = new double[this.resultAssemblers.length];
                for (int i = 0; i < this.resultAssemblers.length; ++i) {
                    resultDoubleRow[i] = (Double)this.resultAssemblers[i].assemble(rowProcessingState);
                }
                return (T)resultDoubleRow;
            }
        }
        throw new AssertionError((Object)"Object should be handled specially");
    }

    private void finishUpRow() {
        for (InitializerData data : this.initializersData) {
            data.setState(Initializer.State.UNINITIALIZED);
        }
    }

    private void coordinateInitializers(RowProcessingState rowProcessingState) {
        int i;
        for (i = 0; i < this.resultInitializers.length; ++i) {
            this.resultInitializers[i].resolveKey(this.resultInitializersData[i]);
        }
        for (i = 0; i < this.sortedForResolveInstance.length; ++i) {
            if (this.sortedForResolveInstanceData[i].getState() != Initializer.State.KEY_RESOLVED) continue;
            this.sortedForResolveInstance[i].resolveInstance(this.sortedForResolveInstanceData[i]);
        }
        for (i = 0; i < this.initializers.length; ++i) {
            if (this.initializersData[i].getState() != Initializer.State.RESOLVED) continue;
            this.initializers[i].initializeInstance(this.initializersData[i]);
        }
    }

    @Override
    public void startLoading(RowProcessingState processingState) {
        int i;
        for (i = 0; i < this.resultInitializers.length; ++i) {
            Initializer<InitializerData> initializer = this.resultInitializers[i];
            initializer.startLoading(processingState);
            this.resultInitializersData[i] = initializer.getData(processingState);
        }
        for (i = 0; i < this.sortedForResolveInstance.length; ++i) {
            this.sortedForResolveInstanceData[i] = this.sortedForResolveInstance[i].getData(processingState);
        }
        for (i = 0; i < this.initializers.length; ++i) {
            this.initializersData[i] = this.initializers[i].getData(processingState);
        }
    }

    @Override
    public void finishUp(RowProcessingState rowProcessingState) {
        for (int i = 0; i < this.initializers.length; ++i) {
            this.initializers[i].endLoading(this.initializersData[i]);
        }
    }

    static enum ComponentType {
        BOOLEAN(Boolean.TYPE),
        BYTE(Byte.TYPE),
        SHORT(Short.TYPE),
        CHAR(Character.TYPE),
        INT(Integer.TYPE),
        LONG(Long.TYPE),
        FLOAT(Float.TYPE),
        DOUBLE(Double.TYPE),
        OBJECT(Object.class);

        private final Class<?> componentType;

        private ComponentType(Class<?> componentType) {
            this.componentType = componentType;
        }

        public static ComponentType determineComponentType(Class<?> resultType) {
            if (resultType == boolean[].class) {
                return BOOLEAN;
            }
            if (resultType == byte[].class) {
                return BYTE;
            }
            if (resultType == short[].class) {
                return SHORT;
            }
            if (resultType == char[].class) {
                return CHAR;
            }
            if (resultType == int[].class) {
                return INT;
            }
            if (resultType == long[].class) {
                return LONG;
            }
            if (resultType == float[].class) {
                return FLOAT;
            }
            if (resultType == double[].class) {
                return DOUBLE;
            }
            return OBJECT;
        }

        public Class<?> getComponentType() {
            return this.componentType;
        }
    }
}

