/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.NoopLimitHandler;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcLockStrategy;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.jdbc.internal.AbstractResultSetAccess;

public class DeferredResultSetAccess
extends AbstractResultSetAccess {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DeferredResultSetAccess.class);
    private final JdbcOperationQuerySelect jdbcSelect;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final ExecutionContext executionContext;
    private final JdbcSelectExecutor.StatementCreator statementCreator;
    private final SqlStatementLogger sqlStatementLogger;
    private final String finalSql;
    private final Limit limit;
    private final LimitHandler limitHandler;
    private final boolean usesFollowOnLocking;
    private final int resultCountEstimate;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public DeferredResultSetAccess(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, JdbcSelectExecutor.StatementCreator statementCreator, int resultCountEstimate) {
        super(executionContext.getSession());
        JdbcServices jdbcServices = executionContext.getSession().getJdbcServices();
        this.jdbcParameterBindings = jdbcParameterBindings;
        this.executionContext = executionContext;
        this.jdbcSelect = jdbcSelect;
        this.statementCreator = statementCreator;
        this.sqlStatementLogger = jdbcServices.getSqlStatementLogger();
        this.resultCountEstimate = resultCountEstimate;
        QueryOptions queryOptions = executionContext.getQueryOptions();
        if (queryOptions == null) {
            this.finalSql = jdbcSelect.getSqlString();
            this.limit = null;
            this.limitHandler = NoopLimitHandler.NO_LIMIT;
            this.usesFollowOnLocking = false;
        } else {
            String sqlWithLocking;
            Dialect dialect = jdbcServices.getDialect();
            String sql = jdbcSelect.getSqlString();
            this.limit = queryOptions.getLimit();
            boolean hasLimit = this.isHasLimit(jdbcSelect);
            this.limitHandler = hasLimit ? NoopLimitHandler.NO_LIMIT : dialect.getLimitHandler();
            String sqlWithLimit = hasLimit ? sql : this.limitHandler.processSql(sql, this.limit, queryOptions);
            LockOptions lockOptions = queryOptions.getLockOptions();
            JdbcLockStrategy jdbcLockStrategy = jdbcSelect.getLockStrategy();
            if (DeferredResultSetAccess.hasLocking(jdbcLockStrategy, lockOptions)) {
                this.usesFollowOnLocking = DeferredResultSetAccess.useFollowOnLocking(jdbcLockStrategy, sqlWithLimit, queryOptions, lockOptions, dialect);
                if (this.usesFollowOnLocking) {
                    this.handleFollowOnLocking(executionContext, lockOptions);
                    sqlWithLocking = sqlWithLimit;
                } else {
                    sqlWithLocking = dialect.applyLocksToSql(sqlWithLimit, lockOptions, Collections.emptyMap());
                }
            } else {
                this.usesFollowOnLocking = false;
                sqlWithLocking = sqlWithLimit;
            }
            boolean commentsEnabled = executionContext.getSession().getFactory().getSessionFactoryOptions().isCommentsEnabled();
            this.finalSql = dialect.addSqlHintOrComment(sqlWithLocking, queryOptions, commentsEnabled);
        }
    }

    private boolean isHasLimit(JdbcOperationQuerySelect jdbcSelect) {
        return this.limit == null || this.limit.isEmpty() || jdbcSelect.usesLimitParameters();
    }

    private static boolean hasLocking(JdbcLockStrategy jdbcLockStrategy, LockOptions lockOptions) {
        return jdbcLockStrategy != JdbcLockStrategy.NONE && lockOptions != null && !lockOptions.isEmpty();
    }

    private void handleFollowOnLocking(ExecutionContext executionContext, LockOptions lockOptions) {
        LockMode lockMode = this.determineFollowOnLockMode(lockOptions);
        if (lockMode != LockMode.UPGRADE_SKIPLOCKED) {
            if (lockOptions.getLockMode() != LockMode.NONE) {
                LOG.usingFollowOnLocking();
            }
            LockOptions lockOptionsToUse = new LockOptions(lockMode);
            lockOptionsToUse.setTimeOut(lockOptions.getTimeOut());
            lockOptionsToUse.setLockScope(lockOptions.getLockScope());
            this.registerAfterLoadAction(executionContext, lockOptionsToUse);
        }
    }

    protected void registerAfterLoadAction(ExecutionContext executionContext, LockOptions lockOptionsToUse) {
        executionContext.getCallback().registerAfterLoadAction((entity, persister, session) -> session.lock(persister.getEntityName(), entity, lockOptionsToUse));
    }

    private static boolean useFollowOnLocking(JdbcLockStrategy jdbcLockStrategy, String sql, QueryOptions queryOptions, LockOptions lockOptions, Dialect dialect) {
        return switch (jdbcLockStrategy) {
            case JdbcLockStrategy.FOLLOW_ON -> true;
            case JdbcLockStrategy.AUTO -> {
                if (lockOptions.getFollowOnLocking() == null) {
                    yield dialect.useFollowOnLocking(sql, queryOptions);
                }
                yield lockOptions.getFollowOnLocking();
            }
            default -> false;
        };
    }

    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    public Limit getLimit() {
        return this.limit;
    }

    @Override
    public ResultSet getResultSet() {
        if (this.resultSet == null) {
            this.executeQuery();
        }
        return this.resultSet;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.executionContext.getSession().getFactory();
    }

    public String getFinalSql() {
        return this.finalSql;
    }

    public boolean usesFollowOnLocking() {
        return this.usesFollowOnLocking;
    }

    protected void bindParameters(PreparedStatement preparedStatement) throws SQLException {
        this.setQueryOptions(preparedStatement);
        int paramBindingPosition = 1;
        paramBindingPosition += this.limitHandler.bindLimitParametersAtStartOfQuery(this.limit, preparedStatement, paramBindingPosition);
        for (JdbcParameterBinder parameterBinder : this.jdbcSelect.getParameterBinders()) {
            parameterBinder.bindParameterValue(preparedStatement, paramBindingPosition++, this.jdbcParameterBindings, this.executionContext);
        }
        paramBindingPosition += this.limitHandler.bindLimitParametersAtEndOfQuery(this.limit, preparedStatement, paramBindingPosition);
        if (!this.jdbcSelect.usesLimitParameters() && this.limit != null && this.limit.getMaxRows() != null) {
            this.limitHandler.setMaxRows(this.limit, preparedStatement);
        } else {
            int maxRows = this.jdbcSelect.getMaxRows();
            if (maxRows != Integer.MAX_VALUE) {
                preparedStatement.setMaxRows(maxRows);
            }
        }
    }

    private void setQueryOptions(PreparedStatement preparedStatement) throws SQLException {
        QueryOptions queryOptions = this.executionContext.getQueryOptions();
        if (queryOptions != null) {
            if (queryOptions.getFetchSize() != null) {
                preparedStatement.setFetchSize(queryOptions.getFetchSize());
            }
            if (queryOptions.getTimeout() != null) {
                preparedStatement.setQueryTimeout(queryOptions.getTimeout());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery() {
        LogicalConnectionImplementor logicalConnection = this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection();
        SharedSessionContractImplementor session = this.executionContext.getSession();
        try {
            LOG.tracef("Executing query to retrieve ResultSet : %s", this.finalSql);
            this.preparedStatement = this.statementCreator.createStatement(this.executionContext, this.finalSql);
            this.bindParameters(this.preparedStatement);
            SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
            long executeStartNanos = 0L;
            if (this.sqlStatementLogger.getLogSlowQuery() > 0L) {
                executeStartNanos = System.nanoTime();
            }
            EventMonitor eventMonitor = session.getEventMonitor();
            DiagnosticEvent jdbcPreparedStatementExecutionEvent = eventMonitor.beginJdbcPreparedStatementExecutionEvent();
            try {
                eventListenerManager.jdbcExecuteStatementStart();
                this.resultSet = this.wrapResultSet(this.preparedStatement.executeQuery());
            }
            finally {
                eventMonitor.completeJdbcPreparedStatementExecutionEvent(jdbcPreparedStatementExecutionEvent, this.finalSql);
                eventListenerManager.jdbcExecuteStatementEnd();
                this.sqlStatementLogger.logSlowQuery(this.finalSql, executeStartNanos, this.context());
            }
            this.skipRows(this.resultSet);
            logicalConnection.getResourceRegistry().register(this.resultSet, this.preparedStatement);
        }
        catch (SQLException exception) {
            try {
                this.release();
            }
            catch (RuntimeException suppressed) {
                exception.addSuppressed(suppressed);
            }
            throw session.getJdbcServices().getSqlExceptionHelper().convert(exception, "JDBC exception executing SQL [" + this.finalSql + "]");
        }
    }

    private JdbcSessionContext context() {
        return this.executionContext.getSession().getJdbcCoordinator().getJdbcSessionOwner().getJdbcSessionContext();
    }

    protected void skipRows(ResultSet resultSet) throws SQLException {
        int rowsToSkip = this.getRowsToSkip();
        if (rowsToSkip != 0) {
            try {
                resultSet.absolute(rowsToSkip);
            }
            catch (SQLException ex) {
                try {
                    resultSet.next();
                }
                catch (SQLException ex2) {
                    throw ex;
                }
                for (int i = 1; i < rowsToSkip && resultSet.next(); ++i) {
                }
            }
        }
    }

    private int getRowsToSkip() {
        return !this.jdbcSelect.usesLimitParameters() && this.limit != null && this.limit.getFirstRow() != null && !this.limitHandler.supportsLimitOffset() ? this.limit.getFirstRow().intValue() : this.jdbcSelect.getRowsToSkip();
    }

    protected ResultSet wrapResultSet(ResultSet resultSet) throws SQLException {
        return resultSet;
    }

    protected LockMode determineFollowOnLockMode(LockOptions lockOptions) {
        LockMode lockModeToUse = lockOptions.findGreatestLockMode();
        if (lockOptions.hasAliasSpecificLockModes()) {
            if (lockOptions.getLockMode() == LockMode.NONE && lockModeToUse == LockMode.NONE) {
                return lockModeToUse;
            }
            LOG.aliasSpecificLockingWithFollowOnLocking(lockModeToUse);
        }
        return lockModeToUse;
    }

    @Override
    public void release() {
        JdbcCoordinator jdbcCoordinator = this.getPersistenceContext().getJdbcCoordinator();
        LogicalConnectionImplementor logicalConnection = jdbcCoordinator.getLogicalConnection();
        if (this.resultSet != null) {
            logicalConnection.getResourceRegistry().release(this.resultSet, this.preparedStatement);
            this.resultSet = null;
        }
        if (this.preparedStatement != null) {
            logicalConnection.getResourceRegistry().release(this.preparedStatement);
            this.preparedStatement = null;
            jdbcCoordinator.afterStatementExecution();
        }
    }

    @Override
    public int getResultCountEstimate() {
        if (this.limit != null && this.limit.getMaxRows() != null) {
            return this.limit.getMaxRows();
        }
        if (this.jdbcSelect.getLimitParameter() != null) {
            return (Integer)this.jdbcParameterBindings.getBinding(this.jdbcSelect.getLimitParameter()).getBindValue();
        }
        if (this.resultCountEstimate > 0) {
            return this.resultCountEstimate;
        }
        return super.getResultCountEstimate();
    }
}

