/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class ListResultsConsumer<R>
implements ResultsConsumer<List<R>, R> {
    private static final int INITIAL_COLLECTION_SIZE_LIMIT = 8192;
    private static final ListResultsConsumer<?> NEVER_DE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.NEVER);
    private static final ListResultsConsumer<?> ALLOW_DE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.ALLOW);
    private static final ListResultsConsumer<?> IGNORE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.NONE);
    private static final ListResultsConsumer<?> DE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.FILTER);
    private static final ListResultsConsumer<?> ERROR_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.ASSERT);
    private final UniqueSemantic uniqueSemantic;

    public static <R> ListResultsConsumer<R> instance(UniqueSemantic uniqueSemantic) {
        return switch (uniqueSemantic) {
            case UniqueSemantic.ASSERT -> ERROR_DUP_CONSUMER;
            case UniqueSemantic.FILTER -> DE_DUP_CONSUMER;
            case UniqueSemantic.NEVER -> NEVER_DE_DUP_CONSUMER;
            case UniqueSemantic.ALLOW -> ALLOW_DE_DUP_CONSUMER;
            default -> IGNORE_DUP_CONSUMER;
        };
    }

    public ListResultsConsumer(UniqueSemantic uniqueSemantic) {
        this.uniqueSemantic = uniqueSemantic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<R> consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader) {
        rowReader.startLoading(rowProcessingState);
        RuntimeException ex = null;
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        persistenceContext.beforeLoad();
        persistenceContext.getLoadContexts().register(jdbcValuesSourceProcessingState);
        try {
            JavaType<R> domainResultJavaType = this.resolveDomainResultJavaType(rowReader.getDomainResultResultJavaType(), rowReader.getResultJavaTypes(), session.getTypeConfiguration());
            boolean isEntityResultType = domainResultJavaType instanceof EntityJavaType;
            int initialCollectionSize = Math.min(jdbcValues.getResultCountEstimate(), 8192);
            Results<R> results = this.createResults(isEntityResultType, domainResultJavaType, initialCollectionSize);
            int readRows = this.readRows(rowProcessingState, rowReader, isEntityResultType, results);
            rowReader.finishUp(rowProcessingState);
            jdbcValuesSourceProcessingState.finishUp(readRows > 1);
            List<R> list = ListResultsConsumer.transformList(rowProcessingState, results);
            return list;
        }
        catch (RuntimeException e) {
            ex = e;
            return ex;
        }
        finally {
            try {
                jdbcValues.finishUp(session);
                persistenceContext.afterLoad();
                persistenceContext.getLoadContexts().deregister(jdbcValuesSourceProcessingState);
                persistenceContext.initializeNonLazyCollections();
            }
            catch (RuntimeException e) {
                if (ex != null) {
                    ex.addSuppressed(e);
                }
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) throw new IllegalStateException("Should not reach this");
                throw ex;
            }
        }
    }

    private static <R> List<R> transformList(ExecutionContext executionContext, Results<R> results) {
        ResultListTransformer<R> transformer = ListResultsConsumer.getResultListTransformer(executionContext);
        return transformer == null ? results.getResults() : transformer.transformList(results.getResults());
    }

    private static <R> ResultListTransformer<R> getResultListTransformer(ExecutionContext executionContext) {
        return executionContext.getQueryOptions().getResultListTransformer();
    }

    private Results<R> createResults(boolean isEntityResultType, JavaType<R> domainResultJavaType, int initialCollectionSize) {
        if (isEntityResultType && (this.uniqueSemantic == UniqueSemantic.ALLOW || this.uniqueSemantic == UniqueSemantic.FILTER)) {
            return new EntityResult<R>(domainResultJavaType, initialCollectionSize);
        }
        return new Results<R>(domainResultJavaType, initialCollectionSize);
    }

    private int readRows(RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, boolean isEntityResultType, Results<R> results) {
        if (this.uniqueSemantic == UniqueSemantic.FILTER || this.uniqueSemantic == UniqueSemantic.ASSERT && rowReader.hasCollectionInitializers() || this.uniqueSemantic == UniqueSemantic.ALLOW && isEntityResultType) {
            return ListResultsConsumer.readUnique(rowProcessingState, rowReader, results);
        }
        if (this.uniqueSemantic == UniqueSemantic.ASSERT) {
            return ListResultsConsumer.readUniqueAssert(rowProcessingState, rowReader, results);
        }
        return ListResultsConsumer.read(rowProcessingState, rowReader, results);
    }

    private static <R> int read(RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, Results<R> results) {
        int readRows = 0;
        while (rowProcessingState.next()) {
            results.add(rowReader.readRow(rowProcessingState));
            rowProcessingState.finishRowProcessing(true);
            ++readRows;
        }
        return readRows;
    }

    private static <R> int readUniqueAssert(RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, Results<R> results) {
        int readRows = 0;
        while (rowProcessingState.next()) {
            if (!results.addUnique(rowReader.readRow(rowProcessingState))) {
                throw new HibernateException(String.format(Locale.ROOT, "Duplicate row was found and `%s` was specified", new Object[]{UniqueSemantic.ASSERT}));
            }
            rowProcessingState.finishRowProcessing(true);
            ++readRows;
        }
        return readRows;
    }

    private static <R> int readUnique(RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, Results<R> results) {
        int readRows = 0;
        while (rowProcessingState.next()) {
            boolean added = results.addUnique(rowReader.readRow(rowProcessingState));
            rowProcessingState.finishRowProcessing(added);
            ++readRows;
        }
        return readRows;
    }

    private JavaType<R> resolveDomainResultJavaType(Class<R> domainResultResultJavaType, List<@Nullable JavaType<?>> resultJavaTypes, TypeConfiguration typeConfiguration) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        if (domainResultResultJavaType != null) {
            JavaType resultJavaType = javaTypeRegistry.resolveDescriptor(domainResultResultJavaType);
            if (resultJavaTypes.size() == 1 && ListResultsConsumer.isMoreConcrete(resultJavaType, resultJavaTypes.get(0))) {
                return resultJavaTypes.get(0);
            }
            return resultJavaType;
        }
        if (resultJavaTypes.size() == 1) {
            JavaType<?> firstJavaType = resultJavaTypes.get(0);
            if (firstJavaType == null) {
                return javaTypeRegistry.resolveDescriptor((Type)((Object)Object.class));
            }
            return firstJavaType;
        }
        return javaTypeRegistry.resolveDescriptor((Type)((Object)Object[].class));
    }

    private static boolean isMoreConcrete(JavaType<?> resultJavaType, @Nullable JavaType<?> javaType) {
        return javaType != null && resultJavaType.getJavaTypeClass().isAssignableFrom(javaType.getJavaTypeClass());
    }

    @Override
    public boolean canResultsBeCached() {
        return true;
    }

    public String toString() {
        return "ListResultsConsumer(" + String.valueOf((Object)this.uniqueSemantic) + ")";
    }

    public static enum UniqueSemantic {
        NONE,
        FILTER,
        ASSERT,
        NEVER,
        ALLOW;

    }

    private static class Results<R> {
        private final ArrayList<R> results;
        private final JavaType<R> resultJavaType;

        public Results(JavaType<R> resultJavaType, int initialSize) {
            this.resultJavaType = resultJavaType;
            this.results = initialSize > 0 ? new ArrayList(initialSize) : new ArrayList();
        }

        public boolean addUnique(R result) {
            for (int i = 0; i < this.results.size(); ++i) {
                if (!this.resultJavaType.areEqual(this.results.get(i), result)) continue;
                return false;
            }
            this.results.add(result);
            return true;
        }

        public void add(R result) {
            this.results.add(result);
        }

        public List<R> getResults() {
            return this.results;
        }
    }

    private static class EntityResult<R>
    extends Results<R> {
        private static final Object DUMP_VALUE = new Object();
        private final IdentityHashMap<R, Object> added;

        public EntityResult(JavaType<R> resultJavaType, int initialSize) {
            super(resultJavaType, initialSize);
            this.added = initialSize > 0 ? new IdentityHashMap(initialSize) : new IdentityHashMap();
        }

        @Override
        public boolean addUnique(R result) {
            if (this.added.put(result, DUMP_VALUE) == null) {
                super.add(result);
                return true;
            }
            return false;
        }
    }
}

