/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.LongAdder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.cache.spi.ExtendedStatisticsSupport;
import org.hibernate.cache.spi.Region;
import org.hibernate.stat.CacheRegionStatistics;

public class CacheRegionStatisticsImpl
implements CacheRegionStatistics,
Serializable {
    private final transient @UnknownKeyFor @NonNull @Initialized Region region;
    private final @UnknownKeyFor @NonNull @Initialized LongAdder hitCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder missCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder putCount = new LongAdder();

    CacheRegionStatisticsImpl(@UnknownKeyFor @NonNull @Initialized Region region) {
        this.region = region;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getRegionName() {
        return this.region.getName();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getHitCount() {
        return this.hitCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getMissCount() {
        return this.missCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getPutCount() {
        return this.putCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getElementCountInMemory() {
        long l;
        Region region = this.region;
        if (region instanceof ExtendedStatisticsSupport) {
            ExtendedStatisticsSupport extended = (ExtendedStatisticsSupport)((Object)region);
            l = extended.getElementCountInMemory();
        } else {
            l = Long.MIN_VALUE;
        }
        return l;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getElementCountOnDisk() {
        long l;
        Region region = this.region;
        if (region instanceof ExtendedStatisticsSupport) {
            ExtendedStatisticsSupport extended = (ExtendedStatisticsSupport)((Object)region);
            l = extended.getElementCountOnDisk();
        } else {
            l = Long.MIN_VALUE;
        }
        return l;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getSizeInMemory() {
        long l;
        Region region = this.region;
        if (region instanceof ExtendedStatisticsSupport) {
            ExtendedStatisticsSupport extended = (ExtendedStatisticsSupport)((Object)region);
            l = extended.getSizeInMemory();
        } else {
            l = Long.MIN_VALUE;
        }
        return l;
    }

    void incrementHitCount() {
        this.hitCount.increment();
    }

    void incrementMissCount() {
        this.missCount.increment();
    }

    void incrementPutCount() {
        this.putCount.increment();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String buf = "CacheRegionStatistics[region=" + this.region.getName() + ",hitCount=" + String.valueOf(this.hitCount) + ",missCount=" + String.valueOf(this.missCount) + ",putCount=" + String.valueOf(this.putCount) + ",elementCountInMemory=" + this.getElementCountInMemory() + ",elementCountOnDisk=" + this.getElementCountOnDisk() + ",sizeInMemory=" + this.getSizeInMemory() + "]";
        return buf;
    }
}

