/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.lang.invoke.MethodHandles;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceInitiatorContext;
import org.hibernate.stat.internal.StatisticsImpl;
import org.hibernate.stat.spi.StatisticsFactory;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class StatisticsInitiator
implements SessionFactoryServiceInitiator<StatisticsImplementor> {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)StatisticsInitiator.class.getName());
    public static final @UnknownKeyFor @NonNull @Initialized StatisticsInitiator INSTANCE = new StatisticsInitiator();

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized StatisticsImplementor> getServiceInitiated() {
        return StatisticsImplementor.class;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized StatisticsImplementor initiateService(@UnknownKeyFor @NonNull @Initialized SessionFactoryServiceInitiatorContext context) {
        Object configValue = context.getServiceRegistry().requireService(ConfigurationService.class).getSettings().get("hibernate.stats.factory");
        StatisticsFactory statisticsFactory = StatisticsInitiator.statisticsFactory(configValue, context.getServiceRegistry());
        StatisticsImplementor statistics = statisticsFactory.buildStatistics(context.getSessionFactory());
        boolean enabled = context.getSessionFactoryOptions().isStatisticsEnabled();
        statistics.setStatisticsEnabled(enabled);
        LOG.debugf("Statistics initialized [enabled=%s]", enabled);
        return statistics;
    }

    private static @UnknownKeyFor @NonNull @Initialized StatisticsFactory statisticsFactory(@Nullable @UnknownKeyFor @Initialized Object configValue, @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor registry) {
        if (configValue == null) {
            return StatisticsImpl::new;
        }
        if (configValue instanceof StatisticsFactory) {
            StatisticsFactory factory = (StatisticsFactory)configValue;
            return factory;
        }
        ClassLoaderService classLoaderService = registry.requireService(ClassLoaderService.class);
        try {
            return (StatisticsFactory)classLoaderService.classForName(configValue.toString()).newInstance();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException("Unable to instantiate specified StatisticsFactory implementation [" + String.valueOf(configValue) + "]", e);
        }
    }
}

