/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.ContributableDatabaseObject;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.internal.DefaultSchemaFilter;
import org.hibernate.tool.schema.internal.ExceptionHandlerLoggedImpl;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.GenerationTargetToDatabase;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.DelayedDropAction;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.GenerationTarget;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public class SchemaDropperImpl
implements SchemaDropper {
    private static final Logger log = Logger.getLogger(SchemaDropperImpl.class);
    private final HibernateSchemaManagementTool tool;
    private final SchemaFilter schemaFilter;

    public SchemaDropperImpl(HibernateSchemaManagementTool tool) {
        this(tool, (SchemaFilter)DefaultSchemaFilter.INSTANCE);
    }

    public SchemaDropperImpl(HibernateSchemaManagementTool tool, SchemaFilter schemaFilter) {
        this.tool = tool;
        this.schemaFilter = schemaFilter;
    }

    public SchemaDropperImpl(ServiceRegistry serviceRegistry) {
        this(serviceRegistry, (SchemaFilter)DefaultSchemaFilter.INSTANCE);
    }

    public SchemaDropperImpl(ServiceRegistry serviceRegistry, SchemaFilter schemaFilter) {
        SchemaManagementTool schemaManagementTool = serviceRegistry.getService(SchemaManagementTool.class);
        if (schemaManagementTool instanceof HibernateSchemaManagementTool) {
            HibernateSchemaManagementTool schemaManagementTool2;
            this.tool = schemaManagementTool2 = (HibernateSchemaManagementTool)schemaManagementTool;
        } else {
            this.tool = new HibernateSchemaManagementTool();
            this.tool.injectServices((ServiceRegistryImplementor)serviceRegistry);
        }
        this.schemaFilter = schemaFilter;
    }

    @Override
    public void doDrop(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, SourceDescriptor sourceDescriptor, TargetDescriptor targetDescriptor) {
        if (!targetDescriptor.getTargetTypes().isEmpty()) {
            Map<String, Object> configuration = options.getConfigurationValues();
            JdbcContext jdbcContext = this.tool.resolveJdbcContext(configuration);
            this.doDrop(metadata, options, inclusionFilter, jdbcContext.getDialect(), sourceDescriptor, this.tool.buildGenerationTargets(targetDescriptor, jdbcContext, configuration, true));
        }
    }

    @Internal
    public void doDrop(Metadata metadata, ExecutionOptions options, Dialect dialect, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        this.doDrop(metadata, options, (ContributableDatabaseObject contributed) -> true, dialect, sourceDescriptor, targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void doDrop(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        for (GenerationTarget target : targets) {
            target.prepare();
        }
        try {
            this.performDrop(metadata, options, inclusionFilter, dialect, sourceDescriptor, targets);
        }
        finally {
            for (GenerationTarget target : targets) {
                try {
                    target.release();
                }
                catch (Exception e) {
                    log.debugf("Problem releasing GenerationTarget [%s] : %s", (Object)target, (Object)e.getMessage());
                }
            }
        }
    }

    private void performDrop(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        SqlScriptCommandExtractor commandExtractor = this.getCommandExtractor();
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        switch (sourceDescriptor.getSourceType()) {
            case SCRIPT: {
                Helper.applyScript(options, commandExtractor, dialect, sourceDescriptor.getScriptSourceInput(), formatter, targets);
                break;
            }
            case METADATA: {
                this.dropFromMetadata(metadata, options, inclusionFilter, dialect, formatter, targets);
                break;
            }
            case METADATA_THEN_SCRIPT: {
                this.dropFromMetadata(metadata, options, inclusionFilter, dialect, formatter, targets);
                Helper.applyScript(options, commandExtractor, dialect, sourceDescriptor.getScriptSourceInput(), formatter, targets);
                break;
            }
            case SCRIPT_THEN_METADATA: {
                Helper.applyScript(options, commandExtractor, dialect, sourceDescriptor.getScriptSourceInput(), formatter, targets);
                this.dropFromMetadata(metadata, options, inclusionFilter, dialect, formatter, targets);
            }
        }
    }

    private SqlScriptCommandExtractor getCommandExtractor() {
        return this.tool.getServiceRegistry().getService(SqlScriptCommandExtractor.class);
    }

    private void dropFromMetadata(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, Formatter formatter, GenerationTarget ... targets) {
        Helper.applySqlString(dialect.getBeforeDropStatement(), formatter, options, targets);
        SqlStringGenerationContext context = Helper.createSqlStringGenerationContext(options, metadata);
        SchemaDropperImpl.dropAuxiliaryObjectsBeforeTables(metadata, options, dialect, formatter, context, targets);
        this.dropConstraintsTablesSequences(metadata, options, inclusionFilter, dialect, formatter, context, targets);
        SchemaDropperImpl.dropAuxiliaryObjectsAfterTables(metadata, options, dialect, formatter, context, targets);
        SchemaDropperImpl.dropUserDefinedTypes(metadata, options, this.schemaFilter, dialect, formatter, context, targets);
        SchemaDropperImpl.dropSchemasAndCatalogs(metadata, options, this.schemaFilter, dialect, formatter, context, targets);
    }

    private void dropConstraintsTablesSequences(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        HashSet<String> exportIdentifiers = CollectionHelper.setOfSize(50);
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!this.schemaFilter.includeNamespace(namespace)) continue;
            this.applyConstraintDropping(namespace, metadata, formatter, options, context, inclusionFilter, targets);
            SchemaDropperImpl.dropTables(metadata, options, this.schemaFilter, inclusionFilter, dialect, formatter, exportIdentifiers, context, namespace, targets);
            SchemaDropperImpl.dropSequences(metadata, options, this.schemaFilter, inclusionFilter, dialect, formatter, exportIdentifiers, context, namespace, targets);
        }
    }

    private static void dropAuxiliaryObjectsBeforeTables(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : SchemaDropperImpl.reverse(metadata.getDatabase().getAuxiliaryDatabaseObjects())) {
            if (auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            Helper.applySqlStrings(dialect.getAuxiliaryDatabaseObjectExporter().getSqlDropStrings(auxiliaryDatabaseObject, metadata, context), formatter, options, targets);
        }
    }

    private static void dropAuxiliaryObjectsAfterTables(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : SchemaDropperImpl.reverse(metadata.getDatabase().getAuxiliaryDatabaseObjects())) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            Helper.applySqlStrings(auxiliaryDatabaseObject.sqlDropStrings(context), formatter, options, targets);
        }
    }

    private static void dropSequences(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, ContributableMatcher inclusionFilter, Dialect dialect, Formatter formatter, Set<String> exportIdentifiers, SqlStringGenerationContext context, Namespace namespace, GenerationTarget[] targets) {
        for (Sequence sequence : namespace.getSequences()) {
            if (!schemaFilter.includeSequence(sequence) || !inclusionFilter.matches(sequence)) continue;
            SchemaDropperImpl.checkExportIdentifier(sequence, exportIdentifiers);
            Helper.applySqlStrings(dialect.getSequenceExporter().getSqlDropStrings(sequence, metadata, context), formatter, options, targets);
        }
    }

    private static void dropTables(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, ContributableMatcher inclusionFilter, Dialect dialect, Formatter formatter, Set<String> exportIdentifiers, SqlStringGenerationContext context, Namespace namespace, GenerationTarget[] targets) {
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !table.isView() || !schemaFilter.includeTable(table) || !inclusionFilter.matches(table)) continue;
            SchemaDropperImpl.checkExportIdentifier(table, exportIdentifiers);
            Helper.applySqlStrings(dialect.getTableExporter().getSqlDropStrings(table, metadata, context), formatter, options, targets);
        }
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || table.isView() || !schemaFilter.includeTable(table) || !inclusionFilter.matches(table)) continue;
            SchemaDropperImpl.checkExportIdentifier(table, exportIdentifiers);
            Helper.applySqlStrings(dialect.getTableExporter().getSqlDropStrings(table, metadata, context), formatter, options, targets);
        }
    }

    static void dropUserDefinedTypes(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!schemaFilter.includeNamespace(namespace)) continue;
            List<UserDefinedType> dependencyOrderedUserDefinedTypes = namespace.getDependencyOrderedUserDefinedTypes();
            Collections.reverse(dependencyOrderedUserDefinedTypes);
            for (UserDefinedType userDefinedType : dependencyOrderedUserDefinedTypes) {
                Helper.applySqlStrings(dialect.getUserDefinedTypeExporter().getSqlDropStrings(userDefinedType, metadata, context), formatter, options, targets);
            }
        }
    }

    private static void dropSchemasAndCatalogs(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        boolean tryToDropSchemas;
        boolean tryToDropCatalogs = options.shouldManageNamespaces() && dialect.canCreateCatalog();
        boolean bl = tryToDropSchemas = options.shouldManageNamespaces() && dialect.canCreateSchema();
        if (tryToDropCatalogs || tryToDropSchemas) {
            HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
            for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
                Identifier schemaPhysicalName;
                if (!schemaFilter.includeNamespace(namespace)) continue;
                Namespace.Name logicalName = namespace.getName();
                Namespace.Name physicalName = namespace.getPhysicalName();
                if (tryToDropSchemas && (schemaPhysicalName = context.schemaWithDefault(physicalName.schema())) != null) {
                    String schemaName = schemaPhysicalName.render(dialect);
                    Helper.applySqlStrings(dialect.getDropSchemaCommand(schemaName), formatter, options, targets);
                }
                if (!tryToDropCatalogs) continue;
                Identifier catalogLogicalName = logicalName.catalog();
                Identifier catalogPhysicalName = context.catalogWithDefault(physicalName.catalog());
                if (catalogPhysicalName == null || exportedCatalogs.contains(catalogLogicalName)) continue;
                String catalogName = catalogPhysicalName.render(dialect);
                Helper.applySqlStrings(dialect.getDropCatalogCommand(catalogName), formatter, options, targets);
                exportedCatalogs.add(catalogLogicalName);
            }
        }
    }

    private static Collection<AuxiliaryDatabaseObject> reverse(Collection<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects) {
        ArrayList<AuxiliaryDatabaseObject> list = new ArrayList<AuxiliaryDatabaseObject>(auxiliaryDatabaseObjects);
        Collections.reverse(list);
        return list;
    }

    private void applyConstraintDropping(Namespace namespace, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext context, ContributableMatcher inclusionFilter, GenerationTarget ... targets) {
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        if (dialect.dropConstraints()) {
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable() || !this.schemaFilter.includeTable(table) || !inclusionFilter.matches(table)) continue;
                for (ForeignKey foreignKey : table.getForeignKeyCollection()) {
                    Helper.applySqlStrings(dialect.getForeignKeyExporter().getSqlDropStrings(foreignKey, metadata, context), formatter, options, targets);
                }
            }
        }
    }

    private static void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
    }

    @Override
    public DelayedDropAction buildDelayedAction(Metadata metadata, ExecutionOptions options, ContributableMatcher inclusionFilter, SourceDescriptor sourceDescriptor) {
        JournalingGenerationTarget target = new JournalingGenerationTarget();
        Dialect dialect = this.tool.getServiceRegistry().requireService(JdbcEnvironment.class).getDialect();
        this.doDrop(metadata, options, inclusionFilter, dialect, sourceDescriptor, target);
        return new DelayedDropActionImpl(target.commands, this.tool.getCustomDatabaseGenerationTarget());
    }

    public void doDrop(Metadata metadata, boolean manageNamespaces, GenerationTarget ... targets) {
        StandardServiceRegistry serviceRegistry = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry();
        this.doDrop(metadata, serviceRegistry, serviceRegistry.requireService(ConfigurationService.class).getSettings(), manageNamespaces, targets);
    }

    public void doDrop(Metadata metadata, ServiceRegistry serviceRegistry, final Map<String, Object> settings, final boolean manageNamespaces, GenerationTarget ... targets) {
        if (targets == null || targets.length == 0) {
            JdbcContext jdbcContext = this.tool.resolveJdbcContext(settings);
            targets = new GenerationTarget[]{new GenerationTargetToDatabase(serviceRegistry.requireService(TransactionCoordinatorBuilder.class).buildDdlTransactionIsolator(jdbcContext), true)};
        }
        this.doDrop(metadata, new ExecutionOptions(){

            @Override
            public boolean shouldManageNamespaces() {
                return manageNamespaces;
            }

            @Override
            public Map<String, Object> getConfigurationValues() {
                return settings;
            }

            @Override
            public ExceptionHandler getExceptionHandler() {
                return ExceptionHandlerLoggedImpl.INSTANCE;
            }
        }, (ContributableDatabaseObject contributed) -> true, serviceRegistry.requireService(JdbcEnvironment.class).getDialect(), new SourceDescriptor(){

            @Override
            public SourceType getSourceType() {
                return SourceType.METADATA;
            }

            @Override
            public ScriptSourceInput getScriptSourceInput() {
                return null;
            }
        }, targets);
    }

    private static class JournalingGenerationTarget
    implements GenerationTarget {
        private final ArrayList<String> commands = new ArrayList();

        private JournalingGenerationTarget() {
        }

        @Override
        public void prepare() {
        }

        @Override
        public void accept(String command) {
            this.commands.add(command);
        }

        @Override
        public void release() {
        }
    }

    private static class DelayedDropActionImpl
    implements DelayedDropAction,
    Serializable {
        private static final CoreMessageLogger log = CoreLogging.messageLogger(DelayedDropActionImpl.class);
        private final ArrayList<String> commands;
        private GenerationTarget target;

        public DelayedDropActionImpl(ArrayList<String> commands, GenerationTarget target) {
            this.commands = commands;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform(ServiceRegistry serviceRegistry) {
            log.startingDelayedSchemaDrop();
            JdbcContextDelayedDropImpl jdbcContext = new JdbcContextDelayedDropImpl(serviceRegistry);
            if (this.target == null) {
                this.target = new GenerationTargetToDatabase(serviceRegistry.requireService(TransactionCoordinatorBuilder.class).buildDdlTransactionIsolator(jdbcContext), true);
            }
            this.target.prepare();
            try {
                for (String command : this.commands) {
                    try {
                        this.target.accept(command);
                    }
                    catch (CommandAcceptanceException e) {
                        log.unsuccessfulSchemaManagementCommand(command);
                        log.debugf((Throwable)((Object)e), "Error performing delayed DROP command [%s]", command);
                    }
                }
            }
            finally {
                this.target.release();
            }
        }

        private static class JdbcContextDelayedDropImpl
        implements JdbcContext {
            private final ServiceRegistry serviceRegistry;
            private final JdbcServices jdbcServices;
            private final JdbcConnectionAccess jdbcConnectionAccess;

            public JdbcContextDelayedDropImpl(ServiceRegistry serviceRegistry) {
                this.serviceRegistry = serviceRegistry;
                this.jdbcServices = serviceRegistry.requireService(JdbcServices.class);
                this.jdbcConnectionAccess = this.jdbcServices.getBootstrapJdbcConnectionAccess();
                if (this.jdbcConnectionAccess == null) {
                    throw new SchemaManagementException("Could not build JDBC Connection context to drop schema on SessionFactory close");
                }
            }

            @Override
            public JdbcConnectionAccess getJdbcConnectionAccess() {
                return this.jdbcConnectionAccess;
            }

            @Override
            public Dialect getDialect() {
                return this.jdbcServices.getJdbcEnvironment().getDialect();
            }

            @Override
            public SqlStatementLogger getSqlStatementLogger() {
                return this.jdbcServices.getSqlStatementLogger();
            }

            @Override
            public SqlExceptionHelper getSqlExceptionHelper() {
                return this.jdbcServices.getSqlExceptionHelper();
            }

            @Override
            public ServiceRegistry getServiceRegistry() {
                return this.serviceRegistry;
            }
        }
    }
}

