/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import java.io.Serializable;
import org.hibernate.SharedSessionContract;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

public class AttributeConverterMutabilityPlanImpl<T, S>
extends MutableMutabilityPlan<T> {
    private final JpaAttributeConverter<T, S> converter;
    private final boolean mutable;

    public AttributeConverterMutabilityPlanImpl(JpaAttributeConverter<T, S> converter, boolean mutable) {
        this.converter = converter;
        this.mutable = mutable;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    protected T deepCopyNotNull(T value) {
        return (T)this.converter.toDomainValue(this.converter.toRelationalValue(value));
    }

    @Override
    public Serializable disassemble(T value, SharedSessionContract session) {
        return this.mutable ? (Serializable)this.converter.toRelationalValue(value) : (Serializable)value;
    }

    @Override
    public T assemble(Serializable cached, SharedSessionContract session) {
        return (T)(this.mutable ? this.converter.toDomainValue(cached) : cached);
    }
}

