/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.ArrayBackedBinaryStream;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractArrayJavaType;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

@AllowReflection
public class BooleanPrimitiveArrayJavaType
extends AbstractArrayJavaType<boolean[], Boolean> {
    public static final BooleanPrimitiveArrayJavaType INSTANCE = new BooleanPrimitiveArrayJavaType();

    private BooleanPrimitiveArrayJavaType() {
        this(BooleanJavaType.INSTANCE);
    }

    protected BooleanPrimitiveArrayJavaType(JavaType<Boolean> baseDescriptor) {
        super(boolean[].class, baseDescriptor, new ArrayMutabilityPlan());
    }

    @Override
    public String extractLoggableRepresentation(boolean[] value) {
        return value == null ? super.extractLoggableRepresentation(null) : Arrays.toString(value);
    }

    @Override
    public boolean areEqual(boolean[] one, boolean[] another) {
        return Arrays.equals(one, another);
    }

    @Override
    public int extractHashCode(boolean[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    public String toString(boolean[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(value[0]);
        for (int i = 1; i < value.length; ++i) {
            sb.append(value[i]);
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean[] fromString(CharSequence charSequence) {
        int elementStart;
        if (charSequence == null) {
            return null;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        char lastChar = charSequence.charAt(charSequence.length() - 1);
        char firstChar = charSequence.charAt(0);
        if (firstChar != '{' || lastChar != '}') {
            throw new IllegalArgumentException("Cannot parse given string into array of strings. First and last character must be { and }");
        }
        int len = charSequence.length();
        for (int i = elementStart = 1; i < len; ++i) {
            char c = charSequence.charAt(i);
            if (c != ',') continue;
            list.add(Boolean.parseBoolean(charSequence.subSequence(elementStart, i).toString()));
            elementStart = i + 1;
        }
        boolean[] result = new boolean[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Boolean)list.get(i);
        }
        return result;
    }

    @Override
    public <X> X unwrap(boolean[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (Object[].class.isAssignableFrom(type)) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object[] unwrapped = (Object[])Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                unwrapped[i] = this.getElementJavaType().unwrap(value[i], preferredJavaTypeClass, options);
            }
            return (X)unwrapped;
        }
        if (type == byte[].class) {
            return (X)SerializationHelper.serialize((Serializable)value);
        }
        if (type == BinaryStream.class) {
            return (X)new ArrayBackedBinaryStream(SerializationHelper.serialize((Serializable)value));
        }
        if (type.isArray()) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object unwrapped = Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                Array.set(unwrapped, i, this.getElementJavaType().unwrap(value[i], preferredJavaTypeClass, options));
            }
            return (X)unwrapped;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> boolean[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Array) {
            java.sql.Array array = (java.sql.Array)value;
            try {
                value = array.getArray();
            }
            catch (SQLException ex) {
                throw new HibernateException(ex);
            }
        }
        if (value instanceof boolean[]) {
            boolean[] booleans = (boolean[])value;
            return booleans;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return (boolean[])SerializationHelper.deserialize(bytes);
        }
        if (value instanceof BinaryStream) {
            BinaryStream binaryStream = (BinaryStream)value;
            return (boolean[])SerializationHelper.deserialize(binaryStream.getBytes());
        }
        if (value.getClass().isArray()) {
            boolean[] wrapped = new boolean[Array.getLength(value)];
            for (int i = 0; i < wrapped.length; ++i) {
                wrapped[i] = (Boolean)this.getElementJavaType().wrap(Array.get(value, i), options);
            }
            return wrapped;
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return new boolean[]{booleanValue};
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            boolean[] wrapped = new boolean[collection.size()];
            int i = 0;
            for (Object e : collection) {
                wrapped[i++] = (Boolean)this.getElementJavaType().wrap(e, options);
            }
            return wrapped;
        }
        throw this.unknownWrap(value.getClass());
    }

    private static class ArrayMutabilityPlan
    extends MutableMutabilityPlan<boolean[]> {
        private ArrayMutabilityPlan() {
        }

        @Override
        protected boolean[] deepCopyNotNull(boolean[] value) {
            return (boolean[])value.clone();
        }
    }
}

