/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.NClob;
import java.util.Arrays;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

public class PrimitiveCharacterArrayJavaType
extends AbstractClassJavaType<char[]> {
    public static final PrimitiveCharacterArrayJavaType INSTANCE = new PrimitiveCharacterArrayJavaType();

    protected PrimitiveCharacterArrayJavaType() {
        super(char[].class, new ArrayMutabilityPlan(), IncomparableComparator.INSTANCE);
    }

    @Override
    public String toString(char[] value) {
        return new String(value);
    }

    @Override
    public char[] fromString(CharSequence string) {
        return string.toString().toCharArray();
    }

    @Override
    public boolean areEqual(char[] one, char[] another) {
        return one == another || one != null && another != null && Arrays.equals(one, another);
    }

    @Override
    public int extractHashCode(char[] chars) {
        int hashCode = 1;
        for (char aChar : chars) {
            hashCode = 31 * hashCode + aChar;
        }
        return hashCode;
    }

    @Override
    public <X> X unwrap(char[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (char[].class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)new String(value);
        }
        if (NClob.class.isAssignableFrom(type)) {
            return (X)options.getLobCreator().createNClob(new String(value));
        }
        if (Clob.class.isAssignableFrom(type)) {
            return (X)options.getLobCreator().createClob(new String(value));
        }
        if (Reader.class.isAssignableFrom(type)) {
            return (X)new StringReader(new String(value));
        }
        if (CharacterStream.class.isAssignableFrom(type)) {
            return (X)new CharacterStreamImpl(new String(value));
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> char[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof char[]) {
            char[] chars = (char[])value;
            return chars;
        }
        if (value instanceof String) {
            String string = (String)value;
            return string.toCharArray();
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return DataHelper.extractString(clob).toCharArray();
        }
        if (value instanceof Reader) {
            Reader reader = (Reader)value;
            return DataHelper.extractString(reader).toCharArray();
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return new char[]{character.charValue()};
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public <X> char[] coerce(X value, JavaType.CoercionContext coercionContext) {
        return this.wrap(value, (WrapperOptions)null);
    }

    private static class ArrayMutabilityPlan
    extends MutableMutabilityPlan<char[]> {
        private ArrayMutabilityPlan() {
        }

        @Override
        protected char[] deepCopyNotNull(char[] value) {
            return (char[])value.clone();
        }
    }
}

