/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JsonHelper;

public class JsonJdbcType
implements AggregateJdbcType {
    public static final JsonJdbcType INSTANCE = new JsonJdbcType(null);
    private final EmbeddableMappingType embeddableMappingType;

    protected JsonJdbcType(EmbeddableMappingType embeddableMappingType) {
        this.embeddableMappingType = embeddableMappingType;
    }

    @Override
    public int getJdbcTypeCode() {
        return 12;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3001;
    }

    public String toString() {
        return "JsonJdbcType";
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return null;
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new JsonJdbcType(mappingType);
    }

    @Override
    public EmbeddableMappingType getEmbeddableMappingType() {
        return this.embeddableMappingType;
    }

    protected <X> X fromString(String string, JavaType<X> javaType, WrapperOptions options) throws SQLException {
        if (string == null) {
            return null;
        }
        if (this.embeddableMappingType != null) {
            return JsonHelper.fromString(this.embeddableMappingType, string, javaType.getJavaTypeClass() != Object[].class, options);
        }
        return options.getJsonFormatMapper().fromString(string, javaType, options);
    }

    @Override
    public Object createJdbcValue(Object domainValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        return JsonHelper.toString(this.embeddableMappingType, domainValue, options);
    }

    @Override
    public Object[] extractJdbcValues(Object rawJdbcValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        return (Object[])JsonHelper.fromString(this.embeddableMappingType, (String)rawJdbcValue, false, options);
    }

    protected <X> String toString(X value, JavaType<X> javaType, WrapperOptions options) {
        if (this.embeddableMappingType != null) {
            return JsonHelper.toString(this.embeddableMappingType, value, options);
        }
        return options.getJsonFormatMapper().toString(value, javaType, options);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String json = ((JsonJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(index, json);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String json = ((JsonJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(name, json);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return JsonJdbcType.this.fromString(rs.getString(paramIndex), this.getJavaType(), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return JsonJdbcType.this.fromString(statement.getString(index), this.getJavaType(), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return JsonJdbcType.this.fromString(statement.getString(name), this.getJavaType(), options);
            }
        };
    }
}

