/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Calendar;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterTemporal;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampWithTimeZoneJdbcType
implements JdbcType {
    public static final TimestampWithTimeZoneJdbcType INSTANCE = new TimestampWithTimeZoneJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 2014;
    }

    @Override
    public String getFriendlyName() {
        return "TIMESTAMP_WITH_TIMEZONE";
    }

    public String toString() {
        return "TimestampWithTimeZoneDescriptor";
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)OffsetDateTime.class));
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterTemporal<T>(javaType, TemporalType.TIMESTAMP);
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return OffsetDateTime.class;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                try {
                    OffsetDateTime dateTime = javaType.unwrap(value, OffsetDateTime.class, options);
                    st.setObject(index, (Object)dateTime, 2014);
                }
                catch (AbstractMethodError | SQLException e) {
                    Timestamp timestamp = javaType.unwrap(value, Timestamp.class, options);
                    if (value instanceof Calendar) {
                        Calendar calendar = (Calendar)value;
                        st.setTimestamp(index, timestamp, calendar);
                    }
                    if (options.getJdbcTimeZone() != null) {
                        st.setTimestamp(index, timestamp, Calendar.getInstance(options.getJdbcTimeZone()));
                    }
                    st.setTimestamp(index, timestamp);
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                try {
                    OffsetDateTime dateTime = javaType.unwrap(value, OffsetDateTime.class, options);
                    st.setObject(name, (Object)dateTime, 2014);
                }
                catch (AbstractMethodError | SQLException e) {
                    Timestamp timestamp = javaType.unwrap(value, Timestamp.class, options);
                    if (value instanceof Calendar) {
                        Calendar calendar = (Calendar)value;
                        st.setTimestamp(name, timestamp, calendar);
                    }
                    if (options.getJdbcTimeZone() != null) {
                        st.setTimestamp(name, timestamp, Calendar.getInstance(options.getJdbcTimeZone()));
                    }
                    st.setTimestamp(name, timestamp);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int position, WrapperOptions options) throws SQLException {
                try {
                    return javaType.wrap(rs.getObject(position, OffsetDateTime.class), options);
                }
                catch (AbstractMethodError | SQLException e) {
                    return options.getJdbcTimeZone() != null ? javaType.wrap(rs.getTimestamp(position, Calendar.getInstance(options.getJdbcTimeZone())), options) : javaType.wrap(rs.getTimestamp(position), options);
                }
            }

            @Override
            protected X doExtract(CallableStatement statement, int position, WrapperOptions options) throws SQLException {
                try {
                    return javaType.wrap(statement.getObject(position, OffsetDateTime.class), options);
                }
                catch (AbstractMethodError | SQLException e) {
                    return options.getJdbcTimeZone() != null ? javaType.wrap(statement.getTimestamp(position, Calendar.getInstance(options.getJdbcTimeZone())), options) : javaType.wrap(statement.getTimestamp(position), options);
                }
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                try {
                    return javaType.wrap(statement.getObject(name, OffsetDateTime.class), options);
                }
                catch (AbstractMethodError | SQLException e) {
                    return options.getJdbcTimeZone() != null ? javaType.wrap(statement.getTimestamp(name, Calendar.getInstance(options.getJdbcTimeZone())), options) : javaType.wrap(statement.getTimestamp(name), options);
                }
            }
        };
    }
}

