/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.spi;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeFamilyInformation;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.descriptor.jdbc.SqlTypedJdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcTypeBaseline;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class JdbcTypeRegistry
implements JdbcTypeBaseline.BaselineTarget,
Serializable {
    private static final Logger log = Logger.getLogger(JdbcTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final ConcurrentHashMap<Integer, JdbcType> descriptorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, JdbcTypeConstructor> descriptorConstructorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AggregateJdbcType> aggregateDescriptorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<TypeConstructedJdbcTypeKey, JdbcType> typeConstructorDescriptorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SqlTypedJdbcType> sqlTypedDescriptorMap = new ConcurrentHashMap();

    public JdbcTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        JdbcTypeBaseline.prime(this);
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public void addDescriptor(JdbcType jdbcType) {
        JdbcType previous = this.descriptorMap.put(jdbcType.getDefaultSqlTypeCode(), jdbcType);
        if (previous != null && previous != jdbcType) {
            log.debugf("addDescriptor(%s) replaced previous registration(%s)", (Object)jdbcType, (Object)previous);
        }
    }

    @Override
    public void addDescriptor(int typeCode, JdbcType jdbcType) {
        JdbcType previous = this.descriptorMap.put(typeCode, jdbcType);
        if (previous != null && previous != jdbcType) {
            log.debugf("addDescriptor(%d, %s) replaced previous registration(%s)", typeCode, (Object)jdbcType, (Object)previous);
        }
    }

    public void addDescriptorIfAbsent(JdbcType jdbcType) {
        this.descriptorMap.putIfAbsent(jdbcType.getDefaultSqlTypeCode(), jdbcType);
    }

    public void addDescriptorIfAbsent(int typeCode, JdbcType jdbcType) {
        this.descriptorMap.putIfAbsent(typeCode, jdbcType);
    }

    public JdbcType findDescriptor(int jdbcTypeCode) {
        return this.descriptorMap.get(jdbcTypeCode);
    }

    public JdbcType getDescriptor(int jdbcTypeCode) {
        JdbcType potentialAlternateDescriptor;
        JdbcType descriptor = this.descriptorMap.get(jdbcTypeCode);
        if (descriptor != null) {
            return descriptor;
        }
        if (JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode)) {
            log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", jdbcTypeCode);
        }
        if ((potentialAlternateDescriptor = this.getFamilyDescriptor(jdbcTypeCode)) != null) {
            return potentialAlternateDescriptor;
        }
        ObjectJdbcType fallBackDescriptor = new ObjectJdbcType(jdbcTypeCode);
        this.addDescriptor(fallBackDescriptor);
        return fallBackDescriptor;
    }

    private JdbcType getFamilyDescriptor(int jdbcTypeCode) {
        JdbcTypeFamilyInformation.Family family = JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode);
        if (family != null) {
            for (int potentialAlternateTypeCode : family.getTypeCodes()) {
                if (potentialAlternateTypeCode == jdbcTypeCode) continue;
                JdbcType potentialAlternateDescriptor = this.descriptorMap.get(potentialAlternateTypeCode);
                if (potentialAlternateDescriptor != null) {
                    return potentialAlternateDescriptor;
                }
                if (!JdbcTypeNameMapper.isStandardTypeCode(potentialAlternateTypeCode)) continue;
                log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", potentialAlternateTypeCode);
            }
        }
        return null;
    }

    public AggregateJdbcType resolveAggregateDescriptor(int jdbcTypeCode, String typeName, EmbeddableMappingType embeddableMappingType, RuntimeModelCreationContext context) {
        String registrationKey;
        if (typeName != null) {
            registrationKey = typeName.toLowerCase(Locale.ROOT);
            AggregateJdbcType aggregateJdbcType = this.aggregateDescriptorMap.get(registrationKey);
            if (aggregateJdbcType != null) {
                if (aggregateJdbcType.getEmbeddableMappingType() != embeddableMappingType) {
                    return aggregateJdbcType.resolveAggregateJdbcType(embeddableMappingType, typeName, context);
                }
                return aggregateJdbcType;
            }
        } else {
            registrationKey = null;
        }
        return this.resolveAggregateDescriptor(jdbcTypeCode, typeName, embeddableMappingType, context, registrationKey);
    }

    private AggregateJdbcType resolveAggregateDescriptor(int jdbcTypeCode, String typeName, EmbeddableMappingType embeddableMappingType, RuntimeModelCreationContext context, String registrationKey) {
        JdbcType descriptor = this.getDescriptor(jdbcTypeCode);
        if (descriptor instanceof AggregateJdbcType) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)descriptor;
            AggregateJdbcType resolvedJdbcType = aggregateJdbcType.resolveAggregateJdbcType(embeddableMappingType, typeName, context);
            this.cacheAggregateJdbcType(registrationKey, resolvedJdbcType);
            return resolvedJdbcType;
        }
        throw new IllegalArgumentException(String.format("Tried to resolve the JdbcType [%s] as AggregateJdbcType but it does not implement that interface!", descriptor.getClass().getName()));
    }

    private void cacheAggregateJdbcType(String registrationKey, AggregateJdbcType resolvedJdbcType) {
        if (registrationKey != null) {
            this.aggregateDescriptorMap.put(registrationKey, resolvedJdbcType);
            if (resolvedJdbcType instanceof SqlTypedJdbcType) {
                SqlTypedJdbcType sqlTypedJdbcType = (SqlTypedJdbcType)((Object)resolvedJdbcType);
                this.sqlTypedDescriptorMap.put(sqlTypedJdbcType.getSqlTypeName().toLowerCase(Locale.ROOT), sqlTypedJdbcType);
            }
        }
    }

    public AggregateJdbcType findAggregateDescriptor(String typeName) {
        return this.aggregateDescriptorMap.get(typeName.toLowerCase(Locale.ROOT));
    }

    public SqlTypedJdbcType findSqlTypedDescriptor(String sqlTypeName) {
        return this.sqlTypedDescriptorMap.get(sqlTypeName.toLowerCase(Locale.ROOT));
    }

    public JdbcType resolveTypeConstructorDescriptor(int jdbcTypeConstructorCode, BasicType<?> elementType, @Nullable ColumnTypeInformation columnTypeInformation) {
        return this.resolveTypeConstructorDescriptor(jdbcTypeConstructorCode, (Object)elementType, columnTypeInformation);
    }

    public JdbcType resolveTypeConstructorDescriptor(int jdbcTypeConstructorCode, JdbcType elementType, @Nullable ColumnTypeInformation columnTypeInformation) {
        return this.resolveTypeConstructorDescriptor(jdbcTypeConstructorCode, (Object)elementType, columnTypeInformation);
    }

    private JdbcType resolveTypeConstructorDescriptor(int jdbcTypeConstructorCode, Object elementType, @Nullable ColumnTypeInformation columnTypeInformation) {
        TypeConstructedJdbcTypeKey key = columnTypeInformation == null ? new TypeConstructedJdbcTypeKey(jdbcTypeConstructorCode, elementType) : new TypeConstructedJdbcTypeKey(jdbcTypeConstructorCode, elementType, columnTypeInformation);
        JdbcType descriptor = this.typeConstructorDescriptorMap.get(key);
        if (descriptor != null) {
            return descriptor;
        }
        JdbcTypeConstructor jdbcTypeConstructor = this.getConstructor(jdbcTypeConstructorCode);
        if (jdbcTypeConstructor != null) {
            JdbcType jdbcType = this.jdbcElementType(elementType, columnTypeInformation, jdbcTypeConstructor);
            JdbcType existingType = this.typeConstructorDescriptorMap.putIfAbsent(key, jdbcType);
            if (existingType != null) {
                return existingType;
            }
            if (jdbcType instanceof SqlTypedJdbcType) {
                SqlTypedJdbcType sqlTypedJdbcType = (SqlTypedJdbcType)jdbcType;
                this.sqlTypedDescriptorMap.put(sqlTypedJdbcType.getSqlTypeName().toLowerCase(Locale.ROOT), sqlTypedJdbcType);
            }
            return jdbcType;
        }
        return this.getDescriptor(jdbcTypeConstructorCode);
    }

    private JdbcType jdbcElementType(Object elementType, ColumnTypeInformation columnTypeInformation, JdbcTypeConstructor jdbcTypeConstructor) {
        Dialect dialect = this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
        if (elementType instanceof BasicType) {
            BasicType basicType = (BasicType)elementType;
            return jdbcTypeConstructor.resolveType(this.typeConfiguration, dialect, basicType, columnTypeInformation);
        }
        return jdbcTypeConstructor.resolveType(this.typeConfiguration, dialect, (JdbcType)elementType, columnTypeInformation);
    }

    public boolean hasRegisteredDescriptor(int jdbcTypeCode) {
        return this.descriptorMap.containsKey(jdbcTypeCode) || JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode) || JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode) != null;
    }

    public JdbcTypeConstructor getConstructor(int jdbcTypeCode) {
        return this.descriptorConstructorMap.get(jdbcTypeCode);
    }

    public void addTypeConstructor(int jdbcTypeCode, JdbcTypeConstructor jdbcTypeConstructor) {
        this.descriptorConstructorMap.put(jdbcTypeCode, jdbcTypeConstructor);
    }

    public void addTypeConstructor(JdbcTypeConstructor jdbcTypeConstructor) {
        this.addTypeConstructor(jdbcTypeConstructor.getDefaultSqlTypeCode(), jdbcTypeConstructor);
    }

    public void addTypeConstructorIfAbsent(int jdbcTypeCode, JdbcTypeConstructor jdbcTypeConstructor) {
        this.descriptorConstructorMap.putIfAbsent(jdbcTypeCode, jdbcTypeConstructor);
    }

    public void addTypeConstructorIfAbsent(JdbcTypeConstructor jdbcTypeConstructor) {
        this.addTypeConstructorIfAbsent(jdbcTypeConstructor.getDefaultSqlTypeCode(), jdbcTypeConstructor);
    }

    private record TypeConstructedJdbcTypeKey(int typeConstructorTypeCode, int typeCode, @Nullable Boolean nullable, @Nullable String typeName, int columnSize, int decimalDigits, Object jdbcTypeOrBasicType) {
        private TypeConstructedJdbcTypeKey(int typeConstructorTypeCode, Object jdbcTypeOrBasicType) {
            this(typeConstructorTypeCode, 1111, null, null, 0, 0, jdbcTypeOrBasicType);
        }

        private TypeConstructedJdbcTypeKey(int typeConstructorTypeCode, Object jdbcTypeOrBasicType, ColumnTypeInformation columnTypeInformation) {
            this(typeConstructorTypeCode, columnTypeInformation.getTypeCode(), columnTypeInformation.getNullable(), columnTypeInformation.getTypeName(), columnTypeInformation.getColumnSize(), columnTypeInformation.getDecimalDigits(), jdbcTypeOrBasicType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypeConstructedJdbcTypeKey)) {
                return false;
            }
            TypeConstructedJdbcTypeKey that = (TypeConstructedJdbcTypeKey)o;
            return this.typeConstructorTypeCode == that.typeConstructorTypeCode && this.typeCode == that.typeCode && this.columnSize == that.columnSize && this.decimalDigits == that.decimalDigits && Objects.equals(this.nullable, that.nullable) && Objects.equals(this.typeName, that.typeName) && this.jdbcTypeOrBasicType.equals(that.jdbcTypeOrBasicType);
        }

        @Override
        public int hashCode() {
            int result = this.typeConstructorTypeCode;
            result = 31 * result + this.jdbcTypeOrBasicType.hashCode();
            result = 31 * result + (this.nullable == null ? 0 : this.nullable.hashCode());
            result = 31 * result + this.typeCode;
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            result = 31 * result + this.columnSize;
            result = 31 * result + this.decimalDigits;
            return result;
        }
    }
}

