/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.io.Serializable;
import java.util.Comparator;
import org.hibernate.SharedSessionContract;
import org.hibernate.annotations.Immutable;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlanExposer;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.UserType;

public class UserTypeJavaTypeWrapper<J>
implements BasicJavaType<J> {
    protected final UserType<J> userType;
    private final MutabilityPlan<J> mutabilityPlan;
    private final Comparator<J> comparator;

    public UserTypeJavaTypeWrapper(UserType<J> userType) {
        Class<J> jClass;
        this.userType = userType;
        MutabilityPlan resolvedMutabilityPlan = null;
        if (userType instanceof MutabilityPlanExposer) {
            resolvedMutabilityPlan = ((MutabilityPlanExposer)((Object)userType)).getExposedMutabilityPlan();
        }
        if (resolvedMutabilityPlan == null && (jClass = userType.returnedClass()) != null && jClass.getAnnotation(Immutable.class) != null) {
            resolvedMutabilityPlan = ImmutableMutabilityPlan.instance();
        }
        if (resolvedMutabilityPlan == null) {
            resolvedMutabilityPlan = new MutabilityPlanWrapper(userType);
        }
        this.mutabilityPlan = resolvedMutabilityPlan;
        this.comparator = userType instanceof Comparator ? (Comparator)((Object)userType) : this::compare;
    }

    private int compare(J first, J second) {
        return this.userType.equals(first, second) ? 0 : Comparator.comparing(this.userType::hashCode).compare(first, second);
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return this.userType.getJdbcType(context.getTypeConfiguration());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return this.userType.getDefaultSqlLength(dialect, jdbcType);
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return this.userType.getDefaultSqlPrecision(dialect, jdbcType);
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return this.userType.getDefaultSqlScale(dialect, jdbcType);
    }

    @Override
    public Comparator<J> getComparator() {
        return this.comparator;
    }

    @Override
    public int extractHashCode(J value) {
        return this.userType.hashCode(value);
    }

    @Override
    public boolean areEqual(J one, J another) {
        return this.userType.equals(one, another);
    }

    @Override
    public J fromString(CharSequence string) {
        UserType<J> userType = this.userType;
        if (userType instanceof EnhancedUserType) {
            EnhancedUserType enhancedUserType = (EnhancedUserType)userType;
            return enhancedUserType.fromStringValue(string);
        }
        throw new UnsupportedOperationException("No support for parsing UserType values from String: " + String.valueOf(this.userType));
    }

    @Override
    public String toString(J value) {
        String string;
        UserType<J> userType;
        if (this.userType.returnedClass().isInstance(value) && (userType = this.userType) instanceof EnhancedUserType) {
            EnhancedUserType enhancedUserType = (EnhancedUserType)userType;
            string = enhancedUserType.toString(value);
        } else {
            string = value == null ? "null" : value.toString();
        }
        return string;
    }

    @Override
    public <X> X unwrap(J value, Class<X> type, WrapperOptions options) {
        BasicValueConverter<J, Object> converter = this.userType.getValueConverter();
        if (value != null && !type.isInstance(value) && converter != null) {
            Object relationalValue = converter.toRelationalValue(value);
            return converter.getRelationalJavaType().unwrap(relationalValue, type, options);
        }
        return (X)value;
    }

    @Override
    public <X> J wrap(X value, WrapperOptions options) {
        BasicValueConverter<J, Object> converter = this.userType.getValueConverter();
        if (value != null && !this.userType.returnedClass().isInstance(value) && converter != null) {
            J domainValue = converter.toDomainValue(value);
            return converter.getDomainJavaType().wrap(domainValue, options);
        }
        return (J)value;
    }

    @Override
    public Class<J> getJavaTypeClass() {
        return this.userType.returnedClass();
    }

    public static class MutabilityPlanWrapper<J>
    implements MutabilityPlan<J> {
        private final UserType<J> userType;

        public MutabilityPlanWrapper(UserType<J> userType) {
            this.userType = userType;
        }

        @Override
        public boolean isMutable() {
            return this.userType.isMutable();
        }

        @Override
        public J deepCopy(J value) {
            return this.userType.deepCopy(value);
        }

        @Override
        public Serializable disassemble(J value, SharedSessionContract session) {
            Serializable disassembled = this.userType.disassemble(value);
            if (disassembled == null && value != null) {
                BasicValueConverter<J, Object> converter = this.userType.getValueConverter();
                return converter == null ? (Serializable)value : converter.getRelationalJavaType().getMutabilityPlan().disassemble(converter.toRelationalValue(value), session);
            }
            return disassembled;
        }

        @Override
        public J assemble(Serializable cached, SharedSessionContract session) {
            J assembled = this.userType.assemble(cached, null);
            if (assembled == null && cached != null) {
                BasicValueConverter<J, Object> converter = this.userType.getValueConverter();
                return (J)(converter == null ? cached : converter.toDomainValue(cached));
            }
            return assembled;
        }
    }
}

