/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.spi;

import jakarta.persistence.TemporalType;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BasicTypeRegistration;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.uuid.LocalObjectUuidHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.internal.ArrayTupleType;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.QueryParameterJavaObjectType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.TimeZoneStorageStrategy;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.format.FormatMapper;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.internal.ParameterizedTypeImpl;

@Incubating
public class TypeConfiguration
implements SessionFactoryObserver,
Serializable {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Scope.class);
    private final String uuid = LocalObjectUuidHelper.generateLocalObjectUuid();
    private final Scope scope;
    private final transient JavaTypeRegistry javaTypeRegistry;
    private final transient JdbcTypeRegistry jdbcTypeRegistry;
    private final transient DdlTypeRegistry ddlTypeRegistry;
    private final transient BasicTypeRegistry basicTypeRegistry;
    private final transient Map<Integer, Set<String>> jdbcToHibernateTypeContributionMap = new HashMap<Integer, Set<String>>();
    private final ConcurrentMap<ArrayCacheKey, ArrayTupleType> arrayTuples = new ConcurrentHashMap<ArrayCacheKey, ArrayTupleType>();
    private final ConcurrentHashMap<Type, BasicType<?>> basicTypeByJavaType = new ConcurrentHashMap();

    public TypeConfiguration() {
        this.scope = new Scope(this);
        this.javaTypeRegistry = new JavaTypeRegistry(this);
        this.jdbcTypeRegistry = new JdbcTypeRegistry(this);
        this.ddlTypeRegistry = new DdlTypeRegistry(this);
        this.basicTypeRegistry = new BasicTypeRegistry(this);
        StandardBasicTypes.prime(this);
    }

    public String getUuid() {
        return this.uuid;
    }

    public BasicTypeRegistry getBasicTypeRegistry() {
        return this.basicTypeRegistry;
    }

    public JavaTypeRegistry getJavaTypeRegistry() {
        return this.javaTypeRegistry;
    }

    public JdbcTypeRegistry getJdbcTypeRegistry() {
        return this.jdbcTypeRegistry;
    }

    public DdlTypeRegistry getDdlTypeRegistry() {
        return this.ddlTypeRegistry;
    }

    public JdbcTypeIndicators getCurrentBaseSqlTypeIndicators() {
        return this.scope;
    }

    public Map<Integer, Set<String>> getJdbcToHibernateTypeContributionMap() {
        return this.jdbcToHibernateTypeContributionMap;
    }

    @Deprecated(since="6.2")
    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.scope.getMetadataBuildingContext();
    }

    public void scope(MetadataBuildingContext metadataBuildingContext) {
        log.debugf("Scoping TypeConfiguration [%s] to MetadataBuildingContext [%s]", this, metadataBuildingContext);
        this.scope.setMetadataBuildingContext(metadataBuildingContext);
    }

    public void scope(SessionFactoryImplementor sessionFactory) {
        log.debugf("Scoping TypeConfiguration [%s] to SessionFactoryImplementor [%s]", this, sessionFactory);
        if (this.scope.getMetadataBuildingContext() == null) {
            throw new IllegalStateException("MetadataBuildingContext not known");
        }
        this.scope.setSessionFactory(sessionFactory);
        sessionFactory.addObserver(this);
    }

    @Deprecated(since="6.2")
    public SessionFactoryImplementor getSessionFactory() {
        return this.scope.getSessionFactory();
    }

    @Deprecated(since="6.2")
    public ServiceRegistry getServiceRegistry() {
        return this.scope.getServiceRegistry();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public JpaCompliance getJpaCompliance() {
        return this.scope.getJpaCompliance();
    }

    @Internal
    public Class<?> entityClassForEntityName(String entityName) {
        return this.scope.entityClassForEntityName(entityName);
    }

    @Override
    public void sessionFactoryCreated(SessionFactory factory) {
        log.tracef("Handling #sessionFactoryCreated from [%s] for TypeConfiguration", factory);
        this.scope.setMetadataBuildingContext(null);
    }

    @Override
    public void sessionFactoryClosed(SessionFactory factory) {
        log.tracef("Handling #sessionFactoryClosed from [%s] for TypeConfiguration", factory);
        this.scope.unsetSessionFactory(factory);
    }

    public void addBasicTypeRegistrationContributions(List<BasicTypeRegistration> contributions) {
        for (BasicTypeRegistration basicTypeRegistration : contributions) {
            BasicType<?> basicType = basicTypeRegistration.getBasicType();
            this.basicTypeRegistry.register(basicType, basicTypeRegistration.getRegistrationKeys());
            this.javaTypeRegistry.resolveDescriptor(basicType.getJavaType(), basicType::getJavaTypeDescriptor);
            this.jdbcToHibernateTypeContributionMap.computeIfAbsent(basicType.getJdbcType().getDefaultSqlTypeCode(), k -> new HashSet()).add(basicType.getName());
        }
    }

    public BasicType<?> resolveCastTargetType(String name) {
        switch (name.toLowerCase()) {
            case "string": {
                return this.getBasicTypeForJavaType(String.class);
            }
            case "character": {
                return this.getBasicTypeForJavaType(Character.class);
            }
            case "byte": {
                return this.getBasicTypeForJavaType(Byte.class);
            }
            case "short": {
                return this.getBasicTypeForJavaType(Short.class);
            }
            case "integer": {
                return this.getBasicTypeForJavaType(Integer.class);
            }
            case "long": {
                return this.getBasicTypeForJavaType(Long.class);
            }
            case "float": {
                return this.getBasicTypeForJavaType(Float.class);
            }
            case "double": {
                return this.getBasicTypeForJavaType(Double.class);
            }
            case "time": {
                return this.getBasicTypeForJavaType(Time.class);
            }
            case "date": {
                return this.getBasicTypeForJavaType(Date.class);
            }
            case "timestamp": {
                return this.getBasicTypeForJavaType(Timestamp.class);
            }
            case "localtime": {
                return this.getBasicTypeForJavaType(LocalTime.class);
            }
            case "localdate": {
                return this.getBasicTypeForJavaType(LocalDate.class);
            }
            case "localdatetime": {
                return this.getBasicTypeForJavaType(LocalDateTime.class);
            }
            case "offsetdatetime": {
                return this.getBasicTypeForJavaType(OffsetDateTime.class);
            }
            case "zoneddatetime": {
                return this.getBasicTypeForJavaType(ZonedDateTime.class);
            }
            case "biginteger": {
                return this.getBasicTypeForJavaType(BigInteger.class);
            }
            case "bigdecimal": {
                return this.getBasicTypeForJavaType(BigDecimal.class);
            }
            case "duration": {
                return this.getBasicTypeForJavaType(Duration.class);
            }
            case "instant": {
                return this.getBasicTypeForJavaType(Instant.class);
            }
            case "binary": {
                return this.getBasicTypeForJavaType(byte[].class);
            }
            case "boolean": {
                return this.getBasicTypeForJavaType(Boolean.class);
            }
            case "truefalse": {
                return this.basicTypeRegistry.getRegisteredType(StandardBasicTypes.TRUE_FALSE.getName());
            }
            case "yesno": {
                return this.basicTypeRegistry.getRegisteredType(StandardBasicTypes.YES_NO.getName());
            }
            case "numericboolean": {
                return this.basicTypeRegistry.getRegisteredType(StandardBasicTypes.NUMERIC_BOOLEAN.getName());
            }
            case "json": {
                return this.basicTypeRegistry.resolve(Object.class, 3001);
            }
            case "xml": {
                return this.basicTypeRegistry.resolve(Object.class, 2009);
            }
        }
        BasicType registeredBasicType = this.basicTypeRegistry.getRegisteredType(name);
        if (registeredBasicType != null) {
            return registeredBasicType;
        }
        try {
            Class javaTypeClass = this.scope.getClassLoaderService().classForName(name);
            JavaType jtd = this.javaTypeRegistry.resolveDescriptor(javaTypeClass);
            JdbcType jdbcType = jtd.getRecommendedJdbcType(this.getCurrentBaseSqlTypeIndicators());
            return this.basicTypeRegistry.resolve(jtd, jdbcType);
        }
        catch (Exception exception) {
            throw new HibernateException("unrecognized cast target type: " + name);
        }
    }

    public SqmBindableType<?> resolveTupleType(List<? extends SqmTypedNode<?>> typedNodes) {
        SqmBindableType[] components = new SqmBindableType[typedNodes.size()];
        for (int i = 0; i < typedNodes.size(); ++i) {
            SqmTypedNode<?> tupleElement = typedNodes.get(i);
            SqmBindableType<?> sqmExpressible = tupleElement.getNodeType();
            components[i] = tupleElement instanceof SqmParameter && sqmExpressible == null ? QueryParameterJavaObjectType.INSTANCE : (sqmExpressible != null ? sqmExpressible : this.getBasicTypeForJavaType(Object.class));
        }
        return this.arrayTuples.computeIfAbsent(new ArrayCacheKey(components), key -> new ArrayTupleType(key.components));
    }

    public SqmExpressible<?> resolveArithmeticType(SqmExpressible<?> firstType, SqmExpressible<?> secondType, BinaryArithmeticOperator operator) {
        return this.resolveArithmeticType(firstType, secondType);
    }

    public SqmExpressible<?> resolveArithmeticType(SqmExpressible<?> firstType, SqmExpressible<?> secondType) {
        if (this.getSqlTemporalType(firstType) != null) {
            if (secondType == null || this.getSqlTemporalType(secondType) != null) {
                return this.getBasicTypeRegistry().getRegisteredType(Duration.class);
            }
            return firstType;
        }
        if (TypeConfiguration.isDuration(secondType)) {
            return firstType == null ? null : secondType;
        }
        if (firstType == null && this.getSqlTemporalType(secondType) != null) {
            return this.getBasicTypeRegistry().getRegisteredType(Duration.class);
        }
        if (firstType != null && (secondType == null || firstType.getRelationalJavaType().isWider(secondType.getRelationalJavaType()))) {
            return this.resolveBasicArithmeticType(firstType);
        }
        return secondType != null ? this.resolveBasicArithmeticType(secondType) : null;
    }

    private BasicType<?> resolveBasicArithmeticType(SqmExpressible<?> expressible) {
        if (TypecheckUtil.isNumberArray(expressible)) {
            return (BasicType)expressible.getSqmType();
        }
        return this.getBasicTypeForJavaType(expressible.getRelationalJavaType().getJavaTypeClass());
    }

    private static boolean matchesJavaType(SqmExpressible<?> type, Class<?> javaType) {
        assert (javaType != null);
        return type != null && javaType.isAssignableFrom(type.getRelationalJavaType().getJavaTypeClass());
    }

    public <J> BasicType<J> getBasicTypeForGenericJavaType(Class<? super J> javaType, Type ... typeArguments) {
        return this.getBasicTypeForJavaType(new ParameterizedTypeImpl(javaType, typeArguments, null));
    }

    public <J> BasicType<J> getBasicTypeForJavaType(Class<J> javaType) {
        return this.getBasicTypeForJavaType((Type)javaType);
    }

    public <J> BasicType<J> getBasicTypeForJavaType(Type javaType) {
        BasicType<?> existing = this.basicTypeByJavaType.get(javaType);
        if (existing != null) {
            return existing;
        }
        BasicType registeredType = this.basicTypeRegistry.getRegisteredType(javaType);
        if (registeredType != null) {
            this.basicTypeByJavaType.put(javaType, registeredType);
            return registeredType;
        }
        return null;
    }

    public <J> BasicType<J> standardBasicTypeForJavaType(Class<J> javaType) {
        if (javaType == null) {
            return null;
        }
        return this.standardBasicTypeForJavaType(javaType, (JavaType<J> javaTypeDescriptor) -> new BasicTypeImpl(javaTypeDescriptor, javaTypeDescriptor.getRecommendedJdbcType(this.getCurrentBaseSqlTypeIndicators())));
    }

    public BasicType<?> standardBasicTypeForJavaType(Type javaType) {
        if (javaType == null) {
            return null;
        }
        return this.standardBasicTypeForJavaType(javaType, (JavaType<J> javaTypeDescriptor) -> new BasicTypeImpl(javaTypeDescriptor, javaTypeDescriptor.getRecommendedJdbcType(this.getCurrentBaseSqlTypeIndicators())));
    }

    public <J> BasicType<J> standardBasicTypeForJavaType(Class<J> javaType, Function<JavaType<J>, BasicType<J>> creator) {
        return this.standardBasicTypeForJavaType((Type)javaType, creator);
    }

    public <J> BasicType<J> standardBasicTypeForJavaType(Type javaType, Function<JavaType<J>, BasicType<J>> creator) {
        if (javaType == null) {
            return null;
        }
        return this.basicTypeByJavaType.computeIfAbsent(javaType, jt -> {
            BasicType registeredType = this.basicTypeRegistry.getRegisteredType(javaType);
            if (registeredType != null) {
                return registeredType;
            }
            return (BasicType)creator.apply(this.javaTypeRegistry.resolveDescriptor(javaType));
        });
    }

    public TemporalType getSqlTemporalType(SqmExpressible<?> type) {
        return type == null ? null : TypeConfiguration.getSqlTemporalType(type.getRelationalJavaType().getRecommendedJdbcType(this.getCurrentBaseSqlTypeIndicators()));
    }

    public static TemporalType getSqlTemporalType(JdbcMapping jdbcMapping) {
        return TypeConfiguration.getSqlTemporalType(jdbcMapping.getJdbcType());
    }

    public static TemporalType getSqlTemporalType(JdbcMappingContainer jdbcMappings) {
        assert (jdbcMappings.getJdbcTypeCount() == 1);
        return TypeConfiguration.getSqlTemporalType(jdbcMappings.getSingleJdbcMapping().getJdbcType());
    }

    public static TemporalType getSqlTemporalType(MappingModelExpressible<?> type) {
        if (type instanceof BasicValuedMapping) {
            BasicValuedMapping basicValuedMapping = (BasicValuedMapping)type;
            return TypeConfiguration.getSqlTemporalType(basicValuedMapping.getJdbcMapping().getJdbcType());
        }
        if (type instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)type;
            Class<?> javaTypeClass = embeddableValuedModelPart.getJavaType().getJavaTypeClass();
            if (javaTypeClass == OffsetDateTime.class || javaTypeClass == ZonedDateTime.class) {
                return TemporalType.TIMESTAMP;
            }
            if (javaTypeClass == OffsetTime.class) {
                return TemporalType.TIME;
            }
            return null;
        }
        return null;
    }

    public static TemporalType getSqlTemporalType(JdbcType descriptor) {
        return TypeConfiguration.getSqlTemporalType(descriptor.getDefaultSqlTypeCode());
    }

    protected static TemporalType getSqlTemporalType(int jdbcTypeCode) {
        return switch (jdbcTypeCode) {
            case 93, 2014, 3003 -> TemporalType.TIMESTAMP;
            case 92, 2013, 3007 -> TemporalType.TIME;
            case 91 -> TemporalType.DATE;
            default -> null;
        };
    }

    public static IntervalType getSqlIntervalType(JdbcMappingContainer jdbcMappings) {
        assert (jdbcMappings.getJdbcTypeCount() == 1);
        return TypeConfiguration.getSqlIntervalType(jdbcMappings.getSingleJdbcMapping().getJdbcType());
    }

    public static IntervalType getSqlIntervalType(JdbcType descriptor) {
        return TypeConfiguration.getSqlIntervalType(descriptor.getDefaultSqlTypeCode());
    }

    protected static IntervalType getSqlIntervalType(int jdbcTypeCode) {
        return jdbcTypeCode == 3100 ? IntervalType.SECOND : null;
    }

    public static boolean isJdbcTemporalType(SqmExpressible<?> type) {
        return TypeConfiguration.matchesJavaType(type, java.util.Date.class);
    }

    public static boolean isDuration(SqmExpressible<?> type) {
        return TypeConfiguration.matchesJavaType(type, Duration.class);
    }

    @Internal
    public <J> MutabilityPlan<J> createMutabilityPlan(Class<? extends MutabilityPlan<?>> planClass) {
        return !this.scope.allowExtensionsInCdi ? FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(planClass) : this.scope.getManagedBeanRegistry().getBean(planClass).getBeanInstance();
    }

    @Internal
    @Incubating
    public final FormatMapper getJsonFormatMapper() {
        return this.getSessionFactory().getSessionFactoryOptions().getJsonFormatMapper();
    }

    @Internal
    @Incubating
    public final FormatMapper getXmlFormatMapper() {
        return this.getSessionFactory().getSessionFactoryOptions().getXmlFormatMapper();
    }

    private static class Scope
    implements JdbcTypeIndicators,
    Serializable {
        private final TypeConfiguration typeConfiguration;
        private transient MetadataBuildingContext metadataBuildingContext;
        private transient SessionFactoryImplementor sessionFactory;
        private boolean allowExtensionsInCdi;
        private String sessionFactoryName;
        private String sessionFactoryUuid;

        @Override
        public TypeConfiguration getTypeConfiguration() {
            return this.typeConfiguration;
        }

        @Override
        public boolean isPreferJavaTimeJdbcTypesEnabled() {
            return this.sessionFactory == null ? this.metadataBuildingContext.isPreferJavaTimeJdbcTypesEnabled() : this.sessionFactory.getSessionFactoryOptions().isPreferJavaTimeJdbcTypesEnabled();
        }

        @Override
        public boolean isPreferNativeEnumTypesEnabled() {
            return this.sessionFactory == null ? this.metadataBuildingContext.isPreferNativeEnumTypesEnabled() : this.sessionFactory.getSessionFactoryOptions().isPreferNativeEnumTypesEnabled();
        }

        @Override
        public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
            return this.sessionFactory == null ? this.metadataBuildingContext.getBuildingOptions().getDefaultTimeZoneStorage() : this.sessionFactory.getSessionFactoryOptions().getDefaultTimeZoneStorageStrategy();
        }

        @Override
        public int getPreferredSqlTypeCodeForBoolean() {
            return this.sessionFactory == null ? this.metadataBuildingContext.getPreferredSqlTypeCodeForBoolean() : this.sessionFactory.getSessionFactoryOptions().getPreferredSqlTypeCodeForBoolean();
        }

        @Override
        public int getPreferredSqlTypeCodeForDuration() {
            return this.sessionFactory == null ? this.metadataBuildingContext.getPreferredSqlTypeCodeForDuration() : this.sessionFactory.getSessionFactoryOptions().getPreferredSqlTypeCodeForDuration();
        }

        @Override
        public int getPreferredSqlTypeCodeForUuid() {
            return this.sessionFactory == null ? this.metadataBuildingContext.getPreferredSqlTypeCodeForUuid() : this.sessionFactory.getSessionFactoryOptions().getPreferredSqlTypeCodeForUuid();
        }

        @Override
        public int getPreferredSqlTypeCodeForInstant() {
            return this.sessionFactory == null ? this.metadataBuildingContext.getPreferredSqlTypeCodeForInstant() : this.sessionFactory.getSessionFactoryOptions().getPreferredSqlTypeCodeForInstant();
        }

        @Override
        public int getPreferredSqlTypeCodeForArray() {
            return this.sessionFactory == null ? this.metadataBuildingContext.getPreferredSqlTypeCodeForArray() : this.sessionFactory.getSessionFactoryOptions().getPreferredSqlTypeCodeForArray();
        }

        @Override
        public Dialect getDialect() {
            return this.sessionFactory == null ? this.metadataBuildingContext.getMetadataCollector().getDatabase().getDialect() : this.sessionFactory.getJdbcServices().getDialect();
        }

        @Override
        public boolean preferJdbcDatetimeTypes() {
            return this.sessionFactory != null && this.sessionFactory.getSessionFactoryOptions().isPreferJdbcDatetimeTypesInNativeQueriesEnabled();
        }

        @Override
        public boolean isXmlFormatMapperLegacyFormatEnabled() {
            if (this.metadataBuildingContext != null) {
                return this.metadataBuildingContext.getBuildingOptions().isXmlFormatMapperLegacyFormatEnabled();
            }
            if (this.sessionFactory != null) {
                return this.sessionFactory.getSessionFactoryOptions().isXmlFormatMapperLegacyFormatEnabled();
            }
            return false;
        }

        public ClassLoaderService getClassLoaderService() {
            return this.sessionFactory == null ? this.metadataBuildingContext.getBootstrapContext().getClassLoaderService() : this.sessionFactory.getClassLoaderService();
        }

        public ManagedBeanRegistry getManagedBeanRegistry() {
            return this.sessionFactory == null ? this.metadataBuildingContext.getBootstrapContext().getManagedBeanRegistry() : this.sessionFactory.getManagedBeanRegistry();
        }

        private Scope(TypeConfiguration typeConfiguration) {
            this.typeConfiguration = typeConfiguration;
        }

        private MetadataBuildingContext getMetadataBuildingContext() {
            if (this.metadataBuildingContext == null) {
                throw new HibernateException("TypeConfiguration is not currently scoped to MetadataBuildingContext");
            }
            return this.metadataBuildingContext;
        }

        private ServiceRegistry getServiceRegistry() {
            if (this.metadataBuildingContext != null) {
                return this.metadataBuildingContext.getBootstrapContext().getServiceRegistry();
            }
            if (this.sessionFactory != null) {
                return this.sessionFactory.getServiceRegistry();
            }
            throw new AssertionFailure("No service registry available");
        }

        private JpaCompliance getJpaCompliance() {
            if (this.metadataBuildingContext != null) {
                return this.metadataBuildingContext.getBootstrapContext().getJpaCompliance();
            }
            if (this.sessionFactory != null) {
                return this.sessionFactory.getSessionFactoryOptions().getJpaCompliance();
            }
            return null;
        }

        private void setMetadataBuildingContext(MetadataBuildingContext context) {
            this.metadataBuildingContext = context;
            if (context != null) {
                this.allowExtensionsInCdi = context.getBuildingOptions().isAllowExtensionsInCdi();
            }
        }

        private SessionFactoryImplementor getSessionFactory() {
            if (this.sessionFactory == null) {
                if (this.sessionFactoryName == null && this.sessionFactoryUuid == null) {
                    throw new HibernateException("TypeConfiguration was not yet scoped to SessionFactory");
                }
                this.sessionFactory = SessionFactoryRegistry.INSTANCE.findSessionFactory(this.sessionFactoryUuid, this.sessionFactoryName);
                if (this.sessionFactory == null) {
                    throw new HibernateException("Could not find a SessionFactory [uuid=" + this.sessionFactoryUuid + ",name=" + this.sessionFactoryName + "]");
                }
            }
            return this.sessionFactory;
        }

        private void setSessionFactory(SessionFactoryImplementor factory) {
            if (this.sessionFactory != null) {
                log.scopingTypesToSessionFactoryAfterAlreadyScoped(this.sessionFactory, factory);
            } else {
                this.sessionFactoryUuid = factory.getUuid();
                this.sessionFactoryName = Scope.getFactoryName(factory);
            }
            this.sessionFactory = factory;
        }

        private static String getFactoryName(SessionFactoryImplementor factory) {
            String factoryName = factory.getSessionFactoryOptions().getSessionFactoryName();
            if (factoryName == null) {
                CfgXmlAccessService cfgXmlAccessService = factory.getServiceRegistry().requireService(CfgXmlAccessService.class);
                return cfgXmlAccessService.getAggregatedConfig() == null ? null : cfgXmlAccessService.getAggregatedConfig().getSessionFactoryName();
            }
            return factoryName;
        }

        private void unsetSessionFactory(SessionFactory factory) {
            log.debugf("Un-scoping TypeConfiguration [%s] from SessionFactory [%s]", this, factory);
            this.sessionFactory = null;
        }

        private Object readResolve() throws InvalidObjectException {
            if (this.sessionFactory == null && (this.sessionFactoryName != null || this.sessionFactoryUuid != null)) {
                this.sessionFactory = SessionFactoryRegistry.INSTANCE.findSessionFactory(this.sessionFactoryUuid, this.sessionFactoryName);
                if (this.sessionFactory == null) {
                    throw new HibernateException("Could not find a SessionFactory [uuid=" + this.sessionFactoryUuid + ",name=" + this.sessionFactoryName + "]");
                }
            }
            return this;
        }

        private Class<?> entityClassForEntityName(String entityName) {
            return this.sessionFactory == null ? this.metadataBuildingContext.getMetadataCollector().getEntityBinding(entityName).getMappedClass() : this.sessionFactory.getMappingMetamodel().findEntityDescriptor(entityName).getMappedClass();
        }
    }

    private static class ArrayCacheKey {
        final SqmBindableType<?>[] components;

        public ArrayCacheKey(SqmBindableType<?>[] components) {
            this.components = components;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof ArrayCacheKey)) return false;
            ArrayCacheKey key = (ArrayCacheKey)object;
            if (!Arrays.equals(this.components, key.components)) return false;
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.components);
        }
    }
}

