/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.UndertowOptions;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.SinglePortConfidentialityHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.cache.CacheHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.management.HttpInterfaceCommonPolicy;
import org.jboss.as.domain.http.server.ConsoleAvailability;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.CorrelationHandler;
import org.jboss.as.domain.http.server.DomainApiCheckHandler;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.ErrorContextHandler;
import org.jboss.as.domain.http.server.InExecutorHandler;
import org.jboss.as.domain.http.server.ManagementHttpRequestHandler;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.domain.http.server.ManagementRootConsoleRedirectHandler;
import org.jboss.as.domain.http.server.ResourceHandlerDefinition;
import org.jboss.as.domain.http.server.StaticHeadersHandler;
import org.jboss.as.domain.http.server.StreamReadLimitHandler;
import org.jboss.as.domain.http.server.cors.CorsHttpHandler;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.domain.http.server.security.DmrFailureReadinessHandler;
import org.jboss.as.domain.http.server.security.ElytronIdentityHandler;
import org.jboss.as.domain.http.server.security.LogoutHandler;
import org.jboss.as.domain.http.server.security.RedirectReadinessHandler;
import org.jboss.as.domain.http.server.security.ServerErrorReadinessHandler;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.ssl.SslConnection;

public class ManagementHttpServer {
    private static final String DEFAULT_SECURITY_REALM = "ManagementRealm";
    private static final Set<String> RESERVED_CONTEXTS;
    private final HttpOpenListener openListener;
    private final InetSocketAddress httpAddress;
    private final InetSocketAddress secureAddress;
    private final XnioWorker worker;
    private volatile AcceptingChannel<StreamConnection> normalServer;
    private volatile AcceptingChannel<SslConnection> secureServer;
    private final SSLContext sslContext;
    private final SslClientAuthMode sslClientAuthMode;
    private final HttpAuthenticationFactory httpAuthenticationFactory;
    private final ExtensionHandlers extensionHandlers;
    private final Executor managementExecutor;
    private final Integer backlog;
    private final Integer connectionHighWater;
    private final Integer connectionLowWater;
    private static final ByteBufferSlicePool bufferPool;
    private static Function<HttpServerExchange, Boolean> ALWAYS_READY;

    private ManagementHttpServer(HttpOpenListener openListener, Builder builder, SSLContext sslContext, SslClientAuthMode sslClientAuthMode, ExtensionHandlers extensionExtensionHandlers) {
        this.openListener = openListener;
        this.httpAddress = builder.bindAddress;
        this.secureAddress = builder.secureBindAddress;
        this.sslContext = sslContext;
        this.sslClientAuthMode = sslClientAuthMode;
        this.worker = builder.worker;
        this.httpAuthenticationFactory = builder.httpAuthenticationFactory;
        this.extensionHandlers = extensionExtensionHandlers;
        this.managementExecutor = builder.executor;
        this.backlog = builder.backlog;
        this.connectionHighWater = builder.connectionHighWater;
        this.connectionLowWater = builder.connectionLowWater;
    }

    public void start() {
        try {
            OptionMap.Builder serverOptionsBuilder = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true);
            if (this.backlog != null) {
                serverOptionsBuilder.set(Options.BACKLOG, (Object)this.backlog);
            }
            if (this.connectionHighWater != null) {
                serverOptionsBuilder.set(Options.CONNECTION_HIGH_WATER, (Object)this.connectionHighWater);
            }
            if (this.connectionLowWater != null) {
                serverOptionsBuilder.set(Options.CONNECTION_LOW_WATER, (Object)this.connectionLowWater);
            }
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            if (this.httpAddress != null) {
                this.normalServer = this.worker.createStreamConnectionServer((SocketAddress)this.httpAddress, acceptListener, serverOptionsBuilder.getMap());
                this.normalServer.resumeAccepts();
            }
            if (this.secureAddress != null) {
                if (this.sslClientAuthMode != null) {
                    serverOptionsBuilder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)this.sslClientAuthMode);
                }
                OptionMap secureOptions = serverOptionsBuilder.getMap();
                UndertowXnioSsl xnioSsl = new UndertowXnioSsl(this.worker.getXnio(), secureOptions, this.sslContext);
                this.secureServer = xnioSsl.createSslConnectionServer(this.worker, this.secureAddress, acceptListener, secureOptions);
                this.secureServer.resumeAccepts();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        IoUtils.safeClose(this.normalServer);
        IoUtils.safeClose(this.secureServer);
    }

    public synchronized void addStaticContext(String contextName, ResourceManager resourceManager) {
        Assert.checkNotNullParam((String)"contextName", (Object)contextName);
        Assert.checkNotNullParam((String)"resourceManager", (Object)resourceManager);
        String context = ManagementHttpServer.fixPath(contextName);
        if (this.extensionHandlers.reservedContexts.contains(context) || !this.extensionHandlers.extensionContexts.add(context)) {
            throw new IllegalStateException();
        }
        ResourceHandlerDefinition def = DomainUtil.createStaticContentHandler(resourceManager, context);
        RedirectReadinessHandler readinessHandler = new RedirectReadinessHandler(this.extensionHandlers.readyFunction, def.getHandler(), "/error");
        this.extensionHandlers.extensionPathHandler.addPrefixPath(context, (HttpHandler)readinessHandler);
    }

    public synchronized void addManagementHandler(String contextName, boolean requireSecurity, HttpHandler managementHandler) {
        Function<HttpServerExchange, Boolean> readyFunction;
        Assert.checkNotNullParam((String)"contextName", (Object)contextName);
        Assert.checkNotNullParam((String)"managementHandler", (Object)managementHandler);
        String context = ManagementHttpServer.fixPath(contextName);
        if (this.extensionHandlers.reservedContexts.contains(context) || !this.extensionHandlers.extensionContexts.add(context)) {
            throw new IllegalStateException();
        }
        if (requireSecurity) {
            readyFunction = this.extensionHandlers.readyFunction;
            managementHandler = ManagementHttpServer.secureDomainAccess(ManagementHttpServer.associateIdentity(managementHandler), this.httpAuthenticationFactory);
        } else {
            readyFunction = ALWAYS_READY;
        }
        ServerErrorReadinessHandler readinessHandler = new ServerErrorReadinessHandler(contextName, readyFunction, managementHandler);
        this.extensionHandlers.extensionPathHandler.addPrefixPath(context, (HttpHandler)readinessHandler);
    }

    public synchronized void addManagementGetRemapContext(String contextName, PathRemapper remapper) {
        Assert.checkNotNullParam((String)"contextName", (Object)contextName);
        String context = ManagementHttpServer.fixPath(contextName);
        if (this.extensionHandlers.reservedContexts.contains(context) || !this.extensionHandlers.extensionContexts.add(context)) {
            throw new IllegalStateException();
        }
        RemapHandler remapHandler = new RemapHandler(remapper, this.extensionHandlers.managementHandler);
        this.extensionHandlers.extensionPathHandler.addPrefixPath(context, (HttpHandler)remapHandler);
    }

    public synchronized void removeContext(String contextName) {
        Assert.checkNotNullParam((String)"contextName", (Object)contextName);
        String context = ManagementHttpServer.fixPath(contextName);
        if (this.extensionHandlers.reservedContexts.contains(context) || !this.extensionHandlers.extensionContexts.contains(context)) {
            throw new IllegalStateException();
        }
        this.extensionHandlers.extensionContexts.remove(context);
        this.extensionHandlers.extensionPathHandler.removePrefixPath(context);
    }

    private static String fixPath(String contextName) {
        Assert.checkNotEmptyParam((String)"contextName", (String)contextName);
        return '/' == contextName.charAt(0) ? contextName : "/" + contextName;
    }

    private static SSLContext getSSLContext(Builder builder) {
        if (builder.sslContext != null) {
            return builder.sslContext;
        }
        throw HttpServerLogger.ROOT_LOGGER.noRealmOrSSLContext();
    }

    private static ManagementHttpServer create(Builder builder) {
        boolean redirectSupported;
        SSLContext sslContext = null;
        SslClientAuthMode sslClientAuthMode = builder.sslClientAuthMode;
        if (builder.secureBindAddress != null && (sslContext = ManagementHttpServer.getSSLContext(builder)) == null) {
            throw HttpServerLogger.ROOT_LOGGER.sslRequestedNoSslContext();
        }
        HttpServerLogger.ROOT_LOGGER.debugf("HTTP Management API Connection Constraints - backlog=%d, noRequestTimeout=%d, connectionHighWater=%d, connectionLowWater=%d", new Object[]{builder.backlog, builder.noRequestTimeout, builder.connectionHighWater, builder.connectionLowWater});
        OptionMap undertowOptions = builder.noRequestTimeout != null ? OptionMap.create((Option)UndertowOptions.NO_REQUEST_TIMEOUT, (Object)builder.noRequestTimeout) : OptionMap.EMPTY;
        HttpOpenListener openListener = new HttpOpenListener((Pool)bufferPool, undertowOptions);
        int secureRedirectPort = builder.secureBindAddress != null ? builder.secureBindAddress.getPort() : -1;
        boolean bl = redirectSupported = builder.bindAddress == null || builder.secureBindAddress == null || builder.bindAddress.getAddress().equals(builder.secureBindAddress.getAddress());
        if (!redirectSupported && secureRedirectPort > 0) {
            HttpServerLogger.ROOT_LOGGER.httpsRedirectNotSupported(builder.bindAddress.getAddress(), builder.secureBindAddress.getAddress());
            secureRedirectPort = -1;
        }
        ExtensionHandlers extensionHandlers = ManagementHttpServer.setupOpenListener(openListener, secureRedirectPort, builder);
        return new ManagementHttpServer(openListener, builder, sslContext, sslClientAuthMode, extensionHandlers);
    }

    private static Function<HttpServerExchange, Boolean> createReadyFunction(Builder builder) {
        return e -> Boolean.TRUE;
    }

    private static void addRedirectRedinessHandler(PathHandler pathHandler, ResourceHandlerDefinition consoleHandler, Function<HttpServerExchange, Boolean> readyFunction) {
        RedirectReadinessHandler readinessHandler = new RedirectReadinessHandler(readyFunction, consoleHandler.getHandler(), "/error");
        pathHandler.addPrefixPath(consoleHandler.getContext(), (HttpHandler)readinessHandler);
    }

    private static HttpHandler addDmrRedinessHandler(PathHandler pathHandler, HttpHandler domainApiHandler, Function<HttpServerExchange, Boolean> readinessFunction) {
        HttpHandler readinessHandler = ManagementHttpServer.wrapHttpHeader(ManagementHttpServer.wrapHttpHeader(new DmrFailureReadinessHandler(readinessFunction, domainApiHandler, "/error"), "X-Frame-Options", "SAMEORIGIN"), "X-Content-Type-Options", "nosniff");
        pathHandler.addPrefixPath("/management", readinessHandler);
        pathHandler.addExactPath("/management-upload", readinessHandler);
        return readinessHandler;
    }

    private static void addLogoutHandler(PathHandler pathHandler, Builder builder) {
        pathHandler.addPrefixPath("/logout", ManagementHttpServer.wrapHttpHeader(ManagementHttpServer.wrapHttpHeader(new LogoutHandler(DEFAULT_SECURITY_REALM), "X-Frame-Options", "SAMEORIGIN"), "X-Content-Type-Options", "nosniff"));
    }

    private static void addErrorContextHandler(PathHandler pathHandler, Builder builder) throws ModuleLoadException {
        HttpHandler errorContextHandler = ManagementHttpServer.wrapHttpHeader(ManagementHttpServer.wrapHttpHeader(ErrorContextHandler.createErrorContext(builder.consoleSlot), "X-Frame-Options", "SAMEORIGIN"), "X-Content-Type-Options", "nosniff");
        pathHandler.addPrefixPath("/error", errorContextHandler);
    }

    private static ExtensionHandlers setupOpenListener(HttpOpenListener listener, int secureRedirectPort, Builder builder) {
        PathHandler pathHandler;
        CanonicalPathHandler canonicalPathHandler = new CanonicalPathHandler();
        ManagementHttpRequestHandler managementHttpRequestHandler = new ManagementHttpRequestHandler(builder.managementHttpRequestProcessor, (HttpHandler)canonicalPathHandler);
        CorsHttpHandler corsHandler = new CorsHttpHandler(managementHttpRequestHandler, builder.allowedOrigins);
        listener.setRootHandler((HttpHandler)new UpgradeFixHandler(corsHandler));
        Object current = pathHandler = new PathHandler();
        Map<String, List<HttpInterfaceCommonPolicy.Header>> constantHeaders = builder.constantHeaders;
        if (constantHeaders != null) {
            StaticHeadersHandler headerHandler = new StaticHeadersHandler((HttpHandler)current);
            for (Map.Entry<String, List<HttpInterfaceCommonPolicy.Header>> entry : constantHeaders.entrySet()) {
                for (HttpInterfaceCommonPolicy.Header header : entry.getValue()) {
                    headerHandler.addHeader(entry.getKey(), header.getName(), header.getValue());
                }
            }
            current = headerHandler;
        }
        if (builder.upgradeHandler != null) {
            builder.upgradeHandler.setNonUpgradeHandler((HttpHandler)current);
            current = builder.upgradeHandler;
        }
        if (secureRedirectPort > 0) {
            current = new SinglePortConfidentialityHandler((HttpHandler)current, secureRedirectPort);
        }
        current = new CacheHandler(new DirectBufferCache(1024, 10240, 1024000, BufferAllocator.BYTE_BUFFER_ALLOCATOR), (HttpHandler)current);
        current = new SimpleErrorPageHandler((HttpHandler)current);
        canonicalPathHandler.setNext((HttpHandler)current);
        ResourceHandlerDefinition consoleHandler = null;
        try {
            consoleHandler = builder.consoleMode.createConsoleHandler(builder.consoleSlot);
        }
        catch (ModuleLoadException e) {
            HttpServerLogger.ROOT_LOGGER.consoleModuleNotFound(builder.consoleSlot == null ? "main" : builder.consoleSlot);
        }
        if (builder.consoleMode != ConsoleMode.NO_CONSOLE) {
            try {
                ManagementHttpServer.addErrorContextHandler(pathHandler, builder);
            }
            catch (ModuleLoadException e) {
                HttpServerLogger.ROOT_LOGGER.errorContextModuleNotFound(builder.consoleSlot == null ? "main" : builder.consoleSlot);
            }
        }
        ManagementRootConsoleRedirectHandler rootConsoleRedirectHandler = new ManagementRootConsoleRedirectHandler(consoleHandler);
        HttpHandler domainApiHandler = StreamReadLimitHandler.wrap(CorrelationHandler.wrap(InExecutorHandler.wrap(builder.executor, ManagementHttpServer.associateIdentity(new DomainApiCheckHandler(builder.modelController, builder.allowedOrigins, builder.consoleAvailability)))));
        Function<HttpServerExchange, Boolean> readyFunction = ManagementHttpServer.createReadyFunction(builder);
        pathHandler.addPrefixPath("/", (HttpHandler)rootConsoleRedirectHandler);
        if (consoleHandler != null) {
            ManagementHttpServer.addRedirectRedinessHandler(pathHandler, consoleHandler, readyFunction);
        }
        domainApiHandler = ManagementHttpServer.secureDomainAccess(domainApiHandler, builder);
        HttpHandler readinessHandler = ManagementHttpServer.addDmrRedinessHandler(pathHandler, domainApiHandler, readyFunction);
        ManagementHttpServer.addLogoutHandler(pathHandler, builder);
        return new ExtensionHandlers(pathHandler, readinessHandler, readyFunction, consoleHandler);
    }

    private static HttpHandler associateIdentity(HttpHandler domainHandler) {
        domainHandler = new ElytronIdentityHandler(domainHandler);
        return new BlockingHandler(domainHandler);
    }

    private static HttpHandler secureDomainAccess(HttpHandler domainHandler, Builder builder) {
        return ManagementHttpServer.secureDomainAccess(domainHandler, builder.httpAuthenticationFactory);
    }

    private static HttpHandler secureDomainAccess(HttpHandler domainHandler, HttpAuthenticationFactory httpAuthenticationFactory) {
        if (httpAuthenticationFactory != null) {
            return ManagementHttpServer.secureDomainAccessElytron(domainHandler, httpAuthenticationFactory);
        }
        return domainHandler;
    }

    private static HttpHandler secureDomainAccessElytron(HttpHandler domainHandler, HttpAuthenticationFactory httpAuthenticationFactory) {
        domainHandler = new AuthenticationCallHandler(domainHandler);
        domainHandler = new AuthenticationConstraintHandler(domainHandler);
        Supplier<List> mechanismSupplier = () -> httpAuthenticationFactory.getMechanismNames().stream().map(s -> {
            try {
                return (HttpServerAuthenticationMechanism)httpAuthenticationFactory.createMechanism(s);
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.toList());
        domainHandler = ElytronContextAssociationHandler.builder().setNext(domainHandler).setMechanismSupplier(mechanismSupplier).setHttpExchangeSupplier(h -> new ElytronHttpExchange((HttpServerExchange)h, (HttpServerExchange)h){
            final /* synthetic */ HttpServerExchange val$h;
            {
                this.val$h = httpServerExchange2;
                super(httpServerExchange);
            }

            public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
                super.authenticationComplete(securityIdentity, mechanismName);
                this.val$h.putAttachment(ElytronIdentityHandler.IDENTITY_KEY, (Object)securityIdentity);
            }
        }).build();
        return domainHandler;
    }

    private static HttpHandler wrapHttpHeader(HttpHandler toWrap, String header, String value) {
        return new SetHeaderHandler(toWrap, header, value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public SocketAddress getLocalAddress() {
        return this.normalServer.getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.normalServer.getLocalAddress(type);
    }

    public SocketAddress getSecureLocalAddress() {
        return this.secureServer.getLocalAddress();
    }

    public <A extends SocketAddress> A getSecureLocalAddress(Class<A> type) {
        return (A)this.secureServer.getLocalAddress(type);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("/management");
        set.add("/management-upload");
        set.add("/logout");
        set.add("/error");
        RESERVED_CONTEXTS = Collections.unmodifiableSet(set);
        bufferPool = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 4096, 40960);
        ALWAYS_READY = new Function<HttpServerExchange, Boolean>(){

            @Override
            public Boolean apply(HttpServerExchange httpServerExchange) {
                return true;
            }
        };
    }

    public static class Builder {
        private boolean built = false;
        private InetSocketAddress bindAddress;
        private InetSocketAddress secureBindAddress;
        private ModelController modelController;
        private SSLContext sslContext;
        private SslClientAuthMode sslClientAuthMode;
        private HttpAuthenticationFactory httpAuthenticationFactory;
        private ConsoleMode consoleMode;
        private String consoleSlot;
        private ChannelUpgradeHandler upgradeHandler;
        private ManagementHttpRequestProcessor managementHttpRequestProcessor;
        private Collection<String> allowedOrigins;
        private XnioWorker worker;
        private Executor executor;
        private Map<String, List<HttpInterfaceCommonPolicy.Header>> constantHeaders;
        private ConsoleAvailability consoleAvailability;
        private Integer backlog;
        private Integer connectionHighWater;
        private Integer connectionLowWater;
        private Integer noRequestTimeout;

        private Builder() {
        }

        public Builder setBindAddress(InetSocketAddress bindAddress) {
            this.assertNotBuilt();
            this.bindAddress = bindAddress;
            return this;
        }

        public Builder setSecureBindAddress(InetSocketAddress secureBindAddress) {
            this.assertNotBuilt();
            this.secureBindAddress = secureBindAddress;
            return this;
        }

        public Builder setModelController(ModelController modelController) {
            this.assertNotBuilt();
            this.modelController = modelController;
            return this;
        }

        public Builder setSSLContext(SSLContext sslContext) {
            this.assertNotBuilt();
            this.sslContext = sslContext;
            return this;
        }

        public Builder setHttpAuthenticationFactory(HttpAuthenticationFactory httpAuthenticationFactory) {
            this.assertNotBuilt();
            this.httpAuthenticationFactory = httpAuthenticationFactory;
            return this;
        }

        public Builder setConsoleMode(ConsoleMode consoleMode) {
            this.assertNotBuilt();
            this.consoleMode = consoleMode;
            return this;
        }

        public Builder setConsoleSlot(String consoleSlot) {
            this.assertNotBuilt();
            this.consoleSlot = consoleSlot;
            return this;
        }

        public Builder setChannelUpgradeHandler(ChannelUpgradeHandler upgradeHandler) {
            this.assertNotBuilt();
            this.upgradeHandler = upgradeHandler;
            return this;
        }

        public Builder setManagementHttpRequestProcessor(ManagementHttpRequestProcessor managementHttpRequestProcessor) {
            this.assertNotBuilt();
            this.managementHttpRequestProcessor = managementHttpRequestProcessor;
            return this;
        }

        public Builder setAllowedOrigins(Collection<String> allowedOrigins) {
            this.assertNotBuilt();
            this.allowedOrigins = allowedOrigins;
            return this;
        }

        public Builder setWorker(XnioWorker worker) {
            this.assertNotBuilt();
            this.worker = worker;
            return this;
        }

        public Builder setExecutor(Executor executor) {
            this.assertNotBuilt();
            this.executor = executor;
            return this;
        }

        public Builder setConstantHeaders(Map<String, List<HttpInterfaceCommonPolicy.Header>> constantHeaders) {
            this.assertNotBuilt();
            this.constantHeaders = constantHeaders;
            return this;
        }

        public Builder setBacklog(Integer backlog) {
            this.assertNotBuilt();
            this.backlog = backlog;
            return this;
        }

        public Builder setConnectionHighWater(Integer connectionHighWater) {
            this.assertNotBuilt();
            this.connectionHighWater = connectionHighWater;
            return this;
        }

        public Builder setConnectionLowWater(Integer connectionLowWater) {
            this.assertNotBuilt();
            this.connectionLowWater = connectionLowWater;
            return this;
        }

        public Builder setNoRequestTimeout(Integer noRequestTimeout) {
            this.assertNotBuilt();
            this.noRequestTimeout = noRequestTimeout;
            return this;
        }

        public ManagementHttpServer build() {
            this.assertNotBuilt();
            ManagementHttpServer managementHttpServer = ManagementHttpServer.create(this);
            this.built = true;
            return managementHttpServer;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw HttpServerLogger.ROOT_LOGGER.managementHttpServerAlreadyBuild();
            }
        }

        public Builder setConsoleAvailability(ConsoleAvailability consoleAvailability) {
            this.assertNotBuilt();
            this.consoleAvailability = consoleAvailability;
            return this;
        }
    }

    private static class ExtensionHandlers {
        private final PathHandler extensionPathHandler;
        private final HttpHandler managementHandler;
        private final Function<HttpServerExchange, Boolean> readyFunction;
        private final Set<String> reservedContexts;
        private final Set<String> extensionContexts = new HashSet<String>();

        private ExtensionHandlers(PathHandler extensionPathHandler, HttpHandler managementHandler, Function<HttpServerExchange, Boolean> readyFunction, ResourceHandlerDefinition consoleHandler) {
            this.extensionPathHandler = extensionPathHandler;
            this.managementHandler = managementHandler;
            this.readyFunction = readyFunction;
            if (consoleHandler == null) {
                this.reservedContexts = RESERVED_CONTEXTS;
            } else {
                HashSet<String> set = new HashSet<String>(RESERVED_CONTEXTS);
                set.add(consoleHandler.getContext());
                this.reservedContexts = Collections.unmodifiableSet(set);
            }
        }
    }

    private static class RemapHandler
    implements HttpHandler {
        private final PathRemapper remapper;
        private final HttpHandler next;

        private RemapHandler(PathRemapper remapper, HttpHandler next) {
            this.remapper = remapper;
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (Methods.POST.equals(exchange.getRequestMethod())) {
                ResponseCodeHandler.HANDLE_405.handleRequest(exchange);
                return;
            }
            String origReqPath = exchange.getRelativePath();
            String remapped = this.remapper.remapPath(origReqPath);
            if (remapped == null) {
                ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
                return;
            }
            exchange.setRelativePath(remapped);
            this.next.handleRequest(exchange);
        }
    }

    public static interface PathRemapper {
        public String remapPath(String var1);
    }

    private static class UpgradeFixHandler
    implements HttpHandler {
        final HttpHandler next;

        private UpgradeFixHandler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRequestHeaders().contains(Headers.UPGRADE)) {
                exchange.addResponseWrapper((factory, ex) -> {
                    StreamSinkConduit ret = (StreamSinkConduit)factory.create();
                    if (exchange.getResponseHeaders().contains(Headers.UPGRADE)) {
                        exchange.getResponseHeaders().add(Headers.CONTENT_LENGTH, "0");
                    }
                    return ret;
                });
            }
            this.next.handleRequest(exchange);
        }
    }
}

