/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.messages;

import jakarta.ejb.EJBException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TransactionRequiredException;
import java.lang.invoke.MethodHandles;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.vfs.VirtualFile;

@MessageLogger(projectCode="WFLYJPA", length=4)
public interface JpaLogger
extends BasicLogger {
    public static final JpaLogger ROOT_LOGGER = (JpaLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), JpaLogger.class, (String)"org.jboss.as.jpa");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Duplicate Persistence Unit definition for %s in application.  One of the duplicate persistence.xml should be removed from the application. Application deployment will continue with the persistence.xml definitions from %s used.  The persistence.xml definitions from %s will be ignored.")
    public void duplicatePersistenceUnitDefinition(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Read persistence.xml for %s")
    public void readingPersistenceXml(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Starting %s Service '%s'")
    public void startingService(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Stopping %s Service '%s'")
    public void stoppingService(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Could not load default persistence provider module.  ")
    public void errorPreloadingDefaultProvider(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Failed to stop persistence unit service %s")
    public void failedToStopPUService(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10, value="Starting Persistence Unit (phase %d of 2) Service '%s'")
    public void startingPersistenceUnitService(int var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Stopping Persistence Unit (phase %d of 2) Service '%s'")
    public void stoppingPersistenceUnitService(int var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="Unexpected problem gathering statistics")
    public void unexpectedStatisticsProblem(@Cause RuntimeException var1);

    @Message(id=15, value="Container managed entity manager can only be closed by the container (will happen when @remove method is invoked on containing SFSB)")
    public IllegalStateException cannotCloseContainerManagedEntityManager();

    @Message(id=17, value="Container managed entity manager can only be closed by the container (auto-cleared at tx/invocation end and closed when owning component is closed.)")
    public IllegalStateException cannotCloseTransactionContainerEntityManger();

    @Message(id=18, value="Could not create instance of adapter class '%s'")
    public DeploymentUnitProcessingException cannotCreateAdapter(@Cause Throwable var1, String var2);

    @Message(id=19, value="Could not deploy application packaged persistence provider '%s'")
    public DeploymentUnitProcessingException cannotDeployApp(@Cause Throwable var1, String var2);

    @Message(id=20, value="Couldn't get Hibernate session factory from entity manager")
    public RuntimeException cannotGetSessionFactory(@Cause Throwable var1);

    @Message(id=21, value="Cannot inject RESOURCE_LOCAL container managed EntityManagers using @PersistenceContext")
    public String cannotInjectResourceLocalEntityManager();

    @Message(id=25, value="Couldn't load %s from Jakarta Persistence modules classloader")
    public RuntimeException cannotLoadFromJpa(@Cause Throwable var1, String var2);

    @Message(id=27, value="Persistence provider module load error %s (class %s)")
    public DeploymentUnitProcessingException cannotLoadPersistenceProviderModule(@Cause Throwable var1, String var2, String var3);

    @Message(id=29, value="Cannot specify both %s (%s) and %s (%s) in %s for %s")
    public DeploymentUnitProcessingException cannotSpecifyBoth(String var1, Object var2, String var3, Object var4, String var5, Object var6);

    @Message(id=30, value="Found extended persistence context in SFSB invocation call stack but that cannot be used because the transaction already has a transactional context associated with it.  This can be avoided by changing application code, either eliminate the extended persistence context or the transactional context.  See JPA spec 2.0 section 7.6.3.1.  Scoped persistence unit name=%s, persistence context already in transaction =%s, extended persistence context =%s.")
    public EJBException cannotUseExtendedPersistenceTransaction(String var1, EntityManager var2, EntityManager var3);

    @Message(id=31, value="Could not find child '%s' on '%s'")
    public RuntimeException childNotFound(String var1, VirtualFile var2);

    @Message(id=32, value="Class level %s annotation on class %s must provide a %s")
    public String classLevelAnnotationParameterRequired(String var1, String var2, String var3);

    @Message(id=33, value="Can't find a persistence unit named %s in %s")
    public String persistenceUnitNotFound(String var1, DeploymentUnit var2);

    @Message(id=34, value="Can't find a persistence unit named %s#%s at %s")
    public IllegalArgumentException persistenceUnitNotFound(String var1, String var2, DeploymentUnit var3);

    @Message(id=36, value="An error occurred while getting the transaction associated with the current thread: %s")
    public IllegalStateException errorGettingTransaction(Exception var1);

    @Message(id=37, value="Failed to get adapter for persistence provider '%s'")
    public DeploymentUnitProcessingException failedToGetAdapter(String var1);

    @Message(id=38, value="Failed to add persistence unit service for %s")
    public DeploymentUnitProcessingException failedToAddPersistenceUnit(@Cause Throwable var1, String var2);

    @Message(id=40, value="Failed to parse %s")
    public String failedToParse(VirtualFile var1);

    @Message(id=43, value="Persistence unit name (%s) contains illegal '%s' character")
    public IllegalArgumentException invalidPersistenceUnitName(String var1, char var2);

    @Message(id=44, value="jboss.as.jpa.scopedname hint (%s) contains illegal '%s' character")
    public IllegalArgumentException invalidScopedName(String var1, char var2);

    @Message(id=48, value="Persistence provider adapter module (%s) has more than one adapter")
    public RuntimeException multipleAdapters(String var1);

    @Message(id=53, value="Internal %s error, null %s passed in")
    public RuntimeException nullParameter(String var1, String var2);

    @Message(id=57, value="PersistenceProvider '%s' not found")
    public PersistenceException persistenceProviderNotFound(String var1);

    @Message(id=58, value="Could not find relative path: %s")
    public RuntimeException relativePathNotFound(@Cause Throwable var1, String var2);

    @Message(id=59, value="%s injection target is invalid.  Only setter methods are allowed: %s")
    public String setterMethodOnlyAnnotation(String var1, MethodInfo var2);

    @Message(id=60, value="Transaction is required to perform this operation (either use a transaction or extended persistence context)")
    public TransactionRequiredException transactionRequired();

    @Message(id=61, value="Persistence unitName was not specified and there are %d persistence unit definitions in application deployment %s.  Either change the application deployment to have only one persistence unit definition or specify the unitName for each reference to a persistence unit.")
    public IllegalArgumentException noPUnitNameSpecifiedAndMultiplePersistenceUnits(int var1, DeploymentUnit var2);

    @Message(id=62, value="Could not create instance of persistence provider class %s")
    public RuntimeException couldNotCreateInstanceProvider(@Cause Throwable var1, String var2);

    @Message(id=63, value="internal error, the number of stateful session beans (%d) associated with an extended persistence context (%s) cannot be a negative number.")
    public RuntimeException referenceCountedEntityManagerNegativeCount(int var1, String var2);

    @Message(id=64, value="Jakarta Transactions transaction already has a 'SynchronizationType.UNSYNCHRONIZED' persistence context (EntityManager) joined to it but a component with a 'SynchronizationType.SYNCHRONIZED' is now being used.  Change the calling component code to join the persistence context (EntityManager) to the transaction or change the called component code to also use 'SynchronizationType.UNSYNCHRONIZED'.  See JPA spec 2.1 section 7.6.4.1.  Scoped persistence unit name=%s.")
    public IllegalStateException badSynchronizationTypeCombination(String var1);

    @Message(id=65, value="Resources of type %s cannot be registered")
    public UnsupportedOperationException resourcesOfTypeCannotBeRegistered(String var1);

    @Message(id=66, value="Resources of type %s cannot be removed")
    public UnsupportedOperationException resourcesOfTypeCannotBeRemoved(String var1);

    @Message(id=67, value="Classloader '%s' has more than one Persistence provider adapter")
    public RuntimeException classloaderHasMultipleAdapters(String var1);

    @Message(id=69, value="Persistence provider adapter module load error %s")
    public DeploymentUnitProcessingException persistenceProviderAdaptorModuleLoadError(@Cause Throwable var1, String var2);

    @Message(id=70, value="A container-managed extended persistence context can only be initiated within the scope of a stateful session bean (persistence unit '%s').")
    public IllegalStateException xpcOnlyFromSFSB(String var1);

    @Message(id=71, value="Deployment '%s' specified more than one Hibernate Search module name ('%s','%s')")
    public DeploymentUnitProcessingException differentSearchModuleDependencies(String var1, String var2, String var3);

    @Message(id=73, value="Bytecode rewrite (transformation) of class %s failed")
    public String invalidClassFormat(String var1);

    @Message(id=74, value="Persistence provider integrator module load error for %s")
    public DeploymentUnitProcessingException cannotLoadPersistenceProviderIntegratorModule(@Cause Throwable var1, String var2);

    @Message(id=75, value="Illegal to call this method from injected, managed EntityManager")
    public IllegalStateException illegalCallOnCloseMethod();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=76, value="persistence.xml in application client %s deployment will not be deployed in server mode")
    public void ignoreAppclientPersistenceUnitsInServer(String var1);
}

