/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;

public class MicrometerExtensionLogger_$logger
extends DelegatingBasicLogger
implements MicrometerExtensionLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MicrometerExtensionLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public MicrometerExtensionLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void activatingSubsystem() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.activatingSubsystem$str(), new Object[0]);
    }

    protected String activatingSubsystem$str() {
        return "WFLYMMTREXT0001: Activating Micrometer Subsystem";
    }

    @Override
    public final void processingDeployment() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.processingDeployment$str(), new Object[0]);
    }

    protected String processingDeployment$str() {
        return "WFLYMMTREXT0002: Micrometer Subsystem is processing deployment";
    }

    @Override
    public final void noCdiDeployment() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.noCdiDeployment$str(), new Object[0]);
    }

    protected String noCdiDeployment$str() {
        return "WFLYMMTREXT0003: The deployment does not have Jakarta Contexts and Dependency Injection enabled. Skipping Micrometer integration.";
    }

    @Override
    public final void deploymentRequiresCapability(String deploymentName, String capabilityName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.deploymentRequiresCapability$str(), (Object)deploymentName, (Object)capabilityName);
    }

    protected String deploymentRequiresCapability$str() {
        return "WFLYMMTREXT0004: Deployment %s requires use of the '%s' capability but it is not currently registered";
    }

    @Override
    public final void unableToReadAttribute(String attributeName, PathAddress address, String error) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToReadAttribute$str(), (Object)attributeName, (Object)address, (Object)error);
    }

    protected String unableToReadAttribute$str() {
        return "WFLYMMTREXT0005: Unable to read attribute %s on %s: %s.";
    }

    @Override
    public final void unableToConvertAttribute(String attributeName, PathAddress address, Exception exception) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)exception, this.unableToConvertAttribute$str(), (Object)attributeName, (Object)address);
    }

    protected String unableToConvertAttribute$str() {
        return "WFLYMMTREXT0006: Unable to convert attribute %s on %s to Double value.";
    }

    @Override
    public final void malformedName(Exception exception) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)exception, this.malformedName$str(), new Object[0]);
    }

    protected String malformedName$str() {
        return "WFLYMMTREXT0007: Malformed name.";
    }

    protected String failedInitializeJMXRegistrar$str() {
        return "WFLYMMTREXT0008: Failed to initialize metrics from JMX MBeans";
    }

    @Override
    public final IllegalArgumentException failedInitializeJMXRegistrar(IOException e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failedInitializeJMXRegistrar$str(), new Object[0]), e);
        MicrometerExtensionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String unsupportedMetricType$str() {
        return "WFLYMMTREXT0009: An unsupported metric type was found: %s";
    }

    @Override
    public final IllegalArgumentException unsupportedMetricType(String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedMetricType$str(), type));
        MicrometerExtensionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void notActivatingSubsystem() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.notActivatingSubsystem$str(), new Object[0]);
    }

    protected String notActivatingSubsystem$str() {
        return "WFLYMMTREXT0010: Not activating Micrometer Subsystem";
    }

    @Override
    public final void noOpRegistryChosen() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noOpRegistryChosen$str(), new Object[0]);
    }

    protected String noOpRegistryChosen$str() {
        return "WFLYMMTREXT0011: Micrometer has been enabled, but no endpoint has been configured. A No-op metrics registry has been configured.";
    }

    @Override
    public final void multipleMetricsSystemsEnabled(String others) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.multipleMetricsSystemsEnabled$str(), (Object)others);
    }

    protected String multipleMetricsSystemsEnabled$str() {
        return "WFLYMMTREXT0012: Additional metrics systems discovered while configuring Micrometer: %s. Please refer to the documentation for more information.";
    }

    protected String errorRegisteringMetric$str() {
        return "WFLYMMTREXT0013: There was an error registering the metric '%s'";
    }

    @Override
    public final IllegalArgumentException errorRegisteringMetric(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.errorRegisteringMetric$str(), name));
        MicrometerExtensionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String prometheusNotSupportedOnHostControllers$str() {
        return "WFLYMMTREXT0014: Prometheus is not supported on domain mode servers";
    }

    @Override
    public final OperationFailedException prometheusNotSupportedOnHostControllers() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.prometheusNotSupportedOnHostControllers$str(), new Object[0]));
        MicrometerExtensionLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

