/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.AbstractInstMgrUpdateHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.core.instmgr.logging.InstMgrLogger;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.Repository;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public class InstMgrPrepareUpdateHandler
extends AbstractInstMgrUpdateHandler {
    static final String OPERATION_NAME = "prepare-updates";
    protected static final AttributeDefinition MAVEN_REPO_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"maven-repo-file", (ModelType)ModelType.INT).setStorageRuntime()).setRequired(false)).build();
    protected static final AttributeDefinition MAVEN_REPO_FILES = ((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("maven-repo-files", MAVEN_REPO_FILE).setStorageRuntime()).setRequired(false)).setAlternatives(new String[]{"work-dir", "repositories"})).build();
    protected static final AttributeDefinition LIST_UPDATES_WORK_DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"work-dir", (ModelType)ModelType.STRING).setRequired(false)).setStorageRuntime()).addArbitraryDescriptor("filesystem-path", ModelNode.TRUE)).setAlternatives(new String[]{"maven-repo-files", "repositories"})).build();
    protected static final AttributeDefinition REPOSITORIES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("repositories", REPOSITORY).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(false)).setAlternatives(new String[]{"work-dir", "maven-repo-files"})).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("prepare-updates", InstMgrResolver.RESOLVER).addParameter(OFFLINE).addParameter(REPOSITORIES).addParameter((AttributeDefinition)LOCAL_CACHE).addParameter(NO_RESOLVE_LOCAL_CACHE).addParameter(USE_DEFAULT_LOCAL_CACHE).addParameter(MAVEN_REPO_FILES).addParameter(LIST_UPDATES_WORK_DIR).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY}).setRuntimeOnly().build();

    InstMgrPrepareUpdateHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean offline = OFFLINE.resolveModelAttribute(context, operation).asBoolean(false);
        String pathLocalRepo = LOCAL_CACHE.resolveModelAttribute(context, operation).asStringOrNull();
        final Boolean noResolveLocalCache = NO_RESOLVE_LOCAL_CACHE.resolveModelAttribute(context, operation).asBooleanOrNull();
        final Boolean useDefaultLocalCache = USE_DEFAULT_LOCAL_CACHE.resolveModelAttribute(context, operation).asBooleanOrNull();
        final Path localRepository = pathLocalRepo != null ? Path.of(pathLocalRepo, new String[0]) : null;
        final List mavenRepoFileIndexes = MAVEN_REPO_FILES.resolveModelAttribute(context, operation).asListOrEmpty();
        final List repositoriesMn = REPOSITORIES.resolveModelAttribute(context, operation).asListOrEmpty();
        final String listUpdatesWorkDir = LIST_UPDATES_WORK_DIR.resolveModelAttribute(context, operation).asStringOrNull();
        if (noResolveLocalCache != null && useDefaultLocalCache != null) {
            throw InstMgrLogger.ROOT_LOGGER.noResolveLocalCacheWithUseDefaultLocalCache();
        }
        if (pathLocalRepo != null && useDefaultLocalCache != null && useDefaultLocalCache.booleanValue()) {
            throw InstMgrLogger.ROOT_LOGGER.localCacheWithUseDefaultLocalCache();
        }
        if (pathLocalRepo != null && noResolveLocalCache != null && noResolveLocalCache.booleanValue()) {
            throw InstMgrLogger.ROOT_LOGGER.localCacheWithNoResolveLocalCache();
        }
        if (!(listUpdatesWorkDir == null || repositoriesMn.isEmpty() && mavenRepoFileIndexes.isEmpty())) {
            throw InstMgrLogger.ROOT_LOGGER.workDirWithMavenRepoFileOrRepositories();
        }
        if (!mavenRepoFileIndexes.isEmpty() && !repositoriesMn.isEmpty()) {
            throw InstMgrLogger.ROOT_LOGGER.mavenRepoFileWithRepositories();
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.acquireControllerLock();
                if (!InstMgrPrepareUpdateHandler.this.imService.canPrepareServer()) {
                    throw InstMgrLogger.ROOT_LOGGER.serverAlreadyPrepared();
                }
                try {
                    InstMgrPrepareUpdateHandler.this.imService.beginCandidateServer();
                    InstMgrPrepareUpdateHandler.this.addCompleteStep(context, InstMgrPrepareUpdateHandler.this.imService, null);
                    Path homeDir = InstMgrPrepareUpdateHandler.this.imService.getHomeDir();
                    boolean noResolveLocalCacheResult = noResolveLocalCache != null ? noResolveLocalCache : (useDefaultLocalCache == null ? localRepository == null : useDefaultLocalCache == false && localRepository == null);
                    MavenOptions mavenOptions = new MavenOptions(localRepository, noResolveLocalCacheResult, offline);
                    InstallationManager im = InstMgrPrepareUpdateHandler.this.imf.create(homeDir, mavenOptions);
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    if (listUpdatesWorkDir != null) {
                        InstMgrLogger.ROOT_LOGGER.debug("Adding possible custom patch repositories");
                        repositories.addAll(InstMgrPrepareUpdateHandler.this.retrieveAllCustomPatchRepositories(im));
                        InstMgrLogger.ROOT_LOGGER.debug("Preparing a server candidate by using the workdir:" + listUpdatesWorkDir);
                        Path mvnRepoWorkDir = InstMgrPrepareUpdateHandler.this.imService.getTempDirByName(listUpdatesWorkDir);
                        InstMgrPrepareUpdateHandler.this.addCompleteStep(context, InstMgrPrepareUpdateHandler.this.imService, listUpdatesWorkDir);
                        for (File file : mvnRepoWorkDir.toFile().listFiles(InstMgrPrepareUpdateHandler::isInternalRepo)) {
                            Path repoIdPath = mvnRepoWorkDir.resolve(file.getName());
                            Path uploadedRepoZipRootDir = InstMgrPrepareUpdateHandler.this.getUploadedMvnRepoRoot(repoIdPath);
                            Repository uploadedMavenRepo = new Repository(file.getName(), uploadedRepoZipRootDir.toUri().toURL().toExternalForm());
                            repositories.add(uploadedMavenRepo);
                        }
                    } else if (!mavenRepoFileIndexes.isEmpty()) {
                        InstMgrLogger.ROOT_LOGGER.debug("Adding possible custom patch repositories");
                        repositories.addAll(InstMgrPrepareUpdateHandler.this.retrieveAllCustomPatchRepositories(im));
                        InstMgrLogger.ROOT_LOGGER.debug("Preparing a server candidate by using Operation Streams");
                        Path prepareUpdateWorkDir = InstMgrPrepareUpdateHandler.this.imService.createTempDir("prepare-updates-");
                        InstMgrPrepareUpdateHandler.this.addCompleteStep(context, InstMgrPrepareUpdateHandler.this.imService, prepareUpdateWorkDir.getFileName().toString());
                        repositories.addAll(InstMgrPrepareUpdateHandler.this.getRepositoriesFromOperationStreams(context, mavenRepoFileIndexes, prepareUpdateWorkDir));
                    } else {
                        repositories.addAll(InstMgrPrepareUpdateHandler.this.toRepositories(context, repositoriesMn));
                    }
                    InstMgrLogger.ROOT_LOGGER.debugf("Calling SPI to prepare an updates at [%s] with the following repositories [%s]", InstMgrPrepareUpdateHandler.this.imService.getPreparedServerDir(), repositories);
                    Files.createDirectories(InstMgrPrepareUpdateHandler.this.imService.getPreparedServerDir(), new FileAttribute[0]);
                    boolean prepared = im.prepareUpdate(InstMgrPrepareUpdateHandler.this.imService.getPreparedServerDir(), repositories);
                    if (prepared) {
                        context.getResult().set(InstMgrPrepareUpdateHandler.this.imService.getPreparedServerDir().normalize().toAbsolutePath().toString());
                        String applyUpdate = im.generateApplyUpdateCommand(homeDir.resolve("bin"), InstMgrPrepareUpdateHandler.this.imService.getPreparedServerDir(), AbstractInstMgrUpdateHandler.getOsShell());
                        InstMgrLogger.ROOT_LOGGER.debug("Apply Update Command: " + applyUpdate);
                        InstMgrPrepareUpdateHandler.this.imService.commitCandidateServer(applyUpdate);
                    } else {
                        InstMgrPrepareUpdateHandler.this.imService.resetCandidateStatus();
                    }
                }
                catch (ZipException e) {
                    throw new OperationFailedException(e.getLocalizedMessage());
                }
                catch (RuntimeException | OperationFailedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void addCompleteStep(OperationContext context, final InstMgrService imService, final String workDir) {
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                try {
                    imService.deleteTempDir(workDir);
                    if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                        imService.resetCandidateStatus();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static boolean isInternalRepo(File dir, String name) {
        return name.startsWith("repo-");
    }
}

