/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundRoutingBridge;
import org.hibernate.search.mapper.pojo.identity.impl.PojoRootIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContextProvider;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoContainedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.impl.AbstractPojoTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoRawTypeIdentifierResolver;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContextProvider;
import org.hibernate.search.util.common.data.spi.KeyValueProvider;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.CollectionHelper;

public class PojoTypeManagerContainer
implements AutoCloseable,
PojoWorkTypeContextProvider,
PojoScopeTypeContextProvider,
PojoRawTypeIdentifierResolver,
PojoLoadingTypeContextProvider {
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, AbstractPojoTypeManager<?, ?>> byExactType;
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, PojoIndexedTypeManager<?, ?>> indexedByExactType;
    private final KeyValueProvider<String, AbstractPojoTypeManager<?, ?>> byEntityName;
    private final KeyValueProvider<String, PojoIndexedTypeManager<?, ?>> indexedByEntityName;
    private final KeyValueProvider<String, PojoRawTypeIdentifier<?>> typeIdentifierByEntityName;
    private final KeyValueProvider<String, PojoRawTypeIdentifier<?>> typeIdentifierBySecondaryEntityName;
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, Set<? extends AbstractPojoTypeManager<?, ?>>> byNonInterfaceSuperType;
    private final KeyValueProvider<String, PojoRawTypeIdentifier<?>> nonInterfaceSuperTypeIdentifierByEntityName;
    private final KeyValueProvider<Class<?>, PojoRawTypeIdentifier<?>> nonInterfaceSuperTypeIdentifierByClass;
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, Set<? extends PojoIndexedTypeManager<?, ?>>> indexedBySuperType;
    private final KeyValueProvider<Class<?>, Set<? extends PojoIndexedTypeManager<?, ?>>> indexedBySuperTypeClass;
    private final KeyValueProvider<String, Set<? extends PojoIndexedTypeManager<?, ?>>> indexedBySuperTypeEntityName;
    private final Set<PojoIndexedTypeManager<?, ?>> allIndexed;
    private final Set<PojoRawTypeIdentifier<?>> allIndexedAndContainedTypes;

    public static Builder builder() {
        return new Builder();
    }

    private PojoTypeManagerContainer(Builder builder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
        Object typeIdentifier;
        AbstractPojoTypeManager typeManager;
        Iterator<Map.Entry<String, PojoRawTypeModel<?>>> typeModel;
        LinkedHashMap byExactTypeContent = new LinkedHashMap();
        LinkedHashMap indexedByExactTypeContent = new LinkedHashMap();
        LinkedHashMap bySuperTypeContent = new LinkedHashMap();
        LinkedHashMap indexedBySuperTypeContent = new LinkedHashMap();
        LinkedHashMap<String, AbstractPojoTypeManager> byEntityNameContent = new LinkedHashMap<String, AbstractPojoTypeManager>();
        LinkedHashMap<String, AbstractPojoTypeManager> indexedByEntityNameContent = new LinkedHashMap<String, AbstractPojoTypeManager>();
        Set<PojoIndexedTypeManager.Builder<?>> hasNonIndexedConcreteSubtypesSet = PojoTypeManagerContainer.createHasNonIndexedConcreteSubtypesSet(builder, reindexingResolverBuildingHelper);
        for (PojoIndexedTypeManager.Builder<?> builder2 : builder.indexed.values()) {
            typeModel = builder2.typeModel;
            PojoRawTypeIdentifier typeIdentifier2 = typeModel.typeIdentifier();
            builder2.hasNonIndexedConcreteSubtypes(hasNonIndexedConcreteSubtypesSet.contains(builder2));
            typeManager = builder2.build();
            MappingLog.INSTANCE.indexedTypeManager((PojoRawTypeModel<?>)((Object)typeModel), (PojoIndexedTypeManager<?, ?>)typeManager);
            byExactTypeContent.put(typeIdentifier2, typeManager);
            indexedByExactTypeContent.put(typeIdentifier2, typeManager);
            String string = typeManager.name();
            byEntityNameContent.put(string, typeManager);
            indexedByEntityNameContent.put(string, typeManager);
            PojoTypeManagerContainer.registerSuperTypes(bySuperTypeContent, typeModel, typeManager);
            PojoTypeManagerContainer.registerSuperTypes(indexedBySuperTypeContent, typeModel, typeManager);
        }
        for (PojoContainedTypeManager.Builder builder3 : builder.contained.values()) {
            typeModel = builder3.typeModel;
            PojoRawTypeIdentifier typeIdentifier2 = typeModel.typeIdentifier();
            typeManager = builder3.build();
            MappingLog.INSTANCE.containedTypeManager((PojoRawTypeModel<?>)((Object)typeModel), (PojoContainedTypeManager<?, ?>)typeManager);
            byExactTypeContent.put(typeIdentifier2, typeManager);
            byEntityNameContent.put(typeManager.name(), typeManager);
            PojoTypeManagerContainer.registerSuperTypes(bySuperTypeContent, typeModel, typeManager);
        }
        this.byExactType = new KeyValueProvider(byExactTypeContent, MappingLog.INSTANCE::unknownTypeIdentifierForMappedEntityType);
        this.indexedByExactType = new KeyValueProvider(indexedByExactTypeContent, MappingLog.INSTANCE::unknownTypeIdentifierForIndexedEntityType);
        this.byEntityName = new KeyValueProvider(byEntityNameContent, MappingLog.INSTANCE::unknownEntityNameForMappedEntityType);
        this.indexedByEntityName = new KeyValueProvider(indexedByEntityNameContent, MappingLog.INSTANCE::unknownEntityNameForIndexedEntityType);
        indexedBySuperTypeContent.replaceAll((k, v) -> Collections.unmodifiableSet(v));
        this.indexedBySuperType = KeyValueProvider.createWithMultiKeyException(indexedBySuperTypeContent, MappingLog.INSTANCE::invalidIndexedSuperTypes);
        LinkedHashMap typeIdentifierByEntityNameContent = new LinkedHashMap();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry<String, PojoRawTypeModel<?>> entry : builder.allEntitiesByName.entrySet()) {
            typeIdentifier = ((PojoRawTypeModel)entry.getValue()).typeIdentifier();
            typeIdentifierByEntityNameContent.put((String)entry.getKey(), typeIdentifier);
        }
        for (Map.Entry<String, PojoRawTypeModel<?>> entry : builder.allEntitiesBySecondaryName.entrySet()) {
            typeIdentifier = entry.getValue().typeIdentifier();
            linkedHashMap.put(entry.getKey(), typeIdentifier);
            typeIdentifierByEntityNameContent.putIfAbsent(entry.getKey(), typeIdentifier);
        }
        this.typeIdentifierByEntityName = new KeyValueProvider(typeIdentifierByEntityNameContent, MappingLog.INSTANCE::unknownEntityName);
        this.typeIdentifierBySecondaryEntityName = new KeyValueProvider(linkedHashMap, MappingLog.INSTANCE::unknownEntityName);
        LinkedHashMap<String, Set> indexedBySuperTypeEntityNameContent = new LinkedHashMap<String, Set>();
        LinkedHashMap<Class, Set> indexedBySuperTypeClassContent = new LinkedHashMap<Class, Set>();
        for (Map.Entry entry : indexedBySuperTypeContent.entrySet()) {
            PojoRawTypeIdentifier typeIdentifier3 = (PojoRawTypeIdentifier)entry.getKey();
            Set<String> entityNames = builder.allEntityNamesByTypeIdentifier.get(typeIdentifier3);
            if (entityNames != null) {
                for (String entityName : entityNames) {
                    indexedBySuperTypeEntityNameContent.put(entityName, (Set)entry.getValue());
                }
            }
            if (typeIdentifier3.isNamed()) continue;
            indexedBySuperTypeClassContent.put(typeIdentifier3.javaClass(), (Set)entry.getValue());
        }
        indexedBySuperTypeEntityNameContent.replaceAll((k, v) -> Collections.unmodifiableSet(v));
        this.indexedBySuperTypeEntityName = KeyValueProvider.createWithMultiKeyException(indexedBySuperTypeEntityNameContent, MappingLog.INSTANCE::invalidIndexedSuperTypeEntityNames);
        indexedBySuperTypeClassContent.replaceAll((k, v) -> Collections.unmodifiableSet(v));
        this.indexedBySuperTypeClass = KeyValueProvider.createWithMultiKeyException(indexedBySuperTypeClassContent, MappingLog.INSTANCE::invalidIndexedSuperTypeClasses);
        LinkedHashMap nonInterfaceSuperTypeIdentifierByClassContent = new LinkedHashMap();
        LinkedHashMap<String, PojoRawTypeIdentifier> linkedHashMap2 = new LinkedHashMap<String, PojoRawTypeIdentifier>();
        LinkedHashMap<PojoRawTypeIdentifier, Set> byNonInterfaceSuperTypeContent = new LinkedHashMap<PojoRawTypeIdentifier, Set>();
        for (Map.Entry entry : bySuperTypeContent.entrySet()) {
            PojoRawTypeIdentifier typeIdentifier4 = (PojoRawTypeIdentifier)entry.getKey();
            if (!typeIdentifier4.isNamed() && typeIdentifier4.javaClass().isInterface()) continue;
            byNonInterfaceSuperTypeContent.put(typeIdentifier4, (Set)entry.getValue());
            Set<String> entityNames = builder.allEntityNamesByTypeIdentifier.get(typeIdentifier4);
            if (entityNames != null) {
                for (String entityName : entityNames) {
                    linkedHashMap2.put(entityName, typeIdentifier4);
                }
            }
            if (typeIdentifier4.isNamed()) continue;
            nonInterfaceSuperTypeIdentifierByClassContent.put(typeIdentifier4.javaClass(), typeIdentifier4);
        }
        this.byNonInterfaceSuperType = new KeyValueProvider(byNonInterfaceSuperTypeContent, MappingLog.INSTANCE::unknownNonInterfaceSuperTypeIdentifier);
        this.nonInterfaceSuperTypeIdentifierByEntityName = new KeyValueProvider(linkedHashMap2, MappingLog.INSTANCE::unknownEntityNameForNonInterfaceSuperType);
        this.nonInterfaceSuperTypeIdentifierByClass = new KeyValueProvider(nonInterfaceSuperTypeIdentifierByClassContent, MappingLog.INSTANCE::unknownClassForNonInterfaceSuperType);
        this.allIndexed = Collections.unmodifiableSet(new LinkedHashSet(indexedByExactTypeContent.values()));
        this.allIndexedAndContainedTypes = Collections.unmodifiableSet(byExactTypeContent.keySet());
    }

    private static Set<PojoIndexedTypeManager.Builder<?>> createHasNonIndexedConcreteSubtypesSet(Builder builder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
        HashSet indexedIdentifiers = new HashSet();
        for (PojoIndexedTypeManager.Builder<?> typeManagerBuilder : builder.indexed.values()) {
            indexedIdentifiers.add(typeManagerBuilder.typeModel.typeIdentifier());
        }
        HashSet hasNonIndexedConcreteSubtypesSet = new HashSet();
        for (PojoIndexedTypeManager.Builder<?> typeManagerBuilder : builder.indexed.values()) {
            boolean hasNonIndexedConcreteSubtypes = false;
            Set<PojoRawTypeModel<?>> concreteSubTypes = reindexingResolverBuildingHelper.getConcreteEntitySubTypesForEntitySuperType(typeManagerBuilder.typeModel);
            for (PojoRawTypeModel<?> subtype : concreteSubTypes) {
                if (indexedIdentifiers.contains(subtype.typeIdentifier())) continue;
                hasNonIndexedConcreteSubtypes = true;
                break;
            }
            if (!hasNonIndexedConcreteSubtypes) continue;
            hasNonIndexedConcreteSubtypesSet.add(typeManagerBuilder);
        }
        return hasNonIndexedConcreteSubtypesSet;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(AbstractPojoTypeManager::close, this.allIndexed);
        }
    }

    public <E> AbstractPojoTypeManager<?, E> forExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (AbstractPojoTypeManager)this.byExactType.getOrFail(typeIdentifier);
    }

    public <E> PojoIndexedTypeManager<?, E> indexedForExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (PojoIndexedTypeManager)this.indexedByExactType.getOrFail(typeIdentifier);
    }

    @Override
    public Set<PojoRawTypeIdentifier<?>> allNonInterfaceSuperTypes() {
        return this.byNonInterfaceSuperType.keys();
    }

    @Override
    public Set<PojoRawTypeIdentifier<?>> allIndexedAndContainedTypes() {
        return this.allIndexedAndContainedTypes;
    }

    public <E> Set<? extends PojoIndexedTypeManager<?, ? extends E>> indexedForSuperTypes(Collection<? extends PojoRawTypeIdentifier<? extends E>> typeIdentifiers) {
        return CollectionHelper.flattenAsSet((Collection)this.indexedBySuperType.getAllOrFail(typeIdentifiers));
    }

    public <E> Optional<? extends Set<? extends PojoIndexedTypeManager<?, ? extends E>>> indexedForSuperType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return this.indexedBySuperType.getOptional(typeIdentifier);
    }

    public <T> Set<? extends PojoIndexedTypeManager<?, ? extends T>> indexedForSuperTypeClasses(Collection<? extends Class<? extends T>> classes) {
        return CollectionHelper.flattenAsSet((Collection)this.indexedBySuperTypeClass.getAllOrFail(classes));
    }

    public Set<? extends PojoIndexedTypeManager<?, ?>> indexedForSuperTypeEntityNames(Collection<String> entityNames) {
        return CollectionHelper.flattenAsSet((Collection)this.indexedBySuperTypeEntityName.getAllOrFail(entityNames));
    }

    @Override
    public <E> Set<? extends PojoWorkTypeContext<?, ? extends E>> forNonInterfaceSuperType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (Set)this.byNonInterfaceSuperType.getOrFail(typeIdentifier);
    }

    @Override
    public KeyValueProvider<String, PojoRawTypeIdentifier<?>> nonInterfaceSuperTypeIdentifierByEntityName() {
        return this.nonInterfaceSuperTypeIdentifierByEntityName;
    }

    @Override
    public <E> PojoRawTypeIdentifier<E> nonInterfaceSuperTypeIdentifierForClass(Class<E> clazz) {
        return (PojoRawTypeIdentifier)this.nonInterfaceSuperTypeIdentifierByClass.getOrFail(clazz);
    }

    @Override
    public KeyValueProvider<String, ? extends PojoWorkTypeContext<?, ?>> byEntityName() {
        return this.byEntityName;
    }

    public KeyValueProvider<String, PojoIndexedTypeManager<?, ?>> indexedByEntityName() {
        return this.indexedByEntityName;
    }

    @Override
    public KeyValueProvider<String, PojoRawTypeIdentifier<?>> typeIdentifierByEntityName() {
        return this.typeIdentifierByEntityName;
    }

    @Override
    public KeyValueProvider<String, PojoRawTypeIdentifier<?>> typeIdentifierBySecondaryEntityName() {
        return this.typeIdentifierBySecondaryEntityName;
    }

    Set<PojoIndexedTypeManager<?, ?>> allIndexed() {
        return this.allIndexed;
    }

    private static <T> void registerSuperTypes(Map<PojoRawTypeIdentifier<?>, Set<T>> bySuperType, PojoRawTypeModel<?> entityType, T value) {
        entityType.descendingSuperTypes().map(PojoRawTypeModel::typeIdentifier).forEach(superTypeIdentifier -> bySuperType.computeIfAbsent((PojoRawTypeIdentifier<?>)superTypeIdentifier, ignored -> new LinkedHashSet()).add(value));
    }

    public static class Builder {
        public final Map<PojoRawTypeModel<?>, PojoIndexedTypeManager.Builder<?>> indexed = new LinkedHashMap();
        public final Map<PojoRawTypeModel<?>, PojoContainedTypeManager.Builder<?>> contained = new LinkedHashMap();
        private final Map<PojoRawTypeIdentifier<?>, Set<PojoRawTypeIdentifier<?>>> entityTypeIdentifiersBySuperType = new LinkedHashMap();
        private final Map<PojoRawTypeIdentifier<?>, Set<String>> allEntityNamesByTypeIdentifier = new LinkedHashMap();
        private final Map<String, PojoRawTypeModel<?>> allEntitiesByName = new LinkedHashMap();
        private final Map<String, PojoRawTypeModel<?>> allEntitiesBySecondaryName = new LinkedHashMap();

        private Builder() {
        }

        public <E> PojoIndexedTypeManager.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String entityName, String secondaryEntityName, PojoRootIdentityMappingCollector<E> identityMappingCollector, PojoIndexedTypeExtendedMappingCollector extendedMappingCollector, BoundRoutingBridge<E> routingBridge, PojoIndexingProcessorOriginalTypeNodeBuilder<E> indexingProcessorBuilder, MappedIndexManagerBuilder indexManagerBuilder) {
            PojoIndexedTypeManager.Builder<E> builder = new PojoIndexedTypeManager.Builder<E>(typeModel, entityName, secondaryEntityName, identityMappingCollector, extendedMappingCollector, routingBridge, indexingProcessorBuilder, indexManagerBuilder);
            this.indexed.put(typeModel, builder);
            return builder;
        }

        public <E> PojoContainedTypeManager.Builder<E> addContained(PojoRawTypeModel<E> typeModel, String entityName, String secondaryEntityName, PojoRootIdentityMappingCollector<E> identityMappingCollector, PojoContainedTypeExtendedMappingCollector extendedMappingCollector) {
            PojoContainedTypeManager.Builder<E> builder = new PojoContainedTypeManager.Builder<E>(typeModel, entityName, secondaryEntityName, identityMappingCollector, extendedMappingCollector);
            this.contained.put(typeModel, builder);
            return builder;
        }

        public void addEntity(PojoRawTypeModel<?> entityType, String entityName, String secondaryEntityName) {
            PojoRawTypeIdentifier<?> typeIdentifier = entityType.typeIdentifier();
            this.allEntityNamesByTypeIdentifier.computeIfAbsent(typeIdentifier, ignored -> new LinkedHashSet()).add(entityName);
            PojoRawTypeModel<?> previousType = this.allEntitiesByName.putIfAbsent(entityName, entityType);
            if (previousType != null) {
                throw MappingLog.INSTANCE.multipleEntityTypesWithSameName(entityName, previousType, entityType);
            }
            if (secondaryEntityName != null) {
                this.allEntityNamesByTypeIdentifier.computeIfAbsent(typeIdentifier, ignored -> new LinkedHashSet()).add(secondaryEntityName);
                previousType = this.allEntitiesBySecondaryName.putIfAbsent(secondaryEntityName, entityType);
                if (previousType != null) {
                    throw MappingLog.INSTANCE.multipleEntityTypesWithSameSecondaryName(secondaryEntityName, previousType, entityType);
                }
            }
            PojoTypeManagerContainer.registerSuperTypes(this.entityTypeIdentifiersBySuperType, entityType, entityType.typeIdentifier());
        }

        public void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.pushAll(AbstractPojoTypeManager.Builder::closeOnFailure, this.indexed.values());
                closer.pushAll(AbstractPojoTypeManager.Builder::closeOnFailure, this.contained.values());
            }
        }

        public PojoTypeManagerContainer build(PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
            return new PojoTypeManagerContainer(this, reindexingResolverBuildingHelper);
        }
    }
}

