/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.util.common.impl.Contracts;

public abstract class PojoModelPath {
    protected static final Pattern DOT_PATTERN = Pattern.compile("\\.");

    public static Builder builder() {
        return new Builder();
    }

    public static PojoModelPathPropertyNode ofProperty(String propertyName) {
        return new PojoModelPathPropertyNode(null, propertyName);
    }

    public static PojoModelPathValueNode ofValue(String propertyName) {
        return PojoModelPath.ofValue(propertyName, ContainerExtractorPath.defaultExtractors());
    }

    public static PojoModelPathValueNode ofValue(String propertyName, ContainerExtractorPath extractorPath) {
        return new PojoModelPathValueNode(PojoModelPath.ofProperty(propertyName), extractorPath);
    }

    public static PojoModelPathValueNode parse(String dotSeparatedPath) {
        Contracts.assertNotNullNorEmpty((String)dotSeparatedPath, (String)"dotSeparatedPath");
        Builder builder = PojoModelPath.builder();
        for (String propertyName : DOT_PATTERN.split(dotSeparatedPath, -1)) {
            builder.property(propertyName).valueWithDefaultExtractors();
        }
        return builder.toValuePath();
    }

    PojoModelPath() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append("[");
        this.appendPath(builder);
        builder.append("]");
        return builder.toString();
    }

    public final String toPathString() {
        StringBuilder builder = new StringBuilder();
        this.appendPath(builder);
        return builder.toString();
    }

    public abstract PojoModelPath parent();

    abstract void appendSelfPath(StringBuilder var1);

    private void appendPath(StringBuilder builder) {
        PojoModelPath parent = this.parent();
        if (parent == null) {
            this.appendSelfPath(builder);
        } else {
            parent.appendPath(builder);
            this.appendSelfPath(builder);
        }
    }

    public static class Builder {
        private PojoModelPathPropertyNode currentPropertyNode;
        private final List<String> currentExplicitExtractors = new ArrayList<String>();
        private boolean noExtractors;
        private boolean defaultExtractors;

        private Builder() {
        }

        public Builder property(String propertyName) {
            this.currentPropertyNode = new PojoModelPathPropertyNode(this.toValuePathOrNull(), propertyName);
            return this;
        }

        public Builder value(ContainerExtractorPath extractorPath) {
            if (extractorPath.isDefault()) {
                return this.valueWithDefaultExtractors();
            }
            if (extractorPath.isEmpty()) {
                return this.valueWithoutExtractors();
            }
            for (String extractorName : extractorPath.explicitExtractorNames()) {
                this.value(extractorName);
            }
            return this;
        }

        public Builder value(String extractorName) {
            this.checkHasPropertyName();
            if (this.defaultExtractors) {
                throw MappingLog.INSTANCE.cannotUseDefaultExtractorsInMultiExtractorChain();
            }
            this.noExtractors = false;
            this.currentExplicitExtractors.add(extractorName);
            return this;
        }

        public Builder valueWithoutExtractors() {
            this.checkHasPropertyName();
            this.noExtractors = true;
            return this;
        }

        public Builder valueWithDefaultExtractors() {
            this.checkHasPropertyName();
            if (!this.currentExplicitExtractors.isEmpty()) {
                throw MappingLog.INSTANCE.cannotUseDefaultExtractorsInMultiExtractorChain();
            }
            this.noExtractors = false;
            this.defaultExtractors = true;
            return this;
        }

        public PojoModelPathPropertyNode toPropertyPath() {
            this.checkHasPropertyName();
            return this.currentPropertyNode;
        }

        public PojoModelPathPropertyNode toPropertyPathOrNull() {
            if (this.isEmpty()) {
                return null;
            }
            return this.toPropertyPath();
        }

        public PojoModelPathValueNode toValuePath() {
            return new PojoModelPathValueNode(this.toPropertyPath(), this.flushContainerExtractorPath());
        }

        public PojoModelPathValueNode toValuePathOrNull() {
            if (this.isEmpty()) {
                return null;
            }
            return this.toValuePath();
        }

        private boolean isEmpty() {
            return this.currentPropertyNode == null && !this.noExtractors && !this.defaultExtractors && this.currentExplicitExtractors.isEmpty();
        }

        private ContainerExtractorPath flushContainerExtractorPath() {
            ContainerExtractorPath result = !this.currentExplicitExtractors.isEmpty() ? ContainerExtractorPath.explicitExtractors(this.currentExplicitExtractors) : (this.noExtractors ? ContainerExtractorPath.noExtractors() : ContainerExtractorPath.defaultExtractors());
            this.currentExplicitExtractors.clear();
            this.noExtractors = false;
            this.defaultExtractors = false;
            return result;
        }

        private void checkHasPropertyName() {
            if (this.currentPropertyNode == null) {
                throw MappingLog.INSTANCE.cannotDefinePojoModelPathWithoutProperty();
            }
        }
    }
}

