/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.loading.impl;

import java.util.Map;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.common.spi.PojoEntityReferenceFactoryDelegate;
import org.hibernate.search.mapper.pojo.loading.impl.PojoLoadingPlan;
import org.hibernate.search.mapper.pojo.logging.impl.LoadingLog;
import org.hibernate.search.mapper.pojo.search.loading.impl.PojoSearchLoadingIndexedTypeContext;

public final class PojoProjectionHitMapper<E>
implements ProjectionHitMapper<E> {
    private final Map<String, PojoSearchLoadingIndexedTypeContext<? extends E>> targetTypesByEntityName;
    private final PojoEntityReferenceFactoryDelegate entityReferenceFactoryDelegate;
    private final BridgeSessionContext sessionContext;
    private final PojoLoadingPlan<E> loadingPlan;

    public PojoProjectionHitMapper(Map<String, PojoSearchLoadingIndexedTypeContext<? extends E>> targetTypesByEntityName, PojoEntityReferenceFactoryDelegate entityReferenceFactoryDelegate, BridgeSessionContext sessionContext, PojoLoadingPlan<E> loadingPlan) {
        this.targetTypesByEntityName = targetTypesByEntityName;
        this.entityReferenceFactoryDelegate = entityReferenceFactoryDelegate;
        this.sessionContext = sessionContext;
        this.loadingPlan = loadingPlan;
    }

    public Object planLoading(DocumentReference reference) {
        PojoSearchLoadingIndexedTypeContext<E> type = this.toType(reference);
        Object identifier = this.toEntityIdentifier(type, reference);
        int ordinal = this.loadingPlan.planLoading(type, identifier);
        if (this.targetTypesByEntityName.size() == 1) {
            return ordinal;
        }
        return new TypeAndOrdinal<E>(type, ordinal);
    }

    public LoadingResult<E> loadBlocking(Deadline deadline) {
        this.loadingPlan.loadBlocking(deadline);
        if (this.targetTypesByEntityName.size() == 1) {
            return new SingleTypeLoadingResult(this.targetTypesByEntityName.values().iterator().next());
        }
        return new MultiTypeLoadingResult();
    }

    private PojoSearchLoadingIndexedTypeContext<? extends E> toType(DocumentReference reference) {
        PojoSearchLoadingIndexedTypeContext<? extends E> type = this.targetTypesByEntityName.get(reference.typeName());
        if (type == null) {
            throw LoadingLog.INSTANCE.unexpectedEntityNameForEntityLoading(reference.typeName(), this.targetTypesByEntityName.keySet());
        }
        return type;
    }

    private Object toEntityIdentifier(PojoSearchLoadingIndexedTypeContext<?> type, DocumentReference reference) {
        return type.identifierMapping().fromDocumentIdentifier(reference.id(), this.sessionContext);
    }

    private EntityReference toEntityReference(PojoSearchLoadingIndexedTypeContext<?> type, DocumentReference reference) {
        return this.entityReferenceFactoryDelegate.create(type.typeIdentifier(), type.entityName(), this.toEntityIdentifier(type, reference));
    }

    private static final class TypeAndOrdinal<E> {
        private final PojoSearchLoadingIndexedTypeContext<? extends E> type;
        private final int ordinal;

        public TypeAndOrdinal(PojoSearchLoadingIndexedTypeContext<? extends E> type, int ordinal) {
            this.type = type;
            this.ordinal = ordinal;
        }
    }

    private class SingleTypeLoadingResult
    implements LoadingResult<E> {
        private final PojoSearchLoadingIndexedTypeContext<? extends E> type;

        private SingleTypeLoadingResult(PojoSearchLoadingIndexedTypeContext<? extends E> type) {
            this.type = type;
        }

        public E get(Object key) {
            return PojoProjectionHitMapper.this.loadingPlan.retrieve(this.type, (Integer)key);
        }

        public EntityReference convertReference(DocumentReference reference) {
            return PojoProjectionHitMapper.this.toEntityReference(this.type, reference);
        }
    }

    private class MultiTypeLoadingResult
    implements LoadingResult<E> {
        private MultiTypeLoadingResult() {
        }

        public E get(Object key) {
            TypeAndOrdinal typeAndOrdinal = (TypeAndOrdinal)key;
            return PojoProjectionHitMapper.this.loadingPlan.retrieve(typeAndOrdinal.type, typeAndOrdinal.ordinal);
        }

        public EntityReference convertReference(DocumentReference reference) {
            return PojoProjectionHitMapper.this.toEntityReference(PojoProjectionHitMapper.this.toType(reference), reference);
        }
    }
}

