/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.servlet.util.SavedRequest;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentServiceInstallerProvider;
import org.wildfly.clustering.web.service.deployment.WebDeploymentConfiguration;
import org.wildfly.clustering.web.service.deployment.WebDeploymentServiceDescriptor;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.service.session.LegacyDistributableSessionManagementProviderFactory;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactory;
import org.wildfly.elytron.web.undertow.server.servlet.ServletSecurityContextImpl;
import org.wildfly.extension.undertow.session.SessionAffinityProvider;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class DistributableWebDeploymentServiceInstallerProvider
implements WebDeploymentServiceInstallerProvider {
    private final LegacyDistributableSessionManagementProviderFactory legacyFactory = ServiceLoader.load(LegacyDistributableSessionManagementProviderFactory.class, LegacyDistributableSessionManagementProviderFactory.class.getClassLoader()).findFirst().orElseThrow();

    public DeploymentServiceInstaller getSessionManagerFactoryServiceInstaller(final SessionManagerFactoryConfiguration configuration) {
        DeploymentUnit unit = configuration.getDeploymentUnit();
        DistributableSessionManagementProvider provider = this.findDistributableSessionManagementProvider(unit);
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        List immutableClassNames = unit.getAttachmentList(DistributableSessionManagementProvider.IMMUTABILITY_ATTACHMENT_KEY);
        ArrayList<Class> immutableClasses = new ArrayList<Class>(immutableClassNames.size());
        try {
            for (String immutableClassName : immutableClassNames) {
                immutableClasses.add(module.getClassLoader().loadClass(immutableClassName));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        Immutability immutability = Immutability.classes(immutableClasses);
        DeploymentServiceInstaller providedInstaller = provider.getSessionManagerFactoryServiceInstaller(new SessionManagerFactoryConfigurationAdapter<DistributableSessionManagementConfiguration>(configuration, provider.getSessionManagementConfiguration(), immutability));
        Function<SessionManagerFactory<ServletContext, Map<String, Object>>, io.undertow.servlet.api.SessionManagerFactory> mapper = new Function<SessionManagerFactory<ServletContext, Map<String, Object>>, io.undertow.servlet.api.SessionManagerFactory>(){

            @Override
            public io.undertow.servlet.api.SessionManagerFactory apply(SessionManagerFactory<ServletContext, Map<String, Object>> factory) {
                return new DistributableSessionManagerFactory(factory, configuration);
            }
        };
        ServiceDependency factory = ServiceDependency.on((ServiceName)WebDeploymentServiceDescriptor.SESSION_MANAGER_FACTORY.resolve(unit));
        DeploymentServiceInstaller installer = (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Function)mapper, (Supplier)factory).provides(org.wildfly.extension.undertow.deployment.WebDeploymentServiceDescriptor.SESSION_MANAGER_FACTORY.resolve(unit))).requires((Consumer)factory)).build();
        return DeploymentServiceInstaller.combine((DeploymentServiceInstaller[])new DeploymentServiceInstaller[]{providedInstaller, installer});
    }

    public DeploymentServiceInstaller getSessionAffinityProviderServiceInstaller(org.wildfly.clustering.web.container.WebDeploymentConfiguration configuration) {
        DeploymentUnit unit = configuration.getDeploymentUnit();
        DistributableSessionManagementProvider provider = this.findDistributableSessionManagementProvider(unit);
        DeploymentServiceInstaller locatorInstaller = provider.getRouteLocatorServiceInstaller((WebDeploymentConfiguration)new WebDeploymentConfigurationAdapter(configuration));
        ServiceDependency locator = ServiceDependency.on((ServiceName)WebDeploymentServiceDescriptor.ROUTE_LOCATOR.resolve(configuration.getDeploymentUnit()));
        ServiceDependency factory = locator.map(SessionAffinityProviderAdapter::new);
        DeploymentServiceInstaller affinityInstaller = (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(org.wildfly.extension.undertow.deployment.WebDeploymentServiceDescriptor.SESSION_AFFINITY_PROVIDER.resolve(unit))).requires((Consumer)locator)).build();
        return DeploymentServiceInstaller.combine((DeploymentServiceInstaller[])new DeploymentServiceInstaller[]{locatorInstaller, affinityInstaller});
    }

    private DistributableSessionManagementProvider findDistributableSessionManagementProvider(DeploymentUnit unit) {
        DistributableSessionManagementProvider provider = (DistributableSessionManagementProvider)unit.getAttachment(DistributableSessionManagementProvider.ATTACHMENT_KEY);
        ReplicationConfig replicationConfig = Optional.ofNullable((WarMetaData)unit.getAttachment(WarMetaData.ATTACHMENT_KEY)).map(WarMetaData::getMergedJBossWebMetaData).map(JBossWebMetaData::getReplicationConfig).orElse(null);
        if (replicationConfig != null || provider == null) {
            if (provider != null) {
                UndertowClusteringLogger.ROOT_LOGGER.legacySessionManagementProviderOverride(unit.getName());
            } else {
                UndertowClusteringLogger.ROOT_LOGGER.legacySessionManagementProviderInUse(unit.getName());
            }
            return this.legacyFactory.createSessionManagerProvider(unit, replicationConfig);
        }
        return provider;
    }

    static class SessionManagerFactoryConfigurationAdapter<C extends DistributableSessionManagementConfiguration<DeploymentUnit>>
    extends WebDeploymentConfigurationAdapter
    implements org.wildfly.clustering.web.service.session.SessionManagerFactoryConfiguration<Map<String, Object>> {
        private final OptionalInt maxActiveSessions;
        private final ByteBufferMarshaller marshaller;
        private final Immutability immutability;
        private final SessionAttributePersistenceStrategy attributePersistenceStrategy;

        public SessionManagerFactoryConfigurationAdapter(SessionManagerFactoryConfiguration configuration, C managementConfiguration, Immutability immutability) {
            super((org.wildfly.clustering.web.container.WebDeploymentConfiguration)configuration);
            this.maxActiveSessions = configuration.getMaxActiveSessions();
            DeploymentUnit unit = configuration.getDeploymentUnit();
            Module module = (Module)unit.getAttachment(Attachments.MODULE);
            this.marshaller = (ByteBufferMarshaller)managementConfiguration.getMarshallerFactory().apply(configuration.getDeploymentUnit());
            LinkedList<Immutability> loadedImmutabilities = new LinkedList<Immutability>();
            for (Immutability loadedImmutability : module.loadService(Immutability.class)) {
                loadedImmutabilities.add(loadedImmutability);
            }
            this.immutability = Immutability.composite(List.of(Immutability.getDefault(), Immutability.classes(List.of(AuthenticatedSessionManager.AuthenticatedSession.class, SavedRequest.class, CachedIdentity.class, ServletSecurityContextImpl.IdentityContainer.class)), Immutability.composite(loadedImmutabilities), immutability));
            this.attributePersistenceStrategy = managementConfiguration.getAttributePersistenceStrategy();
        }

        public OptionalInt getMaxActiveSessions() {
            return this.maxActiveSessions;
        }

        public ByteBufferMarshaller getMarshaller() {
            return this.marshaller;
        }

        public Supplier<Map<String, Object>> getSessionContextFactory() {
            return ConcurrentHashMap::new;
        }

        public Immutability getImmutability() {
            return this.immutability;
        }

        public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
            return this.attributePersistenceStrategy;
        }
    }

    static class WebDeploymentConfigurationAdapter
    implements WebDeploymentConfiguration {
        private final org.wildfly.clustering.web.container.WebDeploymentConfiguration configuration;

        public WebDeploymentConfigurationAdapter(org.wildfly.clustering.web.container.WebDeploymentConfiguration configuration) {
            this.configuration = configuration;
        }

        public String getServerName() {
            return this.configuration.getServerName();
        }

        public DeploymentUnit getDeploymentUnit() {
            return this.configuration.getDeploymentUnit();
        }
    }

    static class SessionAffinityProviderAdapter
    implements SessionAffinityProvider {
        private final UnaryOperator<String> locator;

        SessionAffinityProviderAdapter(UnaryOperator<String> locator) {
            this.locator = locator;
        }

        public Optional<String> getAffinity(String sessionId) {
            return Optional.ofNullable((String)this.locator.apply(sessionId));
        }
    }
}

