/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.BaseBundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.RingBuffer;
import org.jgroups.util.Runner;

@Experimental
public class RemoveQueueBundler
extends BaseBundler {
    protected RingBuffer<Message> rb;
    protected Runner runner;
    protected Message[] remove_queue;
    protected static final String THREAD_NAME = "rq-bundler";
    @Property(name="remove_queue_size", description="The capacity of the remove queue", writable=false)
    protected int queue_size = 1024;

    @ManagedAttribute(description="Current number of messages (to be sent) in the ring buffer")
    public int ringBufferSize() {
        return this.rb.size();
    }

    @Override
    public void init(TP transport) {
        super.init(transport);
        this.rb = new RingBuffer<Message>(Message.class, this.capacity);
        this.remove_queue = new Message[this.queue_size];
        this.runner = new Runner(transport.getThreadFactory(), THREAD_NAME, this::run, null);
    }

    @Override
    public synchronized void start() {
        super.start();
        this.runner.start();
    }

    @Override
    public synchronized void stop() {
        this.runner.stop();
        super.stop();
    }

    @Override
    public void renameThread() {
        this.transport.getThreadFactory().renameThread(THREAD_NAME, this.runner.getThread());
    }

    @Override
    public void send(Message msg) throws Exception {
        this.rb.put(msg);
    }

    public void run() {
        try {
            int drained = this.rb.drainToBlocking((Message[])this.remove_queue);
            if (drained == 1) {
                this.output.position(0);
                this.sendSingle(this.remove_queue[0].dest(), this.remove_queue[0], this.output);
                return;
            }
            for (int i = 0; i < drained; ++i) {
                Message msg = this.remove_queue[i];
                int size = msg.size();
                if (this.count + (long)size >= (long)this.max_size) {
                    this.sendBundledMessages();
                }
                this.addMessage(msg, msg.size());
            }
            this.sendBundledMessages();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getQueueSize() {
        return this.rb.size();
    }

    @Override
    public int size() {
        return this.rb.size();
    }
}

