/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.xa.Xid;
import org.wildfly.transaction.client.SimpleXid;

final class Serializer {
    private Serializer() {
    }

    static void serializeXid(ObjectOutput output, Xid xid) throws IOException {
        output.writeInt(xid.getFormatId());
        output.writeInt(xid.getGlobalTransactionId().length);
        output.write(xid.getGlobalTransactionId());
        output.writeInt(xid.getBranchQualifier().length);
        output.write(xid.getBranchQualifier());
    }

    static Xid deserializeXid(ObjectInput input) throws IOException {
        int formatId = input.readInt();
        int length = input.readInt();
        byte[] globalId = new byte[length];
        input.readFully(globalId);
        length = input.readInt();
        byte[] branchId = new byte[length];
        input.readFully(branchId);
        return new SimpleXid(formatId, globalId, branchId);
    }

    static void serializeXidArray(ObjectOutput output, Xid[] xids) throws IOException {
        output.writeInt(xids.length);
        for (Xid xid : xids) {
            Serializer.serializeXid(output, xid);
        }
    }

    static Xid[] deserializeXidArray(ObjectInput input) throws IOException {
        int length = input.readInt();
        Xid[] ret = new Xid[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = Serializer.deserializeXid(input);
        }
        return ret;
    }
}

