/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.lang.annotation.Annotation;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.SecondaryAuditTable;
import org.hibernate.envers.SecondaryAuditTables;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.models.spi.ClassDetails;

public final class AnnotationsMetadataReader {
    private final EnversMetadataBuildingContext metadataBuildingContext;
    private final AuditTable defaultAuditTable = new AuditTable(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public String schema() {
            return "";
        }

        @Override
        public String catalog() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }
    };

    public AnnotationsMetadataReader(EnversMetadataBuildingContext metadataBuildingContext) {
        this.metadataBuildingContext = metadataBuildingContext;
    }

    private RelationTargetAuditMode getDefaultAudited(ClassDetails classDetails) {
        Audited defaultAudited = (Audited)classDetails.getDirectAnnotationUsage(Audited.class);
        if (defaultAudited != null) {
            return defaultAudited.targetAuditMode();
        }
        return null;
    }

    private void addAuditTable(ClassAuditingData auditData, ClassDetails classDetails) {
        AuditTable auditTable = (AuditTable)classDetails.getDirectAnnotationUsage(AuditTable.class);
        if (auditTable != null) {
            auditData.setAuditTable(auditTable);
        } else {
            auditData.setAuditTable(this.getDefaultAuditTable());
        }
    }

    private void addAuditSecondaryTables(ClassAuditingData auditData, ClassDetails classDetails) {
        SecondaryAuditTables secondaryAuditTables;
        SecondaryAuditTable secondaryVersionsTable1 = (SecondaryAuditTable)classDetails.getDirectAnnotationUsage(SecondaryAuditTable.class);
        if (secondaryVersionsTable1 != null) {
            auditData.getSecondaryTableDictionary().put(secondaryVersionsTable1.secondaryTableName(), secondaryVersionsTable1.secondaryAuditTableName());
        }
        if ((secondaryAuditTables = (SecondaryAuditTables)classDetails.getDirectAnnotationUsage(SecondaryAuditTables.class)) != null) {
            for (SecondaryAuditTable secondaryAuditTable2 : secondaryAuditTables.value()) {
                auditData.getSecondaryTableDictionary().put(secondaryAuditTable2.secondaryTableName(), secondaryAuditTable2.secondaryAuditTableName());
            }
        }
    }

    public ClassAuditingData getAuditData(PersistentClass persistentClass) {
        ClassAuditingData auditData = new ClassAuditingData(persistentClass);
        ClassDetails classDetails = this.metadataBuildingContext.getClassDetailsRegistry().resolveClassDetails(persistentClass.getClassName());
        RelationTargetAuditMode auditMode = this.getDefaultAudited(classDetails);
        if (auditMode != null) {
            auditData.setDefaultAudited(true);
        }
        new AuditedPropertiesReader(this.metadataBuildingContext, PersistentPropertiesSource.forClass(persistentClass, classDetails), auditData).read();
        this.addAuditTable(auditData, classDetails);
        this.addAuditSecondaryTables(auditData, classDetails);
        return auditData;
    }

    private AuditTable getDefaultAuditTable() {
        return this.defaultAuditTable;
    }
}

