/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.persistence.jipijapa.hibernate7;

import org.hibernate.boot.archive.spi.ArchiveContext;
import org.hibernate.boot.archive.spi.ArchiveDescriptor;
import org.hibernate.boot.archive.spi.ArchiveEntry;
import org.hibernate.boot.archive.spi.InputStreamAccess;
import org.jboss.vfs.VirtualFile;
import org.wildfly.persistence.jipijapa.hibernate7.VirtualFileInputStreamAccess;

public class VirtualFileSystemArchiveDescriptor
implements ArchiveDescriptor {
    private final VirtualFile root;

    public VirtualFileSystemArchiveDescriptor(VirtualFile archiveRoot, String entryBase) {
        this.root = entryBase != null && entryBase.length() > 0 && !"/".equals(entryBase) ? archiveRoot.getChild(entryBase) : archiveRoot;
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public void visitArchive(ArchiveContext archiveContext) {
        this.processVirtualFile(this.root, null, archiveContext);
    }

    private void processVirtualFile(VirtualFile virtualFile, String path, ArchiveContext archiveContext) {
        if (path == null) {
            path = "";
        } else if (!((String)path).endsWith("/'")) {
            path = (String)path + "/";
        }
        for (VirtualFile child : virtualFile.getChildren()) {
            if (!child.exists()) continue;
            if (child.isDirectory()) {
                this.processVirtualFile(child, (String)path + child.getName(), archiveContext);
                continue;
            }
            final String name = child.getPathName();
            final String relativeName = (String)path + child.getName();
            final VirtualFileInputStreamAccess inputStreamAccess = new VirtualFileInputStreamAccess(name, child);
            ArchiveEntry entry = new ArchiveEntry(){

                public String getName() {
                    return name;
                }

                public String getNameWithinArchive() {
                    return relativeName;
                }

                public InputStreamAccess getStreamAccess() {
                    return inputStreamAccess;
                }
            };
            archiveContext.obtainArchiveEntryHandler(entry).handleEntry(entry, archiveContext);
        }
    }

    public ArchiveEntry findEntry(String path) {
        if (path.equals("META-INF/orm.xml")) {
            for (final VirtualFile child : this.root.getChildren()) {
                if (!"orm.xml".equals(child.getName())) continue;
                final String relativeName = path;
                final VirtualFileInputStreamAccess inputStreamAccess = new VirtualFileInputStreamAccess(child.getName(), child);
                return new ArchiveEntry(){

                    public String getName() {
                        return child.getName();
                    }

                    public String getNameWithinArchive() {
                        return relativeName;
                    }

                    public InputStreamAccess getStreamAccess() {
                        return inputStreamAccess;
                    }
                };
            }
        }
        return null;
    }
}

