/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.persistence.jipijapa.hibernate7.cache;

import java.io.IOException;
import java.util.Objects;
import java.util.OptionalInt;
import org.hibernate.cache.internal.NaturalIdCacheKey;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class NaturalIdCacheKeyMarshaller
implements ProtoStreamMarshaller<NaturalIdCacheKey> {
    private static final int VALUES_INDEX = 1;
    private static final int ENTITY_INDEX = 2;
    private static final int TENANT_INDEX = 3;
    private static final int HASH_CODE_INDEX = 4;

    public Class<? extends NaturalIdCacheKey> getJavaClass() {
        return NaturalIdCacheKey.class;
    }

    public NaturalIdCacheKey readFrom(ProtoStreamReader reader) throws IOException {
        Object values = null;
        String entity = null;
        String tenant = null;
        OptionalInt hashCode = OptionalInt.empty();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    values = reader.readAny();
                    break;
                }
                case 2: {
                    entity = reader.readString();
                    break;
                }
                case 3: {
                    tenant = reader.readString();
                    break;
                }
                case 4: {
                    hashCode = OptionalInt.of(reader.readSFixed32());
                }
            }
        }
        return new NaturalIdCacheKey(values, entity, tenant, hashCode.orElse(Objects.hashCode(values)));
    }

    public void writeTo(ProtoStreamWriter writer, NaturalIdCacheKey key) throws IOException {
        int hashCode;
        String tenant;
        String entity;
        Object values = key.getNaturalIdValues();
        if (values != null) {
            writer.writeAny(1, values);
        }
        if ((entity = key.getEntityName()) != null) {
            writer.writeString(2, entity);
        }
        if ((tenant = key.getTenantId()) != null) {
            writer.writeString(3, tenant);
        }
        if ((hashCode = key.hashCode()) != Objects.hashCode(values)) {
            writer.writeSFixed32(4, hashCode);
        }
    }
}

