/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import org.jboss.logmanager.handlers.ConsoleHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Target {
    CONSOLE{

        public String toString() {
            return "console";
        }
    }
    ,
    SYSTEM_OUT{

        public String toString() {
            return "System.out";
        }
    }
    ,
    SYSTEM_ERR{

        public String toString() {
            return "System.err";
        }
    };


    public static Target fromString(String value) {
        if ("System.out".equalsIgnoreCase(value)) {
            return SYSTEM_OUT;
        }
        if ("System.err".equalsIgnoreCase(value)) {
            return SYSTEM_ERR;
        }
        if ("console".equalsIgnoreCase(value)) {
            return CONSOLE;
        }
        if (value.equalsIgnoreCase(ConsoleHandler.Target.SYSTEM_OUT.name())) {
            return SYSTEM_OUT;
        }
        if (value.equalsIgnoreCase(ConsoleHandler.Target.SYSTEM_ERR.name())) {
            return SYSTEM_ERR;
        }
        if (value.equalsIgnoreCase(ConsoleHandler.Target.CONSOLE.name())) {
            return CONSOLE;
        }
        return SYSTEM_OUT;
    }
}

