/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.spi;

import org.hibernate.models.jandex.spi.JandexTypeSwitch;
import org.hibernate.models.spi.ModelsContext;
import org.jboss.jandex.Type;

public class JandexTypeSwitcher {
    public static <T> T switchType(Type type, JandexTypeSwitch<T> typeSwitch, ModelsContext modelContext) {
        switch (type.kind()) {
            case CLASS: {
                return typeSwitch.caseClass(type.asClassType(), modelContext);
            }
            case PRIMITIVE: {
                return typeSwitch.casePrimitive(type.asPrimitiveType(), modelContext);
            }
            case VOID: {
                return typeSwitch.caseVoid(type.asVoidType(), modelContext);
            }
            case ARRAY: {
                return typeSwitch.caseArrayType(type.asArrayType(), modelContext);
            }
            case PARAMETERIZED_TYPE: {
                return typeSwitch.caseParameterizedType(type.asParameterizedType(), modelContext);
            }
            case WILDCARD_TYPE: {
                return typeSwitch.caseWildcardType(type.asWildcardType(), modelContext);
            }
            case TYPE_VARIABLE: {
                return typeSwitch.caseTypeVariable(type.asTypeVariable(), modelContext);
            }
            case TYPE_VARIABLE_REFERENCE: {
                return typeSwitch.caseTypeVariableReference(type.asTypeVariableReference(), modelContext);
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
        return typeSwitch.defaultCase(type, modelContext);
    }
}

