/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process.logging;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.process.logging.ProcessLogger;
import org.jboss.as.version.Stability;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class ProcessLogger_$logger
extends DelegatingBasicLogger
implements ProcessLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProcessLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ProcessLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void attemptToReconnectNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attemptToReconnectNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToReconnectNonExistentProcess$str() {
        return "WFLYPC0001: Attempted to reconnect non-existent process '%s'";
    }

    @Override
    public final void attemptToRemoveNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attemptToRemoveNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToRemoveNonExistentProcess$str() {
        return "WFLYPC0002: Attempted to remove non-existent process '%s'";
    }

    @Override
    public final void attemptToStartNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attemptToStartNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToStartNonExistentProcess$str() {
        return "WFLYPC0003: Attempted to start non-existent process '%s'";
    }

    @Override
    public final void attemptToStopNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attemptToStopNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToStopNonExistentProcess$str() {
        return "WFLYPC0004: Attempted to stop non-existent process '%s'";
    }

    @Override
    public final void duplicateProcessName(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.duplicateProcessName$str(), (Object)processName);
    }

    protected String duplicateProcessName$str() {
        return "WFLYPC0005: Attempted to register duplicate named process '%s'";
    }

    @Override
    public final void failedToSendAuthKey(String processName, Throwable error) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToSendAuthKey$str(), (Object)processName, (Object)error);
    }

    protected String failedToSendAuthKey$str() {
        return "WFLYPC0006: Failed to send authentication key to process '%s': %s";
    }

    @Override
    public final void failedToSendDataBytes(Throwable cause, String processName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToSendDataBytes$str(), (Object)processName);
    }

    protected String failedToSendDataBytes$str() {
        return "WFLYPC0007: Failed to send data bytes to process '%s' input stream";
    }

    @Override
    public final void failedToSendReconnect(Throwable cause, String processName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToSendReconnect$str(), (Object)processName);
    }

    protected String failedToSendReconnect$str() {
        return "WFLYPC0008: Failed to send reconnect message to process '%s' input stream";
    }

    @Override
    public final void failedToStartProcess(Throwable cause, String processName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToStartProcess$str(), (Object)processName);
    }

    protected String failedToStartProcess$str() {
        return "WFLYPC0009: Failed to start process '%s'";
    }

    @Override
    public final void failedToWriteMessage(String messageType, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToWriteMessage$str(), (Object)messageType, (Object)t);
    }

    protected String failedToWriteMessage$str() {
        return "WFLYPC0010: Failed to write %s message to connection: %s";
    }

    @Override
    public final void processFinished(String processName, int exitCode) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.processFinished$str(), (Object)processName, (Object)exitCode);
    }

    protected String processFinished$str() {
        return "WFLYPC0011: Process '%s' finished with an exit status of %d";
    }

    @Override
    public final void receivedInvalidVersion(InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.receivedInvalidVersion$str(), (Object)address);
    }

    protected String receivedInvalidVersion$str() {
        return "WFLYPC0012: Received connection with invalid version from %s";
    }

    @Override
    public final void receivedUnknownGreetingCode(int code, InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.receivedUnknownGreetingCode$str(), (Object)code, (Object)address);
    }

    protected String receivedUnknownGreetingCode$str() {
        return "WFLYPC0013: Received unrecognized greeting code 0x%02x from %s";
    }

    @Override
    public final void receivedUnknownCredentials(InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.receivedUnknownCredentials$str(), (Object)address);
    }

    protected String receivedUnknownCredentials$str() {
        return "WFLYPC0014: Received connection with unknown credentials from %s";
    }

    @Override
    public final void receivedUnknownMessageCode(int code) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.receivedUnknownMessageCode$str(), (Object)code);
    }

    protected String receivedUnknownMessageCode$str() {
        return "WFLYPC0015: Received unknown message with code 0x%02x";
    }

    @Override
    public final void shutdownComplete() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shutdownComplete$str(), new Object[0]);
    }

    protected String shutdownComplete$str() {
        return "WFLYPC0016: All processes finished; exiting";
    }

    @Override
    public final void shuttingDown() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shuttingDown$str(), new Object[0]);
    }

    protected String shuttingDown$str() {
        return "WFLYPC0017: Shutting down process controller";
    }

    @Override
    public final void startingProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingProcess$str(), (Object)processName);
    }

    protected String startingProcess$str() {
        return "WFLYPC0018: Starting process '%s'";
    }

    @Override
    public final void stoppingProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppingProcess$str(), (Object)processName);
    }

    protected String stoppingProcess$str() {
        return "WFLYPC0019: Stopping process '%s'";
    }

    @Override
    public final void streamProcessingFailed(String processName, Throwable error) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.streamProcessingFailed$str(), (Object)processName, (Object)error);
    }

    protected String streamProcessingFailed$str() {
        return "WFLYPC0020: Stream processing failed for process '%s': %s";
    }

    @Override
    public final void waitingToRestart(int seconds, String processName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.waitingToRestart$str(), (Object)seconds, (Object)processName);
    }

    protected String waitingToRestart$str() {
        return "WFLYPC0021: Waiting %d seconds until trying to restart process %s.";
    }

    @Override
    public final void failedToKillProcess(String process) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToKillProcess$str(), (Object)process);
    }

    protected String failedToKillProcess$str() {
        return "WFLYPC0022: Failed to kill process '%s', trying to destroy the process instead.";
    }

    protected String argUsage$str() {
        return "Usage: %s [args...]%nwhere args include:";
    }

    @Override
    public final String argUsage(String executableName) {
        return String.format(this.getLoggingLocale(), this.argUsage$str(), executableName);
    }

    protected String argBackup$str() {
        return "Keep a copy of the persistent domain configuration even if this host is not the Domain Controller. If ignore-unused-configuration is unset in host.xml, then the complete domain configuration will be stored, otherwise the configured value of ignore-unused-configuration will be used.";
    }

    @Override
    public final String argBackup() {
        return String.format(this.getLoggingLocale(), this.argBackup$str(), new Object[0]);
    }

    protected String argCachedDc$str() {
        return "If this host is not the Domain Controller and cannot contact the Domain Controller at boot, a locally cached copy of the domain configuration is used for boot (if available, see --backup.) The Domain Controller is background polled until it becomes available. Note that starting a host with --cached-dc when the Domain Controller is available will cache a copy of the domain configuration even if --backup is not used.";
    }

    @Override
    public final String argCachedDc() {
        return String.format(this.getLoggingLocale(), this.argCachedDc$str(), new Object[0]);
    }

    protected String argDomainConfig$str() {
        return "Name of the domain configuration file to use (default is \"domain.xml\") (Same as -c)";
    }

    @Override
    public final String argDomainConfig() {
        return String.format(this.getLoggingLocale(), this.argDomainConfig$str(), new Object[0]);
    }

    protected String argShortDomainConfig$str() {
        return "Name of the domain configuration file to use (default is \"domain.xml\") (Same as --domain-config)";
    }

    @Override
    public final String argShortDomainConfig() {
        return String.format(this.getLoggingLocale(), this.argShortDomainConfig$str(), new Object[0]);
    }

    protected String argReadOnlyDomainConfig$str() {
        return "Name of the domain configuration file to use. This differs from '--domain-config', '-c' and '-domain-config' in that the initial file is never overwritten.";
    }

    @Override
    public final String argReadOnlyDomainConfig() {
        return String.format(this.getLoggingLocale(), this.argReadOnlyDomainConfig$str(), new Object[0]);
    }

    protected String argHelp$str() {
        return "Display this message and exit";
    }

    @Override
    public final String argHelp() {
        return String.format(this.getLoggingLocale(), this.argHelp$str(), new Object[0]);
    }

    protected String argInterProcessHcAddress$str() {
        return "Address on which the host controller should listen for communication from the process controller";
    }

    @Override
    public final String argInterProcessHcAddress() {
        return String.format(this.getLoggingLocale(), this.argInterProcessHcAddress$str(), new Object[0]);
    }

    protected String argInterProcessHcPort$str() {
        return "Port on which the host controller should listen for communication from the process controller";
    }

    @Override
    public final String argInterProcessHcPort() {
        return String.format(this.getLoggingLocale(), this.argInterProcessHcPort$str(), new Object[0]);
    }

    protected String argHostConfig$str() {
        return "Name of the host configuration file to use (default is \"host.xml\")";
    }

    @Override
    public final String argHostConfig() {
        return String.format(this.getLoggingLocale(), this.argHostConfig$str(), new Object[0]);
    }

    protected String argReadOnlyHostConfig$str() {
        return "Name of the host configuration file to use. This differs from '--host-config' in that the initial file is never overwritten.";
    }

    @Override
    public final String argReadOnlyHostConfig() {
        return String.format(this.getLoggingLocale(), this.argReadOnlyHostConfig$str(), new Object[0]);
    }

    protected String argPcAddress$str() {
        return "Address on which the process controller listens for communication from processes it controls";
    }

    @Override
    public final String argPcAddress() {
        return String.format(this.getLoggingLocale(), this.argPcAddress$str(), new Object[0]);
    }

    protected String argPcPort$str() {
        return "Port on which the process controller listens for communication from processes it controls";
    }

    @Override
    public final String argPcPort() {
        return String.format(this.getLoggingLocale(), this.argPcPort$str(), new Object[0]);
    }

    protected String argProperties$str() {
        return "Load system properties from the given url";
    }

    @Override
    public final String argProperties() {
        return String.format(this.getLoggingLocale(), this.argProperties$str(), new Object[0]);
    }

    protected String argSystem$str() {
        return "Set a system property";
    }

    @Override
    public final String argSystem() {
        return String.format(this.getLoggingLocale(), this.argSystem$str(), new Object[0]);
    }

    protected String argVersion$str() {
        return "Print version and exit";
    }

    @Override
    public final String argVersion() {
        return String.format(this.getLoggingLocale(), this.argVersion$str(), new Object[0]);
    }

    protected String argPublicBindAddress$str() {
        return "Set system property jboss.bind.address to the given value";
    }

    @Override
    public final String argPublicBindAddress() {
        return String.format(this.getLoggingLocale(), this.argPublicBindAddress$str(), new Object[0]);
    }

    protected String argInterfaceBindAddress$str() {
        return "Set system property jboss.bind.address.<interface> to the given value";
    }

    @Override
    public final String argInterfaceBindAddress() {
        return String.format(this.getLoggingLocale(), this.argInterfaceBindAddress$str(), new Object[0]);
    }

    protected String argDefaultMulticastAddress$str() {
        return "Set system property jboss.default.multicast.address to the given value";
    }

    @Override
    public final String argDefaultMulticastAddress() {
        return String.format(this.getLoggingLocale(), this.argDefaultMulticastAddress$str(), new Object[0]);
    }

    protected String argAdminOnly$str() {
        return "Set the host controller's running type to ADMIN_ONLY causing it to open administrative interfaces and accept management requests but not start servers or, if this host controller is the primary for the domain, accept incoming connections from secondary host controllers.";
    }

    @Override
    public final String argAdminOnly() {
        return String.format(this.getLoggingLocale(), this.argAdminOnly$str(), new Object[0]);
    }

    protected String argMasterAddress$str() {
        return "Set system property jboss.domain.primary.address to the given value. In a default secondary Host Controller config, this is used to configure the address of the primary Host Controller.";
    }

    @Override
    public final String argMasterAddress() {
        return String.format(this.getLoggingLocale(), this.argMasterAddress$str(), new Object[0]);
    }

    protected String argMasterPort$str() {
        return "Set system property jboss.domain.primary.port to the given value. In a default secondary Host Controller config, this is used to configure the port used for native management communication by the primary Host Controller.";
    }

    @Override
    public final String argMasterPort() {
        return String.format(this.getLoggingLocale(), this.argMasterPort$str(), new Object[0]);
    }

    protected String argSecMgr$str() {
        return "Runs the server with a security manager installed.";
    }

    @Override
    public final String argSecMgr() {
        return String.format(this.getLoggingLocale(), this.argSecMgr$str(), new Object[0]);
    }

    protected String argStability$str() {
        return "Runs the server using a specific stability level.  Possible values: %s, Default = %s";
    }

    @Override
    public final String argStability(Set<Stability> stabilities, Stability defaultStability) {
        return String.format(this.getLoggingLocale(), this.argStability$str(), stabilities, defaultStability);
    }

    protected String noArgValue$str() {
        return "WFLYPC0023: No value was provided for argument %s";
    }

    @Override
    public final String noArgValue(String argument) {
        return String.format(this.getLoggingLocale(), this.noArgValue$str(), argument);
    }

    protected String invalidAuthKeyLen$str() {
        return "WFLYPC0025: Authentication key must be 24 bytes long";
    }

    @Override
    public final IllegalArgumentException invalidAuthKeyLen() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidAuthKeyLen$str(), new Object[0]));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String invalidLength$str() {
        return "WFLYPC0029: %s length is invalid";
    }

    @Override
    public final IllegalArgumentException invalidLength(String parameterName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidLength$str(), parameterName));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidOption$str() {
        return "WFLYPC0030: Invalid option: %s";
    }

    @Override
    public final IllegalArgumentException invalidOption(String option) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidOption$str(), option));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullCommandComponent$str() {
        return "WFLYPC0031: Command contains a null component";
    }

    @Override
    public final IllegalArgumentException nullCommandComponent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullCommandComponent$str(), new Object[0]));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToAcceptConnection(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToAcceptConnection$str(), new Object[0]);
    }

    protected String failedToAcceptConnection$str() {
        return "WFLYPC0033: Failed to accept a connection";
    }

    @Override
    public final void failedToCloseResource(Throwable cause, Object resource) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseResource$str(), resource);
    }

    protected String failedToCloseResource$str() {
        return "WFLYPC0034: Failed to close resource %s";
    }

    @Override
    public final void failedToCloseServerSocket(Throwable cause, ServerSocket socket) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseServerSocket$str(), (Object)socket);
    }

    protected String failedToCloseServerSocket$str() {
        return "WFLYPC0035: Failed to close the server socket %s";
    }

    @Override
    public final void failedToCloseSocket(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseSocket$str(), new Object[0]);
    }

    protected String failedToCloseSocket$str() {
        return "WFLYPC0036: Failed to close a socket";
    }

    @Override
    public final void failedToHandleIncomingConnection(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToHandleIncomingConnection$str(), new Object[0]);
    }

    protected String failedToHandleIncomingConnection$str() {
        return "WFLYPC0039: Failed to handle incoming connection";
    }

    @Override
    public final void failedToHandleSocketFailure(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToHandleSocketFailure$str(), new Object[0]);
    }

    protected String failedToHandleSocketFailure$str() {
        return "WFLYPC0040: Failed to handle socket failure condition";
    }

    @Override
    public final void failedToHandleSocketFinished(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToHandleSocketFinished$str(), new Object[0]);
    }

    protected String failedToHandleSocketFinished$str() {
        return "WFLYPC0041: Failed to handle socket finished condition";
    }

    @Override
    public final void failedToHandleSocketShutdown(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToHandleSocketShutdown$str(), new Object[0]);
    }

    protected String failedToHandleSocketShutdown$str() {
        return "WFLYPC0042: Failed to handle socket shut down condition";
    }

    @Override
    public final void failedToReadMessage(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToReadMessage$str(), new Object[0]);
    }

    protected String failedToReadMessage$str() {
        return "WFLYPC0043: Failed to read a message";
    }

    @Override
    public final void leakedMessageOutputStream() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.leakedMessageOutputStream$str(), new Object[0]);
    }

    protected String leakedMessageOutputStream$str() {
        return "WFLYPC0044: Leaked a message output stream; cleaning";
    }

    protected String failedToCreateServerThread$str() {
        return "WFLYPC0045: Failed to create server thread";
    }

    @Override
    public final IOException failedToCreateServerThread() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.failedToCreateServerThread$str(), new Object[0]));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToReadObject$str() {
        return "WFLYPC0046: Failed to read object";
    }

    @Override
    public final IOException failedToReadObject(Throwable cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.failedToReadObject$str(), new Object[0]), cause);
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidByte0$str() {
        return "WFLYPC0047: Invalid byte";
    }

    @Override
    public final UTFDataFormatException invalidByte() {
        UTFDataFormatException result = new UTFDataFormatException(String.format(this.getLoggingLocale(), this.invalidByte0$str(), new Object[0]));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidByte2$str() {
        return "WFLYPC0048: Invalid byte:%s(%d)";
    }

    @Override
    public final UTFDataFormatException invalidByte(char c, int i) {
        UTFDataFormatException result = new UTFDataFormatException(String.format(this.getLoggingLocale(), this.invalidByte2$str(), Character.valueOf(c), i));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidByteToken$str() {
        return "WFLYPC0049: Invalid byte token.  Expecting '%s' received '%s'";
    }

    @Override
    public final IOException invalidByteToken(int expected, byte actual) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidByteToken$str(), expected, actual));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCommandByte$str() {
        return "WFLYPC0050: Invalid command byte read: %s";
    }

    @Override
    public final IOException invalidCommandByte(int commandByte) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidCommandByte$str(), commandByte));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStartChunk$str() {
        return "WFLYPC0051: Invalid start chunk start [%s]";
    }

    @Override
    public final IOException invalidStartChunk(int chunk) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidStartChunk$str(), chunk));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String readBytes$str() {
        return "WFLYPC0056: Read %d bytes.";
    }

    @Override
    public final EOFException readBytes(int bytesRead) {
        EOFException result = new EOFException(String.format(this.getLoggingLocale(), this.readBytes$str(), bytesRead));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String streamClosed$str() {
        return "WFLYPC0058: Stream closed";
    }

    @Override
    public final IOException streamClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.streamClosed$str(), new Object[0]));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String threadCreationRefused$str() {
        return "WFLYPC0059: Thread creation was refused";
    }

    @Override
    public final IllegalStateException threadCreationRefused() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.threadCreationRefused$str(), new Object[0]));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedEndOfStream$str() {
        return "WFLYPC0060: Unexpected end of stream";
    }

    @Override
    public final EOFException unexpectedEndOfStream() {
        EOFException result = new EOFException(String.format(this.getLoggingLocale(), this.unexpectedEndOfStream$str(), new Object[0]));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String writeChannelClosed$str() {
        return "WFLYPC0061: Write channel closed";
    }

    @Override
    public final IOException writeChannelClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.writeChannelClosed$str(), new Object[0]));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String writesAlreadyShutdown$str() {
        return "WFLYPC0062: Writes are already shut down";
    }

    @Override
    public final IOException writesAlreadyShutdown() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.writesAlreadyShutdown$str(), new Object[0]));
        ProcessLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void attemptingToKillProcess(String process, long timeout) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.attemptingToKillProcess$str(), (Object)process, (Object)timeout);
    }

    protected String attemptingToKillProcess$str() {
        return "WFLYPC0063: Process '%s' did not complete normal stop within %d ms; attempting to kill process using OS calls";
    }

    @Override
    public final void jpsCommandNotFound(String process) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jpsCommandNotFound$str(), (Object)process);
    }

    protected String jpsCommandNotFound$str() {
        return "WFLYPC0064: Cannot locate process '%s' -- could not find the 'jps' command";
    }

    @Override
    public final void processNotFound(String process) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.processNotFound$str(), (Object)process);
    }

    protected String processNotFound$str() {
        return "WFLYPC0065: No process identifiable as '%s' could be found";
    }

    @Override
    public final void multipleProcessesFound(String process) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.multipleProcessesFound$str(), (Object)process);
    }

    protected String multipleProcessesFound$str() {
        return "WFLYPC0066: Multiple processes identifiable as '%s' found; OS level kill cannot be safely performed";
    }

    @Override
    public final void destroyingProcess(String process, long timeout) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.destroyingProcess$str(), (Object)process, (Object)timeout);
    }

    protected String destroyingProcess$str() {
        return "WFLYPC0067: Process '%s' did not complete normal stop within %d ms; attempting to destroy process using java.lang.Process.destroyForcibly()";
    }
}

