/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import jakarta.enterprise.concurrent.ContextService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jboss.as.ee.concurrent.ContextServiceTypesConfiguration;
import org.jboss.as.ee.concurrent.WildFlyContextService;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.EE10ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.ThreadLocalStack;

public class ConcurrentContext {
    public static final String CONTEXT_HANDLE_FACTORY_NAME = "CONCURRENT_CONTEXT";
    private static final ThreadLocalStack<ConcurrentContext> current = new ThreadLocalStack();
    private final Map<String, ContextHandleFactory> factoryMap = new HashMap<String, ContextHandleFactory>();
    private List<ContextHandleFactory> factoryOrderedList;
    private volatile ServiceName serviceName;

    public static void pushCurrent(ConcurrentContext context) {
        current.push((Object)context);
    }

    public static ConcurrentContext popCurrent() {
        return (ConcurrentContext)current.pop();
    }

    public static ConcurrentContext current() {
        return (ConcurrentContext)current.peek();
    }

    public void setServiceName(ServiceName serviceName) {
        this.serviceName = serviceName;
    }

    public synchronized void addFactory(ContextHandleFactory factory) {
        String factoryName = factory.getName();
        if (this.factoryMap.containsKey(factoryName)) {
            throw EeLogger.ROOT_LOGGER.factoryAlreadyExists(this.toString(), factoryName);
        }
        this.factoryMap.put(factoryName, factory);
        Comparator<ContextHandleFactory> comparator = new Comparator<ContextHandleFactory>(){

            @Override
            public int compare(ContextHandleFactory o1, ContextHandleFactory o2) {
                return Integer.compare(o1.getChainPriority(), o2.getChainPriority());
            }
        };
        TreeSet<ContextHandleFactory> sortedSet = new TreeSet<ContextHandleFactory>(comparator);
        sortedSet.addAll(this.factoryMap.values());
        this.factoryOrderedList = new ArrayList<ContextHandleFactory>(sortedSet);
    }

    public SetupContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        ContextServiceTypesConfiguration contextServiceTypesConfiguration = ((WildFlyContextService)contextService).getContextServiceTypesConfiguration();
        ArrayList<SetupContextHandle> handles = new ArrayList<SetupContextHandle>(this.factoryOrderedList.size());
        for (ContextHandleFactory factory : this.factoryOrderedList) {
            if (factory instanceof EE10ContextHandleFactory) {
                EE10ContextHandleFactory ee10ContextHandleFactory = (EE10ContextHandleFactory)factory;
                String contextType = ee10ContextHandleFactory.getContextType();
                SetupContextHandle setupContextHandle = contextServiceTypesConfiguration.isCleared(contextType) ? ee10ContextHandleFactory.clearedContext(contextService, contextObjectProperties) : (contextServiceTypesConfiguration.isPropagated(contextType) ? ee10ContextHandleFactory.propagatedContext(contextService, contextObjectProperties) : (contextServiceTypesConfiguration.isUnchanged(contextType) ? ee10ContextHandleFactory.unchangedContext(contextService, contextObjectProperties) : null));
                if (setupContextHandle == null) continue;
                handles.add(setupContextHandle);
                continue;
            }
            if (!contextServiceTypesConfiguration.isPropagated("Application")) continue;
            handles.add(factory.saveContext(contextService, contextObjectProperties));
        }
        return new ChainedSetupContextHandle(this, handles);
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    private static class ChainedSetupContextHandle
    implements SetupContextHandle {
        private static final long serialVersionUID = 3609876437062603461L;
        private transient ConcurrentContext concurrentContext;
        private transient List<SetupContextHandle> setupHandles;

        private ChainedSetupContextHandle(ConcurrentContext concurrentContext, List<SetupContextHandle> setupHandles) {
            this.concurrentContext = concurrentContext;
            this.setupHandles = setupHandles;
        }

        @Override
        public ResetContextHandle setup() throws IllegalStateException {
            LinkedList<ResetContextHandle> resetHandles = new LinkedList<ResetContextHandle>();
            ChainedResetContextHandle resetContextHandle = new ChainedResetContextHandle(resetHandles);
            try {
                ConcurrentContext.pushCurrent(this.concurrentContext);
                for (SetupContextHandle handle : this.setupHandles) {
                    resetHandles.addFirst(handle.setup());
                }
            }
            catch (Error | RuntimeException e) {
                resetContextHandle.reset();
                throw e;
            }
            return resetContextHandle;
        }

        @Override
        public String getFactoryName() {
            return ConcurrentContext.CONTEXT_HANDLE_FACTORY_NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.concurrentContext.serviceName);
            out.write(this.setupHandles.size());
            ContextHandleFactory factory = null;
            String factoryName = null;
            for (SetupContextHandle handle : this.setupHandles) {
                factoryName = handle.getFactoryName();
                factory = this.concurrentContext.factoryMap.get(factoryName);
                if (factory == null) {
                    throw EeLogger.ROOT_LOGGER.factoryNotFound(this.concurrentContext.toString(), factoryName);
                }
                out.writeUTF(factoryName);
                factory.writeSetupContextHandle(handle, out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Module module;
            try {
                module = Module.getBootModuleLoader().loadModule("org.jboss.as.ee");
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
            SecurityManager sm = System.getSecurityManager();
            ClassLoader classLoader = sm == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(Thread.currentThread()::getContextClassLoader);
            if (sm == null) {
                Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            } else {
                AccessController.doPrivileged(() -> {
                    Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
                    return null;
                });
            }
            try {
                in.defaultReadObject();
                ServiceName serviceName = (ServiceName)in.readObject();
                ServiceController serviceController = ConcurrentContext.currentServiceContainer().getService(serviceName);
                if (serviceController == null) {
                    throw EeLogger.ROOT_LOGGER.concurrentContextServiceNotInstalled(serviceName);
                }
                this.concurrentContext = (ConcurrentContext)serviceController.getValue();
                this.setupHandles = new ArrayList<SetupContextHandle>();
                ContextHandleFactory factory = null;
                String factoryName = null;
                for (int i = in.read(); i > 0; --i) {
                    factoryName = in.readUTF();
                    factory = this.concurrentContext.factoryMap.get(factoryName);
                    if (factory == null) {
                        throw EeLogger.ROOT_LOGGER.factoryNotFound(this.concurrentContext.toString(), factoryName);
                    }
                    this.setupHandles.add(factory.readSetupContextHandle(in));
                }
            }
            finally {
                if (sm == null) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                } else {
                    AccessController.doPrivileged(() -> {
                        Thread.currentThread().setContextClassLoader(classLoader);
                        return null;
                    });
                }
            }
        }
    }

    private static class ChainedResetContextHandle
    implements ResetContextHandle {
        private static final long serialVersionUID = 8329909590327062062L;
        private transient List<ResetContextHandle> resetHandles;

        private ChainedResetContextHandle(List<ResetContextHandle> resetHandles) {
            this.resetHandles = resetHandles;
        }

        @Override
        public void reset() {
            if (this.resetHandles != null) {
                for (ResetContextHandle handle : this.resetHandles) {
                    try {
                        handle.reset();
                    }
                    catch (Throwable e) {
                        EeLogger.ROOT_LOGGER.debug((Object)"failed to reset handle", e);
                    }
                }
                this.resetHandles = null;
                ConcurrentContext.popCurrent();
            }
        }

        @Override
        public String getFactoryName() {
            return ConcurrentContext.CONTEXT_HANDLE_FACTORY_NAME;
        }
    }
}

