/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentPersister;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentState;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentType;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ClusterDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.AbstractAgentClusterLink;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingMassIndexingInstructions;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.OutboxPollingEventsLog;

public final class OutboxPollingMassIndexerAgentClusterLink
extends AbstractAgentClusterLink<OutboxPollingMassIndexingInstructions> {
    private static final ClusterDescriptor SINGLE_NODE_CLUSTER_DESCRIPTOR = null;
    private static final ShardAssignmentDescriptor SINGLE_NODE_SHARD_ASSIGNMENT = null;

    public OutboxPollingMassIndexerAgentClusterLink(String agentName, FailureHandler failureHandler, Clock clock, Duration pollingInterval, Duration pulseInterval, Duration pulseExpiration) {
        super(new AgentPersister(AgentType.MASS_INDEXING, agentName, null), failureHandler, clock, pollingInterval, pulseInterval, pulseExpiration);
    }

    @Override
    protected AbstractAgentClusterLink.WriteAction<OutboxPollingMassIndexingInstructions> doPulse(List<Agent> allAgentsInIdOrder, Agent currentSelf) {
        List<Agent> eventProcessors = allAgentsInIdOrder.stream().filter(a -> AgentType.EVENT_PROCESSING.contains((Object)a.getType())).collect(Collectors.toList());
        if (!this.eventProcessorsAreSuspended(eventProcessors)) {
            return (now, self, agentPersister) -> {
                agentPersister.setWaiting(self, SINGLE_NODE_CLUSTER_DESCRIPTOR, SINGLE_NODE_SHARD_ASSIGNMENT);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pollingInterval);
            };
        }
        if (AgentState.SUSPENDED.equals((Object)currentSelf.getState())) {
            return (now, self, agentPersister) -> {
                agentPersister.setWaiting(self, SINGLE_NODE_CLUSTER_DESCRIPTOR, SINGLE_NODE_SHARD_ASSIGNMENT);
                return this.instructCommitAndRetryPulseAfterDelay(now, this.pollingInterval);
            };
        }
        return (now, self, agentPersister) -> {
            agentPersister.setRunning(self, SINGLE_NODE_CLUSTER_DESCRIPTOR);
            return this.instructProceedWithMassIndexing(now);
        };
    }

    private boolean eventProcessorsAreSuspended(List<Agent> eventProcessors) {
        AgentState expectedState = AgentState.SUSPENDED;
        for (Agent eventProcessor : eventProcessors) {
            if (expectedState.equals((Object)eventProcessor.getState())) continue;
            OutboxPollingEventsLog.INSTANCE.agentWaitingForEvents(this.selfReference(), eventProcessor.getReference(), expectedState);
            return false;
        }
        OutboxPollingEventsLog.INSTANCE.agentProcessorsExpired(this.selfReference(), expectedState);
        return true;
    }

    @Override
    protected OutboxPollingMassIndexingInstructions instructCommitAndRetryPulseAfterDelay(Instant now, Duration delay) {
        Instant expiration = now.plus(delay);
        OutboxPollingEventsLog.INSTANCE.agentHoldMassIndexing(this.selfReference(), delay, expiration);
        return new OutboxPollingMassIndexingInstructions(this.clock, expiration, false);
    }

    private OutboxPollingMassIndexingInstructions instructProceedWithMassIndexing(Instant now) {
        Instant expiration = now.plus(this.pulseInterval);
        OutboxPollingEventsLog.INSTANCE.agentProceedMassIndexing(this.selfReference(), this.pulseInterval, expiration);
        return new OutboxPollingMassIndexingInstructions(this.clock, expiration, true);
    }
}

