/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.mapping.impl;

import java.util.Set;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.common.spi.TransactionHelper;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategyStartContext;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingOutboxEventAdditionalMappingProducer;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ConfigurationLog;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.OutboxPollingSearchMapping;
import org.hibernate.search.mapper.orm.tenancy.spi.TenancyConfiguration;

public class OutboxPollingSearchMappingImpl
implements OutboxPollingSearchMapping {
    private static final String COUNT_EVENTS_WITH_STATUS = "select count(e) from " + OutboxPollingOutboxEventAdditionalMappingProducer.ENTITY_NAME + " e where e.status = :status";
    private static final String UPDATE_EVENTS_WITH_STATUS = "update " + OutboxPollingOutboxEventAdditionalMappingProducer.ENTITY_NAME + " e set e.status = :newStatus where e.status = :status";
    private static final String DELETE_EVENTS_WITH_STATUS = "delete " + OutboxPollingOutboxEventAdditionalMappingProducer.ENTITY_NAME + " e where e.status = :status";
    private final TransactionHelper transactionHelper;
    private final SessionFactoryImplementor sessionFactory;
    private final TenancyConfiguration tenancyConfiguration;
    private final Set<String> tenantIds;

    public OutboxPollingSearchMappingImpl(CoordinationStrategyStartContext context, TenancyConfiguration tenancyConfiguration) {
        this.sessionFactory = context.mapping().sessionFactory();
        this.transactionHelper = new TransactionHelper(this.sessionFactory, null);
        this.tenancyConfiguration = tenancyConfiguration;
        this.tenantIds = this.tenancyConfiguration.tenantIdsOrFail();
    }

    @Override
    public long countAbortedEvents() {
        this.checkNoTenant();
        return this.doCountAbortedEvents(SessionFactory::withOptions);
    }

    @Override
    public long countAbortedEvents(String tenantId) {
        this.checkTenant(tenantId);
        return this.doCountAbortedEvents(sf -> sf.withOptions().tenantIdentifier(this.tenancyConfiguration.convert(tenantId)));
    }

    @Override
    public long countAbortedEvents(Object tenantId) {
        this.checkTenant(tenantId);
        return this.doCountAbortedEvents(sf -> sf.withOptions().tenantIdentifier(tenantId));
    }

    private long doCountAbortedEvents(Function<SessionFactory, SessionBuilder> sessionCreator) {
        try (Session session = sessionCreator.apply((SessionFactory)this.sessionFactory).openSession();){
            long l = (Long)this.transactionHelper.inTransaction((SharedSessionContractImplementor)session, () -> {
                Query query = session.createQuery(COUNT_EVENTS_WITH_STATUS, Long.class);
                query.setParameter("status", (Object)OutboxEvent.Status.ABORTED);
                return (Long)query.getSingleResult();
            });
            return l;
        }
    }

    @Override
    public int reprocessAbortedEvents() {
        this.checkNoTenant();
        return this.doReprocessAbortedEvents(SessionFactory::withOptions);
    }

    @Override
    public int reprocessAbortedEvents(String tenantId) {
        this.checkTenant(tenantId);
        return this.doReprocessAbortedEvents(sf -> sf.withOptions().tenantIdentifier(this.tenancyConfiguration.convert(tenantId)));
    }

    @Override
    public int reprocessAbortedEvents(Object tenantId) {
        this.checkTenant(tenantId);
        return this.doReprocessAbortedEvents(sf -> sf.withOptions().tenantIdentifier(tenantId));
    }

    private int doReprocessAbortedEvents(Function<SessionFactory, SessionBuilder> sessionCreator) {
        try (Session session = sessionCreator.apply((SessionFactory)this.sessionFactory).openSession();){
            int n = (Integer)this.transactionHelper.inTransaction((SharedSessionContractImplementor)session, () -> {
                MutationQuery query = session.createMutationQuery(UPDATE_EVENTS_WITH_STATUS);
                query.setParameter("status", (Object)OutboxEvent.Status.ABORTED);
                query.setParameter("newStatus", (Object)OutboxEvent.Status.PENDING);
                return query.executeUpdate();
            });
            return n;
        }
    }

    @Override
    public int clearAllAbortedEvents() {
        this.checkNoTenant();
        return this.doClearAllAbortedEvents(SessionFactory::withOptions);
    }

    @Override
    public int clearAllAbortedEvents(String tenantId) {
        this.checkTenant(tenantId);
        return this.doClearAllAbortedEvents(sf -> sf.withOptions().tenantIdentifier(this.tenancyConfiguration.convert(tenantId)));
    }

    @Override
    public int clearAllAbortedEvents(Object tenantId) {
        this.checkTenant(tenantId);
        return this.doClearAllAbortedEvents(sf -> sf.withOptions().tenantIdentifier(tenantId));
    }

    private int doClearAllAbortedEvents(Function<SessionFactory, SessionBuilder> sessionCreator) {
        try (Session session = sessionCreator.apply((SessionFactory)this.sessionFactory).openSession();){
            int n = (Integer)this.transactionHelper.inTransaction((SharedSessionContractImplementor)session, () -> {
                MutationQuery query = session.createMutationQuery(DELETE_EVENTS_WITH_STATUS);
                query.setParameter("status", (Object)OutboxEvent.Status.ABORTED);
                return query.executeUpdate();
            });
            return n;
        }
    }

    private void checkNoTenant() {
        if (!this.tenantIds.isEmpty()) {
            throw ConfigurationLog.INSTANCE.noTenantIdSpecified(this.tenantIds);
        }
    }

    private void checkTenant(Object tenantId) {
        this.checkTenant(this.tenancyConfiguration.convert(tenantId));
    }

    private void checkTenant(String tenantId) {
        if (this.tenantIds.isEmpty()) {
            throw ConfigurationLog.INSTANCE.multiTenancyNotEnabled(tenantId);
        }
        if (!this.tenantIds.contains(tenantId)) {
            throw this.tenancyConfiguration.invalidTenantId(tenantId);
        }
    }
}

