/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.service;

import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.BinaryServiceInstallerFactory;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceInstaller;

public class FilteredBinaryServiceInstallerProvider
implements Function<BinaryServiceConfiguration, Iterable<ServiceInstaller>> {
    private final Set<? extends BinaryServiceDescriptor<?>> descriptors;

    public FilteredBinaryServiceInstallerProvider(Set<? extends BinaryServiceDescriptor<?>> descriptors) {
        this.descriptors = descriptors;
    }

    @Override
    public Iterable<ServiceInstaller> apply(BinaryServiceConfiguration configuration) {
        Class<BinaryServiceInstallerFactory> factoryClass = BinaryServiceInstallerFactory.class;
        return ServiceLoader.load(factoryClass, factoryClass.getClassLoader()).stream().map(ServiceLoader.Provider::get).filter(factory -> this.descriptors.contains(factory.getServiceDescriptor())).map(factory -> (ServiceInstaller)factory.apply(configuration)).collect(Collectors.toList());
    }
}

