/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.clustering.context.ContextualizerFactory;
import org.wildfly.clustering.context.ThreadContextClassLoaderReference;

public enum DefaultContextualizerFactory implements ContextualizerFactory
{
    INSTANCE;

    private final List<ContextualizerFactory> factories = new LinkedList<ContextualizerFactory>();

    private DefaultContextualizerFactory() {
        this.factories.add(new ContextualizerFactory(){

            @Override
            public Contextualizer createContextualizer(ClassLoader loader) {
                return Contextualizer.withContextProvider(ThreadContextClassLoaderReference.CURRENT.provide(loader));
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                ServiceLoader.load(ContextualizerFactory.class, ContextualizerFactory.class.getClassLoader()).forEach(DefaultContextualizerFactory.this.factories::add);
                return null;
            }
        });
    }

    @Override
    public Contextualizer createContextualizer(ClassLoader loader) {
        ArrayList<Contextualizer> contextualizers = new ArrayList<Contextualizer>(this.factories.size());
        for (ContextualizerFactory factory : this.factories) {
            contextualizers.add(factory.createContextualizer(loader));
        }
        return Contextualizer.composite(contextualizers);
    }
}

