/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.wildfly.clustering.context.ContextualThreadFactory;
import org.wildfly.clustering.context.ThreadContextClassLoaderReference;

public class DefaultThreadFactory
extends ContextualThreadFactory<ClassLoader> {
    public DefaultThreadFactory(final Class<?> targetClass, ClassLoader loader) {
        this(AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

            @Override
            public ThreadGroup run() {
                return new ThreadGroup(targetClass.getSimpleName());
            }
        }), loader);
    }

    public DefaultThreadFactory(ThreadGroup group, ClassLoader loader) {
        this((ThreadFactory)new ThreadGroupThreadFactory(group), loader);
    }

    public DefaultThreadFactory(ThreadFactory factory, ClassLoader loader) {
        super(factory, loader, ThreadContextClassLoaderReference.CURRENT);
    }

    private static class ThreadGroupThreadFactory
    implements ThreadFactory {
        private final AtomicLong index = new AtomicLong();
        private final ThreadGroup group;

        ThreadGroupThreadFactory(ThreadGroup group) {
            this.group = group;
        }

        @Override
        public Thread newThread(final Runnable task) {
            final ThreadGroup group = this.group;
            final String name = String.format("%s - %d", this.group.getName(), this.index.incrementAndGet());
            return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    return new Thread(group, task, name);
                }
            });
        }
    }
}

