/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl;

import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchAnalyzerOptionalComponentsStep;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchAnalyzerTokenizerStep;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionCollector;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionContributor;
import org.hibernate.search.backend.elasticsearch.logging.impl.AnalysisLog;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.AnalyzerDefinition;
import org.hibernate.search.util.common.impl.StringHelper;

class ElasticsearchAnalyzerComponentsStep
implements ElasticsearchAnalyzerTokenizerStep,
ElasticsearchAnalyzerOptionalComponentsStep,
ElasticsearchAnalysisDefinitionContributor {
    private final String name;
    private final AnalyzerDefinition definition = new AnalyzerDefinition();

    ElasticsearchAnalyzerComponentsStep(String name) {
        this.name = name;
        this.definition.setType("custom");
    }

    @Override
    public ElasticsearchAnalyzerOptionalComponentsStep tokenizer(String tokenizerName) {
        this.definition.setTokenizer(tokenizerName);
        return this;
    }

    @Override
    public ElasticsearchAnalyzerOptionalComponentsStep charFilters(String ... names) {
        this.definition.setCharFilters(null);
        for (String charFilterName : names) {
            this.definition.addCharFilter(charFilterName);
        }
        return this;
    }

    @Override
    public ElasticsearchAnalyzerOptionalComponentsStep tokenFilters(String ... names) {
        this.definition.setTokenFilters(null);
        for (String tokenFilterName : names) {
            this.definition.addTokenFilter(tokenFilterName);
        }
        return this;
    }

    @Override
    public void contribute(ElasticsearchAnalysisDefinitionCollector collector) {
        if (StringHelper.isEmpty((String)this.definition.getTokenizer())) {
            throw AnalysisLog.INSTANCE.invalidElasticsearchAnalyzerDefinition(this.name);
        }
        collector.collect(this.name, this.definition);
    }
}

