/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.analysis.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.analysis.impl.ElasticsearchAnalysisDescriptor;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionCollector;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionContributor;
import org.hibernate.search.backend.elasticsearch.logging.impl.AnalysisLog;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.AnalyzerDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.CharFilterDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.NormalizerDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.TokenFilterDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.TokenizerDefinition;
import org.hibernate.search.engine.backend.analysis.AnalyzerDescriptor;
import org.hibernate.search.engine.backend.analysis.NormalizerDescriptor;
import org.hibernate.search.engine.backend.analysis.spi.AnalysisDescriptorRegistry;

public final class ElasticsearchAnalysisDefinitionRegistry
implements AnalysisDescriptorRegistry {
    private final Map<String, AnalyzerDefinition> analyzerDefinitions;
    private final Map<String, NormalizerDefinition> normalizerDefinitions;
    private final Map<String, TokenizerDefinition> tokenizerDefinitions;
    private final Map<String, TokenFilterDefinition> tokenFilterDefinitions;
    private final Map<String, CharFilterDefinition> charFilterDefinitions;

    public ElasticsearchAnalysisDefinitionRegistry() {
        this.analyzerDefinitions = Collections.emptyMap();
        this.normalizerDefinitions = Collections.emptyMap();
        this.tokenizerDefinitions = Collections.emptyMap();
        this.tokenFilterDefinitions = Collections.emptyMap();
        this.charFilterDefinitions = Collections.emptyMap();
    }

    public ElasticsearchAnalysisDefinitionRegistry(ElasticsearchAnalysisDefinitionContributor contributor) {
        this.analyzerDefinitions = new TreeMap<String, AnalyzerDefinition>();
        this.normalizerDefinitions = new TreeMap<String, NormalizerDefinition>();
        this.tokenizerDefinitions = new TreeMap<String, TokenizerDefinition>();
        this.tokenFilterDefinitions = new TreeMap<String, TokenFilterDefinition>();
        this.charFilterDefinitions = new TreeMap<String, CharFilterDefinition>();
        contributor.contribute(new ElasticsearchAnalysisDefinitionCollector(){

            @Override
            public void collect(String name, AnalyzerDefinition definition) {
                ElasticsearchAnalysisDefinitionRegistry.this.analyzerDefinitions.put(name, definition);
            }

            @Override
            public void collect(String name, NormalizerDefinition definition) {
                ElasticsearchAnalysisDefinitionRegistry.this.normalizerDefinitions.put(name, definition);
            }

            @Override
            public void collect(String name, TokenizerDefinition definition) {
                TokenizerDefinition previous = ElasticsearchAnalysisDefinitionRegistry.this.tokenizerDefinitions.putIfAbsent(name, definition);
                if (previous != null && previous != definition) {
                    throw AnalysisLog.INSTANCE.tokenizerNamingConflict(name);
                }
            }

            @Override
            public void collect(String name, TokenFilterDefinition definition) {
                TokenFilterDefinition previous = ElasticsearchAnalysisDefinitionRegistry.this.tokenFilterDefinitions.putIfAbsent(name, definition);
                if (previous != null && previous != definition) {
                    throw AnalysisLog.INSTANCE.tokenFilterNamingConflict(name);
                }
            }

            @Override
            public void collect(String name, CharFilterDefinition definition) {
                CharFilterDefinition previous = ElasticsearchAnalysisDefinitionRegistry.this.charFilterDefinitions.putIfAbsent(name, definition);
                if (previous != null && previous != definition) {
                    throw AnalysisLog.INSTANCE.charFilterNamingConflict(name);
                }
            }
        });
    }

    public Map<String, AnalyzerDefinition> getAnalyzerDefinitions() {
        return Collections.unmodifiableMap(this.analyzerDefinitions);
    }

    public Map<String, NormalizerDefinition> getNormalizerDefinitions() {
        return Collections.unmodifiableMap(this.normalizerDefinitions);
    }

    public Map<String, TokenizerDefinition> getTokenizerDefinitions() {
        return Collections.unmodifiableMap(this.tokenizerDefinitions);
    }

    public Map<String, TokenFilterDefinition> getTokenFilterDefinitions() {
        return Collections.unmodifiableMap(this.tokenFilterDefinitions);
    }

    public Map<String, CharFilterDefinition> getCharFilterDefinitions() {
        return Collections.unmodifiableMap(this.charFilterDefinitions);
    }

    public Optional<? extends AnalyzerDescriptor> analyzerDescriptor(String name) {
        if (this.analyzerDefinitions.containsKey(name)) {
            return Optional.of(new ElasticsearchAnalysisDescriptor(name));
        }
        return Optional.empty();
    }

    public Collection<? extends AnalyzerDescriptor> analyzerDescriptors() {
        HashSet<ElasticsearchAnalysisDescriptor> descriptors = new HashSet<ElasticsearchAnalysisDescriptor>();
        for (String name : this.analyzerDefinitions.keySet()) {
            descriptors.add(new ElasticsearchAnalysisDescriptor(name));
        }
        return Collections.unmodifiableSet(descriptors);
    }

    public Optional<? extends NormalizerDescriptor> normalizerDescriptor(String name) {
        if (this.normalizerDefinitions.containsKey(name)) {
            return Optional.of(new ElasticsearchAnalysisDescriptor(name));
        }
        return Optional.empty();
    }

    public Collection<? extends NormalizerDescriptor> normalizerDescriptors() {
        return this.normalizerDefinitions.keySet().stream().map(ElasticsearchAnalysisDescriptor::new).collect(Collectors.toUnmodifiableSet());
    }
}

