/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl.ElasticsearchAnalysisConfigurationContextImpl;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexSettings;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexRootBuilder;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchLinkImpl;
import org.hibernate.search.backend.elasticsearch.index.DynamicMapping;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.logging.impl.AnalysisLog;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchMiscLog;
import org.hibernate.search.backend.elasticsearch.logging.impl.MappingLog;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSimpleWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.resources.impl.BackendThreads;
import org.hibernate.search.backend.elasticsearch.types.dsl.provider.impl.ElasticsearchIndexFieldTypeFactoryProvider;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchPropertyMappingValidatorProvider;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.mapping.spi.BackendMapperContext;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.backend.spi.BackendStartContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchBackendImpl
implements BackendImplementor,
ElasticsearchBackend {
    private static final OptionalConfigurationProperty<List<BeanReference<? extends ElasticsearchAnalysisConfigurer>>> ANALYSIS_CONFIGURER = ConfigurationProperty.forKey((String)"analysis.configurer").asBeanReference(ElasticsearchAnalysisConfigurer.class).multivalued().build();
    private static final ConfigurationProperty<DynamicMapping> DYNAMIC_MAPPING = ConfigurationProperty.forKey((String)"dynamic_mapping").as(DynamicMapping.class, DynamicMapping::of).withDefault((Object)ElasticsearchIndexSettings.Defaults.DYNAMIC_MAPPING).build();
    private static final OptionalConfigurationProperty<String> SCHEMA_MANAGEMENT_SETTINGS_FILE = ConfigurationProperty.forKey((String)"schema_management.settings_file").asString().build();
    private static final OptionalConfigurationProperty<String> SCHEMA_MANAGEMENT_MAPPING_FILE = ConfigurationProperty.forKey((String)"schema_management.mapping_file").asString().build();
    private final Optional<String> backendName;
    private final EventContext eventContext;
    private final BackendThreads threads;
    private final ElasticsearchLinkImpl link;
    private final ElasticsearchSimpleWorkOrchestrator generalPurposeOrchestrator;
    private final ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider;
    private final Gson userFacingGson;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final IndexManagerBackendContext indexManagerBackendContext;

    ElasticsearchBackendImpl(Optional<String> backendName, EventContext eventContext, BackendThreads threads, ElasticsearchLinkImpl link, ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider, ElasticsearchPropertyMappingValidatorProvider propertyMappingValidatorProvider, Gson userFacingGson, MultiTenancyStrategy multiTenancyStrategy, FailureHandler failureHandler, TimingSource timingSource) {
        this.backendName = backendName;
        this.eventContext = eventContext;
        this.threads = threads;
        this.link = link;
        this.generalPurposeOrchestrator = new ElasticsearchSimpleWorkOrchestrator("Elasticsearch general purpose orchestrator - " + eventContext.render(), link);
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.typeFactoryProvider = typeFactoryProvider;
        this.userFacingGson = userFacingGson;
        this.indexManagerBackendContext = new IndexManagerBackendContext(this, eventContext, threads, link, userFacingGson, multiTenancyStrategy, failureHandler, timingSource, this.generalPurposeOrchestrator, propertyMappingValidatorProvider);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext.render() + "]";
    }

    public void start(BackendStartContext context) {
        this.threads.onStart(context.configurationPropertySource(), context.beanResolver(), context.threadPoolProvider());
        this.link.onStart(context.beanResolver(), this.multiTenancyStrategy, context.configurationPropertySource());
        this.generalPurposeOrchestrator.start(context.configurationPropertySource());
    }

    public CompletableFuture<?> preStop() {
        return this.generalPurposeOrchestrator.preStop();
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.generalPurposeOrchestrator);
            closer.push(ElasticsearchLinkImpl::onStop, (Object)this.link);
            closer.push(BackendThreads::onStop, (Object)this.threads);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchBackend.class)) {
            return (T)this;
        }
        throw ElasticsearchMiscLog.INSTANCE.backendUnwrappingWithUnknownType(clazz, ElasticsearchBackend.class, this.eventContext);
    }

    public Optional<String> name() {
        return this.backendName;
    }

    public Backend toAPI() {
        return this;
    }

    @Override
    public <T> T client(Class<T> clientClass) {
        return this.link.getClient().unwrap(clientClass);
    }

    public IndexManagerBuilder createIndexManagerBuilder(String hibernateSearchIndexName, String mappedTypeName, BackendBuildContext buildContext, BackendMapperContext backendMapperContext, ConfigurationPropertySource propertySource) {
        EventContext indexEventContext = EventContexts.fromIndexName((String)hibernateSearchIndexName);
        ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry = this.createAnalysisDefinitionRegistry(buildContext, indexEventContext, propertySource);
        return new ElasticsearchIndexManagerBuilder(this.indexManagerBackendContext, this.createIndexSchemaRootNodeBuilder(indexEventContext, backendMapperContext, hibernateSearchIndexName, mappedTypeName, analysisDefinitionRegistry, this.customIndexSettings(buildContext, propertySource, indexEventContext), this.customIndexMappings(buildContext, propertySource, indexEventContext), (DynamicMapping)((Object)DYNAMIC_MAPPING.get(propertySource))), this.createDocumentMetadataContributors(mappedTypeName));
    }

    private ElasticsearchIndexRootBuilder createIndexSchemaRootNodeBuilder(EventContext indexEventContext, BackendMapperContext backendMapperContext, String hibernateSearchIndexName, String mappedTypeName, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, IndexSettings customIndexSettings, RootTypeMapping customIndexMapping, DynamicMapping dynamicMapping) {
        ElasticsearchIndexRootBuilder builder = new ElasticsearchIndexRootBuilder(this.typeFactoryProvider, indexEventContext, backendMapperContext, hibernateSearchIndexName, mappedTypeName, analysisDefinitionRegistry, customIndexSettings, customIndexMapping, dynamicMapping);
        this.link.getTypeNameMapping().getIndexSchemaRootContributor().ifPresent(builder::addSchemaRootContributor);
        this.link.getTypeNameMapping().getImplicitFieldContributor().ifPresent(builder::addImplicitFieldContributor);
        this.multiTenancyStrategy.indexSchemaRootContributor().ifPresent(builder::addSchemaRootContributor);
        return builder;
    }

    private ElasticsearchAnalysisDefinitionRegistry createAnalysisDefinitionRegistry(BackendBuildContext buildContext, EventContext indexEventContext, ConfigurationPropertySource propertySource) {
        try {
            BeanResolver beanResolver = buildContext.beanResolver();
            return ANALYSIS_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).map(holder -> {
                try (BeanHolder configurerHolder = holder;){
                    ElasticsearchAnalysisConfigurationContextImpl collector = new ElasticsearchAnalysisConfigurationContextImpl();
                    for (ElasticsearchAnalysisConfigurer configurer : (List)configurerHolder.get()) {
                        configurer.configure(collector);
                    }
                    ElasticsearchAnalysisDefinitionRegistry elasticsearchAnalysisDefinitionRegistry = new ElasticsearchAnalysisDefinitionRegistry(collector);
                    return elasticsearchAnalysisDefinitionRegistry;
                }
            }).orElseGet(ElasticsearchAnalysisDefinitionRegistry::new);
        }
        catch (Exception e) {
            throw AnalysisLog.INSTANCE.unableToApplyAnalysisConfiguration(e.getMessage(), e, indexEventContext);
        }
    }

    private List<DocumentMetadataContributor> createDocumentMetadataContributors(String mappedTypeName) {
        ArrayList<DocumentMetadataContributor> contributors = new ArrayList<DocumentMetadataContributor>();
        this.link.getTypeNameMapping().getDocumentMetadataContributor(mappedTypeName).ifPresent(contributors::add);
        this.multiTenancyStrategy.documentMetadataContributor().ifPresent(contributors::add);
        return contributors;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private IndexSettings customIndexSettings(BackendBuildContext buildContext, ConfigurationPropertySource propertySource, EventContext indexEventContext) {
        Optional schemaManagementSettingsFile = (Optional)SCHEMA_MANAGEMENT_SETTINGS_FILE.get(propertySource);
        if (!schemaManagementSettingsFile.isPresent()) {
            return null;
        }
        String filePath = (String)schemaManagementSettingsFile.get();
        try (InputStream inputStream = buildContext.resourceResolver().locateResourceStream(filePath);){
            IndexSettings indexSettings;
            if (inputStream == null) {
                throw MappingLog.INSTANCE.customIndexSettingsFileNotFound(filePath, indexEventContext);
            }
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                indexSettings = (IndexSettings)this.userFacingGson.fromJson((Reader)reader, IndexSettings.class);
            }
            return indexSettings;
        }
        catch (IOException e) {
            throw MappingLog.INSTANCE.customIndexSettingsErrorOnLoading(filePath, e.getMessage(), e, indexEventContext);
        }
        catch (JsonSyntaxException e) {
            throw MappingLog.INSTANCE.customIndexSettingsJsonSyntaxErrors(filePath, e.getMessage(), (Exception)((Object)e), indexEventContext);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private RootTypeMapping customIndexMappings(BackendBuildContext buildContext, ConfigurationPropertySource propertySource, EventContext indexEventContext) {
        Optional schemaManagementMappingsFile = (Optional)SCHEMA_MANAGEMENT_MAPPING_FILE.get(propertySource);
        if (!schemaManagementMappingsFile.isPresent()) {
            return null;
        }
        String filePath = (String)schemaManagementMappingsFile.get();
        try (InputStream inputStream = buildContext.resourceResolver().locateResourceStream(filePath);){
            RootTypeMapping rootTypeMapping;
            if (inputStream == null) {
                throw MappingLog.INSTANCE.customIndexMappingFileNotFound(filePath, indexEventContext);
            }
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                rootTypeMapping = (RootTypeMapping)this.userFacingGson.fromJson((Reader)reader, RootTypeMapping.class);
            }
            return rootTypeMapping;
        }
        catch (IOException e) {
            throw MappingLog.INSTANCE.customIndexMappingErrorOnLoading(filePath, e.getMessage(), e, indexEventContext);
        }
        catch (JsonSyntaxException e) {
            throw MappingLog.INSTANCE.customIndexMappingJsonSyntaxErrors(filePath, e.getMessage(), (Exception)((Object)e), indexEventContext);
        }
    }
}

