/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerImpl;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.scope.impl.ElasticsearchIndexScope;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;

class ElasticsearchIndexScopeBuilder<SR>
implements IndexScopeBuilder<SR> {
    private final IndexManagerBackendContext backendContext;
    private final BackendMappingContext mappingContext;
    private final Class<SR> rootScopeType;
    private final Set<ElasticsearchIndexManagerImpl> indexManagers = new LinkedHashSet<ElasticsearchIndexManagerImpl>();

    ElasticsearchIndexScopeBuilder(IndexManagerBackendContext backendContext, BackendMappingContext mappingContext, Class<SR> rootScopeType, ElasticsearchIndexManagerImpl indexManager) {
        this.backendContext = backendContext;
        this.mappingContext = mappingContext;
        this.rootScopeType = rootScopeType;
        this.indexManagers.add(indexManager);
    }

    void add(IndexManagerBackendContext backendContext, ElasticsearchIndexManagerImpl indexManager) {
        if (!this.backendContext.equals(backendContext)) {
            throw QueryLog.INSTANCE.cannotMixElasticsearchScopeWithOtherBackend(this, indexManager, backendContext.getEventContext());
        }
        this.indexManagers.add(indexManager);
    }

    public IndexScope<SR> build() {
        Set indexModels = this.indexManagers.stream().map(ElasticsearchIndexManagerImpl::model).collect(Collectors.toCollection(LinkedHashSet::new));
        return new ElasticsearchIndexScope<SR>(this.mappingContext, this.backendContext, this.rootScopeType, indexModels);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "backendContext=" + this.backendContext + ", indexManagers=" + this.indexManagers + "]";
    }
}

